/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorHolder;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationAreaDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.CoreReg;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DominantMineralDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthInterval;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleRow;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.map.register.RegInfo;

public class DepthIntervalSegmentation
extends AbstractSegmentation {
    private static final double epsilon = 1.0E-10;
    private DepthIntervalParameter depthInterval = new DepthIntervalParameter("intervals", "Intervals", "10", "");

    public DepthIntervalSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.depthInterval);
        this.addOutput("value");
    }

    public DepthIntervalParameter getDepthInterval() {
        return this.depthInterval;
    }

    @Override
    public String getOutputName(int n) {
        return "Depth interval reg.";
    }

    public static SampleSegmentationColumn mergeSamplesByIntervals(SampleSegmentationColumn sampleSegmentationColumn) {
        Object object2;
        ArrayList<SampleRow> arrayList = new ArrayList<SampleRow>();
        for (Object object2 : sampleSegmentationColumn) {
            arrayList.add(new SampleRow(List.of(object2)));
        }
        ArrayList<SampleRow> arrayList2 = DepthIntervalSegmentation.mergeSampleRowsByIntervals(arrayList);
        object2 = new SampleSegmentationColumn();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            SampleRow sampleRow = (SampleRow)iterator.next();
            ((ArrayList)object2).add((Sample)sampleRow.getFirst());
        }
        return object2;
    }

    public static ArrayList<SampleRow> mergeSampleRowsByIntervals(ArrayList<SampleRow> arrayList) {
        ArrayList<SampleRow> arrayList2 = new ArrayList<SampleRow>();
        DepthIntervalSegmentation.sortSampleRowsOnStartDepth(arrayList);
        List<DepthInterval> list = DepthIntervalSegmentation.getDepthIntervalsForSamples(DepthIntervalSegmentation.getSegmentation((Sample)arrayList.getFirst().getFirst()), arrayList);
        int n = 0;
        for (DepthInterval depthInterval : list) {
            ArrayList<DepthInterval> arrayList3 = new ArrayList<DepthInterval>();
            while (n < arrayList.size()) {
                SampleRow sampleRow = arrayList.get(n);
                DepthInterval depthInterval2 = null;
                for (Sample sample : sampleRow) {
                    if (depthInterval2 == null) {
                        depthInterval2 = new DepthInterval(sample);
                        continue;
                    }
                    depthInterval2.getSampleRow().add(sample);
                }
                if (depthInterval.contains(depthInterval2)) {
                    arrayList3.add(depthInterval2);
                } else if (depthInterval.precedes(depthInterval2)) break;
                ++n;
            }
            if (arrayList3.size() > 0) {
                depthInterval.setSampleRow(DepthIntervalSegmentation.mergeList(depthInterval, arrayList3, arrayList));
            }
            arrayList2.add(depthInterval.getSampleRow());
        }
        return arrayList2;
    }

    private static Sample createEmptyMergedSample(final Sample sample, DepthInterval depthInterval) {
        RootSample rootSample = new RootSample(){

            @Override
            public int getSegmentationLevel() {
                return sample.getSegmentationLevel();
            }

            @Override
            public String getIndexString() {
                return "";
            }
        };
        rootSample.setParentMeasurement(new MeasurementWithoutIO(sample.measurement().getParent()){

            @Override
            public String getName() {
                return "Empty";
            }
        });
        DepthIntervalSegmentation.setDefaultValues(rootSample, depthInterval, sample.getDescriptorHolder());
        rootSample.getSamplePath().setAverageProfile(new float[sample.getSamplePath().getAverageProfile().length]);
        return rootSample;
    }

    private static List<DepthInterval> getDepthIntervalsForSamples(DepthIntervalSegmentation depthIntervalSegmentation, ArrayList<SampleRow> arrayList) {
        int n;
        SampleRow sampleRow = arrayList.getLast();
        DepthInterval depthInterval = new DepthInterval((Sample)sampleRow.getFirst());
        Measurement measurement = ((Sample)sampleRow.getFirst()).measurement();
        double d = Math.max(DepthIntervalSegmentation.getLoggingEndDepth(measurement), depthInterval.end);
        ArrayList<DepthInterval> arrayList2 = new ArrayList<DepthInterval>();
        ArrayList<Sample> arrayList3 = new ArrayList<Sample>();
        block0: for (int i = 0; i < sampleRow.size(); ++i) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                if (arrayList.get(n).get(i) == null) continue;
                arrayList3.add((Sample)arrayList.get(n).get(i));
                continue block0;
            }
        }
        List<DepthIntervalParameter.DepthIntervalSegmentationRule> list = depthIntervalSegmentation.getDepthInterval().getIntervalRules();
        for (n = 0; n < list.size(); ++n) {
            DepthIntervalParameter.DepthIntervalSegmentationRule depthIntervalSegmentationRule = list.get(n);
            double d2 = depthIntervalSegmentationRule.startingFrom;
            double d3 = d;
            if (n + 1 < list.size()) {
                d3 = list.get((int)(n + 1)).startingFrom;
            }
            d3 -= 1.0E-10;
            if (depthIntervalSegmentationRule.magnitudePerInterval == 0.0) {
                throw new IllegalArgumentException("Cannot merge into interval size of 0");
            }
            for (double d4 = d2; d4 < d3; d4 += depthIntervalSegmentationRule.magnitudePerInterval) {
                DepthInterval depthInterval2 = new DepthInterval(d4, d4 + depthIntervalSegmentationRule.magnitudePerInterval);
                for (Sample sample : arrayList3) {
                    Sample sample2 = DepthIntervalSegmentation.createEmptyMergedSample(sample, depthInterval2);
                    depthInterval2.getSampleRow().add(sample2);
                }
                arrayList2.add(depthInterval2);
            }
        }
        return arrayList2;
    }

    private static double getLoggingEndDepth(Measurement measurement) {
        float f = RtDataFormat.toNumberFloat(measurement.getMetaProperties().getMetaValue("Resolution", "1"));
        SpatialDescriptor.SiUnit siUnit = measurement.getWorkflow().getDefaultUnit();
        double d = measurement.getProperties().getPropertyDoubleLocal("logging/endDepth", 0.0);
        CoreReg coreReg = measurement.getCoreReg();
        if (coreReg.version == 0 && siUnit.checkOldFactor()) {
            return d * (double)f * siUnit.getOldFactor();
        }
        return d * (double)f * siUnit.getFactor();
    }

    private static void setDefaultValues(Sample sample, DepthInterval depthInterval, DescriptorHolder descriptorHolder) {
        for (Map.Entry<String, FunctionResult> entry : descriptorHolder.entrySet()) {
            DescriptorTreeNode descriptorTreeNode = entry.getValue().getNode();
            sample.getDescriptorHolder().putFunctionResult(entry.getKey(), new FunctionResult(descriptorTreeNode, DepthIntervalSegmentation.getDefaultValue(descriptorTreeNode, depthInterval)));
        }
    }

    private static float getDefaultValue(DescriptorTreeNode descriptorTreeNode, DepthInterval depthInterval) {
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        if (abstractBreezeFunction instanceof DepthDescriptor) {
            if (descriptorTreeNode.getIndex() == 0) {
                return (float)depthInterval.start;
            }
            if (descriptorTreeNode.getIndex() == 1) {
                return (float)depthInterval.end;
            }
            if (descriptorTreeNode.getIndex() == 2) {
                return (float)depthInterval.length;
            }
        }
        return 0.0f;
    }

    private static void sortSampleRowsOnStartDepth(ArrayList<SampleRow> arrayList) {
        arrayList.sort(Comparator.comparingDouble(sampleRow -> new DepthInterval((Sample)((Sample)sampleRow.getFirst())).start));
    }

    public static DepthIntervalSegmentation getSegmentation(Sample sample) {
        AbstractBreezeFunction abstractBreezeFunction;
        Workflow workflow = sample.measurement().getWorkflow();
        FunctionTreeNodeWithId functionTreeNodeWithId = workflow.getAnalyseTree().getTreeNodeById(sample.getSegmentationHashId());
        if (functionTreeNodeWithId != null && (abstractBreezeFunction = functionTreeNodeWithId.getFunction()) instanceof DepthIntervalSegmentation) {
            DepthIntervalSegmentation depthIntervalSegmentation = (DepthIntervalSegmentation)abstractBreezeFunction;
            return depthIntervalSegmentation;
        }
        FunctionTreeNode functionTreeNode = SegmentationNode.getParentNode(functionTreeNodeWithId);
        while (functionTreeNode != null) {
            AbstractBreezeFunction abstractBreezeFunction2 = functionTreeNode.getFunction();
            if (abstractBreezeFunction2 instanceof DepthIntervalSegmentation) {
                abstractBreezeFunction = (DepthIntervalSegmentation)abstractBreezeFunction2;
                return abstractBreezeFunction;
            }
            if (functionTreeNode.isRoot()) {
                throw new RuntimeException("Cannot find Depth interval segmentation with id: " + sample.getSegmentationHashId());
            }
            functionTreeNode = SegmentationNode.getParentNode(functionTreeNode);
        }
        throw new RuntimeException("No samples available");
    }

    public static Sample makeMergedSample(DepthInterval depthInterval, Sample sample) {
        final String string = sample.getIndexString();
        final Measurement measurement = sample.measurement();
        Sample sample2 = new Sample((Sample)sample.getParent(), sample.getSegmentationHashId()){

            @Override
            public String getIndexString() {
                return string;
            }

            @Override
            public Measurement measurement() {
                return measurement;
            }
        };
        DepthIntervalSegmentation.setDefaultValues(sample2, depthInterval, sample.getDescriptorHolder());
        return sample2;
    }

    public static Sample findSampleToUseAsEmptyTemplate(ArrayList<SampleRow> arrayList, int n) {
        Sample sample = null;
        for (SampleRow sampleRow : arrayList) {
            if (sampleRow.get(n) == null) continue;
            sample = (Sample)sampleRow.get(n);
            break;
        }
        return sample;
    }

    public static Sample findSampleToUseAsMergeTemplate(ArrayList<DepthInterval> arrayList, int n) {
        Sample sample = null;
        for (DepthInterval depthInterval : arrayList) {
            SampleRow sampleRow = depthInterval.getSampleRow();
            if (sampleRow.get(n) == null) continue;
            sample = (Sample)sampleRow.get(n);
            break;
        }
        return sample;
    }

    public static float calculateActualTotalLength(ArrayList<DepthInterval> arrayList, int n) {
        float f = 0.0f;
        for (DepthInterval depthInterval : arrayList) {
            Sample sample = (Sample)depthInterval.getSampleRow().get(n);
            if (sample == null) continue;
            f = (float)((double)f + new DepthInterval((Sample)sample).length);
        }
        return f;
    }

    public static SampleRow mergeList(DepthInterval depthInterval, ArrayList<DepthInterval> arrayList, ArrayList<SampleRow> arrayList2) {
        if (arrayList.stream().allMatch(Objects::isNull)) {
            return null;
        }
        SampleRow sampleRow = new SampleRow();
        int n = arrayList.getFirst().getSampleRow().size();
        for (int i = 0; i < n; ++i) {
            Sample sample = DepthIntervalSegmentation.findSampleToUseAsMergeTemplate(arrayList, i);
            if (sample == null) {
                sample = DepthIntervalSegmentation.createEmptyMergedSample(DepthIntervalSegmentation.findSampleToUseAsEmptyTemplate(arrayList2, i), depthInterval);
            }
            Sample sample2 = DepthIntervalSegmentation.makeMergedSample(depthInterval, sample);
            DescriptorHolder descriptorHolder = sample2.getDescriptorHolder();
            float f = DepthIntervalSegmentation.calculateActualTotalLength(arrayList, i);
            float[] fArray = new float[sample.getSamplePath().getAverageProfile().length];
            double d = 0.0;
            int n2 = 0;
            for (DepthInterval depthInterval2 : arrayList) {
                Sample sample3 = (Sample)depthInterval2.getSampleRow().get(i);
                if (sample3 == null) continue;
                DescriptorHolder descriptorHolder2 = sample3.getDescriptorHolder();
                for (Map.Entry<String, FunctionResult> entry : descriptorHolder2.entrySet()) {
                    FunctionResult functionResult = descriptorHolder.getFunctionResult(entry.getKey());
                    float f2 = 0.0f;
                    if (functionResult != null) {
                        f2 += functionResult.getValue();
                    }
                    FunctionResult functionResult2 = entry.getValue();
                    DescriptorTreeNode descriptorTreeNode = functionResult2.getNode();
                    float f3 = functionResult2.getValue();
                    switch (DepthIntervalSegmentation.getType(descriptorTreeNode).ordinal()) {
                        case 0: {
                            f2 = (float)((double)f2 + (double)f3 * (depthInterval2.length / (double)f));
                            break;
                        }
                        case 1: {
                            f2 += f3;
                            break;
                        }
                        case 2: {
                            f2 = Math.min(functionResult != null ? f2 : f3, f3);
                            break;
                        }
                        case 3: {
                            f2 = Math.max(functionResult != null ? f2 : f3, f3);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            Integer n3 = sample3.getPixelCount();
                            if (n3 != null) {
                                if (n3 < n2) break;
                                n2 = n3;
                                f2 = f3;
                                break;
                            }
                            if (!(depthInterval2.length >= d)) break;
                            d = depthInterval2.length;
                            f2 = f3;
                        }
                    }
                    descriptorHolder.putFunctionResult(entry.getKey(), new FunctionResult(descriptorTreeNode, f2));
                }
                Object object = sample3.getSamplePath().getAverageProfile();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    int n4 = j;
                    fArray[n4] = (float)((double)fArray[n4] + (double)object[j] * (depthInterval2.length / (double)f));
                }
            }
            sample2.getSamplePath().setAverageProfile(fArray);
            sample2.getSamplePath().setSelectionPaths(sample.getSamplePath().getSelectionPaths());
            sampleRow.add(sample2);
        }
        return sampleRow;
    }

    private static MergeType getType(DescriptorTreeNode descriptorTreeNode) {
        Object object;
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        int n = descriptorTreeNode.getIndex();
        if (abstractBreezeFunction instanceof DepthDescriptor) {
            switch (n) {
                case 0: {
                    return MergeType.Min;
                }
                case 1: {
                    return MergeType.Max;
                }
                case 2: {
                    return MergeType.Max;
                }
                case 3: {
                    return MergeType.Original;
                }
            }
        }
        if (abstractBreezeFunction instanceof SpatialDescriptor && ((SpatialDescriptor.Unit)((Object)(object = SpatialDescriptor.Unit.values()[n]))).isSi()) {
            return MergeType.Sum;
        }
        if (abstractBreezeFunction instanceof DominantMineralDescriptor || abstractBreezeFunction instanceof UsgsDescriptor || abstractBreezeFunction instanceof MwlDescriptor) {
            return MergeType.MaxArea;
        }
        if (abstractBreezeFunction instanceof PlsPredClassificationAreaDescriptor && !((PlsPredClassificationAreaDescriptor)(object = (PlsPredClassificationAreaDescriptor)abstractBreezeFunction)).getPercentParameter().getValueBool()) {
            return MergeType.Sum;
        }
        return MergeType.Average;
    }

    public static class DepthIntervalParameter
    extends TextParameter {
        public DepthIntervalParameter(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }

        public List<DepthIntervalSegmentationRule> getIntervalRules() {
            String[] stringArray;
            ArrayList<DepthIntervalSegmentationRule> arrayList = new ArrayList<DepthIntervalSegmentationRule>();
            String string = this.getValueStr();
            for (String string2 : stringArray = string.split(";")) {
                String[] stringArray2 = string2.split(":");
                if (stringArray2.length == 2) {
                    arrayList.add(new DepthIntervalSegmentationRule(RtDataFormat.toNumber(stringArray2[0]), RtDataFormat.toNumber(stringArray2[1])));
                    continue;
                }
                arrayList.add(new DepthIntervalSegmentationRule(0.0, 0.0));
            }
            if (arrayList.isEmpty()) {
                arrayList.add(new DepthIntervalSegmentationRule(0.0, 0.0));
            }
            return arrayList;
        }

        public record DepthIntervalSegmentationRule(double startingFrom, double magnitudePerInterval) {
        }
    }

    private static enum MergeType {
        Average,
        Sum,
        Min,
        Max,
        Original,
        MaxArea;

    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "depth";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new DepthIntervalSegmentation(this);
        }

        public String toString() {
            return "DepthIntervalSegmentation";
        }

        @Override
        public String getName() {
            return "Depth interval registration";
        }

        @Override
        public String getDescription() {
            return "Depth interval registration";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Geo;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Geo;
        }

        @Override
        public String getHelp() {
            return "depth-interval-registration-segmentation";
        }
    }
}

