/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.AbstractHolderSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.entry.workflow.Workflow;

public class GridInsetsSegmentation
extends AbstractHolderSegmentation {
    private IDParameter.LinkedIDParameter.AppliesToLinkIDParameter appliesTo;
    private GridTypeParameter gridTypeParameter;
    private UnitParameter siTypeParameter;

    public GridInsetsSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo, 0);
        TextParameter textParameter = new TextParameter("grid", "Grid", "3x3", "Columns x Rows");
        this.gridTypeParameter = new GridTypeParameter(textParameter);
        this.addParameter(this.gridTypeParameter, 1);
        this.addParameter(textParameter, 1);
        this.siTypeParameter = new UnitParameter();
        this.addParameter(this.siTypeParameter, 1);
        this.siTypeParameter.setVisible(() -> "Area".equalsIgnoreCase(this.gridTypeParameter.getValueStr()));
        this.addParameter(new TextParameter("insets", "Insets", "0;0;0;0", "Top;Left;Bottom;Right"), 1);
        this.addParameter(new BooleanParameter("percent", "Percent", "Insets in percent or pixels", true), 1);
        this.addParameter(new TextParameter("gap", "Gap", "0;0", "Column;Row gap in pixels"), 1);
        this.appliesTo = new IDParameter.LinkedIDParameter.AppliesToLinkIDParameter("appliesTo", "Applies to", "");
        this.addParameter(this.appliesTo);
        this.addOutput("value");
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    @Override
    public String appliesTo() {
        return this.appliesTo.getValueStr();
    }

    public static class GridTypeParameter
    extends TextParameter {
        private final TextParameter gridParameter;

        public GridTypeParameter(TextParameter textParameter) {
            super("type", "Type", "Columns x Rows", "");
            this.gridParameter = textParameter;
        }

        @Override
        public boolean setValue(Object object) {
            if ("Area".equals(object)) {
                this.gridParameter.setAlias("Area");
                this.gridParameter.setUsage("Width x Height");
            } else {
                this.gridParameter.setAlias("Grid");
                this.gridParameter.setUsage("Columns x Rows");
            }
            return super.setValue(object);
        }

        @Override
        public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
            return new String[]{"Grid", "Area"};
        }
    }

    public static class UnitParameter
    extends OptionParameter {
        public UnitParameter() {
            super("unit", "Unit", "px", "");
            this.add(new OptionParameter.Option("px", "Pixels"));
            for (SpatialDescriptor.SiUnit siUnit : SpatialDescriptor.SiUnit.values()) {
                this.add(new OptionParameter.Option(siUnit.getUnit(), siUnit.getDescription()));
            }
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public AbstractBreezeFunction createFunction() {
            return new GridInsetsSegmentation(this);
        }

        public String toString() {
            return "GridInsetsSegmentation";
        }

        @Override
        public String getName() {
            return "Grid and insets";
        }

        @Override
        public String getDescription() {
            return "Grid and insets";
        }

        @Override
        public String getImageIcon() {
            return "grid";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "grid-and-inset";
        }
    }
}

