/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextEditParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTextEditButtonField;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;
import se.prediktera.map.common.error.Logg;

public class HorizontalIntervalSegmentation
extends AbstractSegmentation {
    private final TextParameter xParameter = new TextEditParameter("x", "Interval", "", "Example: 0;3-5;10-20"){

        @Override
        public void showDialog(BreezeFrame breezeFrame, Workflow workflow, Object object, BreezeTextEditButtonField breezeTextEditButtonField) {
            int n = 0;
            int n2 = 0;
            Measurement measurement = Measurement.getFirstMeasurementWithData(object);
            if (measurement == null) {
                BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No measurement", "No measurement in this Project to use as reference for horizontal interval");
                return;
            }
            try {
                int n3 = HorizontalIntervalSegmentation.this.getWidth(measurement);
                int[][] nArray = HorizontalIntervalSegmentation.this.createIntervals(n3);
                if (nArray.length > 0) {
                    n = nArray[0][0];
                    n2 = Math.max(n3 - nArray[0][1], 0);
                }
            }
            catch (Exception exception) {
                Logg.error((String)"Interval error", (Throwable)exception);
            }
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Horizontal Interval", "", (AbstractBreezeCustomPanel)new CropImagePanel(CropImagePanel.readImage(measurement.getThumbnailFile()), -2147483647, n, Integer.MAX_VALUE, n2, InsetsPanel.InsetsType.WidthOnly), null, breezeActionEvent -> {
                CropImagePanel cropImagePanel = (CropImagePanel)breezeActionEvent.getBreezeCustomPanel();
                breezeTextEditButtonField.setValue(cropImagePanel.left() + "-" + cropImagePanel.rightPos());
            });
        }
    };

    public HorizontalIntervalSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.xParameter);
        this.addOutput("value");
    }

    private int getWidth(Measurement measurement) {
        if (measurement != null) {
            return measurement.rawFile().header().pixelWidth().value;
        }
        return 1;
    }

    private int[][] createIntervals(int n) {
        String string = this.xParameter.getText();
        String[] stringArray = string.split(";");
        int[][] nArrayArray = new int[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("-");
            if (stringArray2.length < 1) continue;
            int n2 = RtDataFormat.toNumberInt(stringArray2[0]);
            HorizontalIntervalSegmentation.checkInterval(n2, n2, string);
            if (stringArray2.length == 1) {
                nArrayArray[i] = new int[]{n2, n};
                continue;
            }
            if (stringArray2.length != 2) continue;
            int n3 = RtDataFormat.toNumberInt(stringArray2[1]);
            HorizontalIntervalSegmentation.checkInterval(n2, n3, string);
            nArrayArray[i] = new int[]{n2, n3};
        }
        return nArrayArray;
    }

    private static void checkInterval(int n, int n2, String string) {
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("Interval must be greater or equal to 1 (" + string + ")");
        }
        if (n2 < n) {
            throw new RuntimeException("To value must be greater than from value (" + n + " - " + n2 + ")");
        }
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "horizon";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new HorizontalIntervalSegmentation(this);
        }

        public String toString() {
            return "SpatialSegmentation";
        }

        @Override
        public String getName() {
            return "Horizontal interval";
        }

        @Override
        public String getDescription() {
            return "Horizontal interval";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "horizontal-interval";
        }
    }
}

