/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Set;
import se.prediktera.breeze.common.util.image.RtIdentifiedObject;
import se.prediktera.breeze.common.util.image.RtObjectValues;
import se.prediktera.breeze.common.util.image.RtPixel3D;

public class IdentifiedShapeObject
extends RtIdentifiedObject {
    public IdentifiedShapeObject(int[][] nArray) {
        this(nArray, RtObjectValues.ObjectMode.all());
    }

    public IdentifiedShapeObject(int[][] nArray, Set<RtObjectValues.ObjectMode> set) {
        super(0);
        this.addShapeToPointListAndAnalyse(this.createGeneralPath(nArray), set);
    }

    public IdentifiedShapeObject(Shape shape) {
        this(shape, RtObjectValues.ObjectMode.all());
    }

    public IdentifiedShapeObject(Shape shape, Set<RtObjectValues.ObjectMode> set) {
        super(0);
        this.addShapeToPointListAndAnalyse(shape, set);
    }

    private GeneralPath createGeneralPath(int[][] nArray) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                generalPath.moveTo(nArray[i][0], nArray[i][1]);
                continue;
            }
            generalPath.lineTo(nArray[i][0], nArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    private void addShapeToPointListAndAnalyse(Shape shape, Set<RtObjectValues.ObjectMode> set) {
        Rectangle rectangle = shape.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 12);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.fill(shape);
        graphics2D.dispose();
        int[] nArray = new int[1];
        WritableRaster writableRaster = bufferedImage.getRaster();
        SampleModel sampleModel = writableRaster.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        for (int i = 0; i < rectangle.width; ++i) {
            for (int j = 0; j < rectangle.height; ++j) {
                sampleModel.getPixel(i, j, nArray, dataBuffer);
                if (nArray[0] <= 0) continue;
                this.pointList.add(new RtPixel3D(rectangle.x + i, rectangle.y + j));
            }
        }
        this.analyseObject(set);
    }
}

