/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.awt.Color;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.segmentation.AbstractHolderSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;

public class IntensitySegmentation
extends AbstractHolderSegmentation {
    private final String version = "1";
    private final IntensityExpressionParameter parameter;
    private final WorkflowAnalyseParameter analyseParameter;
    private final TransformationParameter transformationParameter;
    private final ConvertToParameter convertToParameter = new ConvertToParameter();

    public IntensitySegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.convertToParameter, 1);
        this.parameter = new IntensityExpressionParameter();
        this.addParameter(this.parameter, 1);
        this.transformationParameter = new TransformationParameter();
        this.addParameter(this.transformationParameter, 1);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.addOutput("value");
    }

    @Override
    public void save(Element element) {
        this.getAnalyse();
        super.save(element);
    }

    private int getParameterHashCode() {
        int n = this.convertToParameter.getValueHashCode();
        return n += StringHelper.hashCode(this.parameter.getExpression());
    }

    private RtAnalyse getOrCreateAnalyse(FunctionTreeNode functionTreeNode) {
        RtAnalyse rtAnalyse = MembersSetting.createAnalyse(functionTreeNode, "ExpCla" + this.getParameterHashCode(), this.analyseParameter, string -> {
            RtAnalyse rtAnalyse = new RtAnalyse(string, "Expression", BasicAnalyse.ModelMethod.ClassificationExpression, this.getStudyId(), "1");
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(new RtModelParameters.RtModel("Expression"));
            rtAnalyse.setModelParameters(rtModelParameters);
            CategoryFactor categoryFactor = new CategoryFactor(functionTreeNode.getAliasOrNodeString(), "expcla");
            categoryFactor.addClass("Background", Color.black);
            categoryFactor.addClass("Sample", Color.gray);
            rtAnalyse.getCategoryFactors().add(categoryFactor);
            return rtAnalyse;
        });
        rtAnalyse.setConvertTo(this.convertToParameter.getConvertTo(this.getWorkflow()));
        return rtAnalyse;
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getCategoryFactor();
    }

    public IntensityExpressionParameter getExpression() {
        return this.parameter;
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    public static class ConvertToParameter
    extends OptionParameter {
        public ConvertToParameter() {
            super("convertTo", "Convert To", "Default", "");
            this.add(new OptionParameter.Option("Default", "Default"));
            for (RtFramePredictor.ReferenceConvertTo referenceConvertTo : RtFramePredictor.ReferenceConvertTo.values()) {
                this.add(new OptionParameter.Option(referenceConvertTo.name(), referenceConvertTo.name()));
            }
        }

        public RtFramePredictor.ReferenceConvertTo getConvertTo(Workflow workflow) {
            String string = this.getValueStr();
            if (string.equals("Default")) {
                if (workflow != null) {
                    return workflow.getReferenceConvertTo();
                }
                return null;
            }
            return RtFramePredictor.ReferenceConvertTo.parse(string);
        }

        @Override
        public int getValueHashCode() {
            String string = this.getValueStr();
            if (string.equals("Default")) {
                return 0;
            }
            return StringHelper.hashCode(string);
        }
    }

    public static class IntensityExpressionParameter
    extends ExpressionParameter {
        private SpatialExpression spatialExpression = new SpatialExpression();

        public IntensityExpressionParameter() {
            super("Expression", "id", "Example: b1 > 0.3 or b3 < 0.5 and w750 = 0.2");
            this.add(this.spatialExpression);
        }

        public void set(String string) {
            this.spatialExpression.set(string);
        }

        protected ExpressionParameter.Expression createList(Node node) {
            this.spatialExpression = new SpatialExpression(node);
            return this.spatialExpression;
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "maximum_cutoff";
        }

        @Override
        public IntensitySegmentation createFunction() {
            return new IntensitySegmentation(this);
        }

        public String toString() {
            return "IntensitySegmentation";
        }

        @Override
        public String getName() {
            return "Intensity";
        }

        @Override
        public String getDescription() {
            return "Spectral band intensity-based expression";
        }

        @Override
        public String getShortDescription() {
            return "Intensity";
        }

        @Override
        public String getHelp() {
            return "intensity";
        }
    }

    public static class SpatialExpression
    extends ExpressionParameter.Expression<RtFrame> {
        public SpatialExpression() {
        }

        public SpatialExpression(Node node) {
            super(node);
        }
    }
}

