/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.EnumParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberRangeParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberSliderParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractHolderSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class OnnxSegmentation
extends AbstractHolderSegmentation {
    protected final FileParameter selectedFile;
    protected final OnnxModelTypeParameter typeParameter = new OnnxModelTypeParameter();
    protected final TaskParameter taskParameter;
    private final IDParameter.IDQuantificationParameter sourceParameter;
    private final ModelSegmentation.InverseParameter inverseParameter;

    public OnnxSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.typeParameter, 2);
        this.selectedFile = new FileParameter(this, "file", "Onnx file", "", "Select onnx file"){

            @Override
            public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.setAcceptAllFileFilterUsed(true);
                FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("onnx", "Open Neural Network Exchange (*.onnx)");
                jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
                jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
            }
        };
        this.addParameter(this.selectedFile, 2);
        this.sourceParameter = new IDParameter.IDQuantificationParameter(this, "source", null, ""){

            @Override
            protected List<FunctionTreeNodeWithId> getOptionNodes(FunctionTreeNode functionTreeNode) {
                List<FunctionTreeNodeWithId> list = super.getOptionNodes(functionTreeNode);
                list.addFirst(new FunctionTreeNodeWithId(this, "0"){

                    @Override
                    public AbstractBreezeFunction getFunction() {
                        return null;
                    }

                    @Override
                    public double evaluate(DescriptorInterface descriptorInterface) {
                        return 0.0;
                    }

                    public String toString() {
                        return "Image";
                    }
                });
                return list;
            }
        };
        this.addParameter(this.sourceParameter, 2);
        AnalyseFactorParameter analyseFactorParameter = new AnalyseFactorParameter("factor", this.sourceParameter);
        this.addParameter(analyseFactorParameter, 2);
        analyseFactorParameter.setVisible(() -> !StringHelper.equals((String)"0", (String)this.sourceParameter.getId()));
        this.addParameter(new NumberSliderParameter("confidence", "Confidence", 0.7, "Object confidence threshold", new MinMax(0.0f, 1.0f)), 1);
        this.addParameter(new NumberSliderParameter("iou", "IOU", 0.3, "Threshold for filtering annotations", new MinMax(0.0f, 1.0f)), 1);
        this.addParameter(new NumberRangeParameter("intensityRange", "Intensity threshold", new MinMax(0.0f, 1.0f), "", new MinMax(0.0f, 1.0f), 10.0f), 1);
        NormalizeParameter normalizeParameter = new NormalizeParameter();
        this.addParameter(normalizeParameter, 1);
        normalizeParameter.setVisible(() -> StringHelper.equals((String)this.typeParameter.getText(), (String)"FasterRCNN"));
        OrderParameter orderParameter = new OrderParameter();
        this.addParameter(orderParameter, 1);
        orderParameter.setVisible(() -> StringHelper.equals((String)this.typeParameter.getText(), (String)"FasterRCNN"));
        ActivationKindParameter activationKindParameter = new ActivationKindParameter();
        this.addParameter(activationKindParameter, 1);
        activationKindParameter.setVisible(() -> StringHelper.equals((String)this.typeParameter.getText(), (String)"Yolo5"));
        activationKindParameter = new ActivationKindParameter();
        this.addParameter(activationKindParameter, 1);
        activationKindParameter.setVisible(() -> StringHelper.equalsAny((String)this.typeParameter.getText(), (String[])new String[]{"Yolo8", "Yolo11", "FastSAM"}));
        this.addParameter(new NumberParameter(this, "maxnum", "Max objects", 0.0, "Sorted by confidence"){

            @Override
            public boolean hasValue() {
                return super.hasValue() && this.getValue() > 0.0;
            }
        });
        this.inverseParameter = new ModelSegmentation.InverseParameter();
        this.addParameter(this.inverseParameter);
        this.taskParameter = new TaskParameter();
        this.addParameter(this.taskParameter);
        this.taskParameter.setVisible(false);
        this.addOutput("value");
    }

    @Override
    public boolean isInverse() {
        return this.inverseParameter.getValueBool();
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        File file = this.selectedFile.getFile(this.getWorkflow());
        if (file != null) {
            return FileHelper.getFileName(file);
        }
        Object object = this.typeParameter.getValueObj();
        if (object != null) {
            return object.toString();
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    public static class OnnxModelTypeParameter
    extends EnumParameter {
        private static Enum[] getListValues() {
            ArrayList<OnnxModelType> arrayList = new ArrayList<OnnxModelType>();
            arrayList.add(OnnxModelType.FasterRCNN);
            arrayList.add(OnnxModelType.Yolo4);
            arrayList.add(OnnxModelType.Yolo5);
            arrayList.add(OnnxModelType.Yolo8);
            arrayList.add(OnnxModelType.Yolo11);
            return arrayList.toArray(new Enum[0]);
        }

        private static Enum[] getListValuesInstanceSegmentation() {
            ArrayList<OnnxModelType> arrayList = new ArrayList<OnnxModelType>();
            arrayList.add(OnnxModelType.FastSAM);
            arrayList.add(OnnxModelType.Yolo8);
            arrayList.add(OnnxModelType.Yolo11);
            return arrayList.toArray(new Enum[0]);
        }

        public void setList(TaskParameter.TaskTypes taskTypes) {
            this.setEnums(taskTypes == TaskParameter.TaskTypes.Segmentation ? OnnxModelTypeParameter.getListValuesInstanceSegmentation() : OnnxModelTypeParameter.getListValues());
        }

        public OnnxModelTypeParameter() {
            super("type", "Model type", OnnxModelType.FasterRCNN.name(), "", OnnxModelTypeParameter.getListValues());
        }

        public static enum OnnxModelType {
            FasterRCNN("Faster R-CNN"),
            Yolo4("YOLOv4"),
            Yolo5("YOLOv5"),
            Yolo8("YOLOv8"),
            FastSAM("FastSAM"),
            Yolo11("YOLOv11");

            private final String description;

            private OnnxModelType(String string2) {
                this.description = string2;
            }

            public boolean allowSelectFile() {
                return this != FastSAM;
            }

            public String toString() {
                return this.description;
            }
        }
    }

    public static class NormalizeParameter
    extends OptionParameter<OptionParameter.Option> {
        public NormalizeParameter() {
            super("normalize", "Normalize the pixel values", "0", "");
            this.add(new OptionParameter.Option("0", "No normalization"));
            this.add(new OptionParameter.Option("1", "Normalize and center"));
        }
    }

    public static class OrderParameter
    extends OptionParameter<OptionParameter.Option> {
        public OrderParameter() {
            super("order", "Image dimension order", "0", "");
            this.add(new OptionParameter.Option("0", "Width / Height"));
            this.add(new OptionParameter.Option("1", "Height / Width"));
        }
    }

    public static class ActivationKindParameter
    extends OptionParameter<OptionParameter.Option.OptionNoFormat> {
        public ActivationKindParameter() {
            super("activationKind", "Activation function for scores", "0", "");
            this.add(new OptionParameter.Option.OptionNoFormat("0", "None"));
            this.add(new OptionParameter.Option.OptionNoFormat("1", "Sigmoid"));
            this.add(new OptionParameter.Option.OptionNoFormat("2", "Tanh"));
            this.add(new OptionParameter.Option.OptionNoFormat("3", "ReLU"));
        }
    }

    public static class TaskParameter
    extends EnumParameter {
        private static Enum[] getListValues() {
            ArrayList<TaskTypes> arrayList = new ArrayList<TaskTypes>();
            arrayList.add(TaskTypes.Segmentation);
            arrayList.add(TaskTypes.Detection);
            return arrayList.toArray(new Enum[0]);
        }

        public TaskParameter() {
            super("task", "Model task type", TaskTypes.Detection.name(), "", TaskParameter.getListValues());
        }

        public static enum TaskTypes {
            Segmentation,
            Detection;

        }

        public static enum ListType {
            ObjectDetection,
            InstanceSegmentation;

        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "onnx";
        }

        @Override
        public OnnxSegmentation createFunction() {
            return new OnnxSegmentation(this);
        }

        public String toString() {
            return "OnnxSegmentation";
        }

        @Override
        public String getName() {
            return "Onnx";
        }

        @Override
        public String getDescription() {
            return "Deep Learning image segmentation";
        }

        @Override
        public String getShortDescription() {
            return "Deep Learning segmentation";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "deep-learning-image-segmentation";
        }

        @Override
        public List<String> getKeywords() {
            return List.of("onnx", "yolo", "rcnn", "fastsam", "segment", "anything", "sam");
        }
    }

    public static class SigmoidParameter
    extends OptionParameter<OptionParameter.Option> {
        public SigmoidParameter() {
            super("outputLayer", "Output layer to use", "0", "");
            this.add(new OptionParameter.Option("0", "Sigmoid layer"));
            this.add(new OptionParameter.Option("1", "Detect layer"));
        }
    }
}

