/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractHolderSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class PythonScriptSegmentation
extends AbstractHolderSegmentation {
    private final FileParameter selectedFile = new FileParameter(this, "file", "Python file", "", "Select python script"){

        @Override
        public void customizeDialog(jopensaveDialog jopensaveDialog2) {
            jopensaveDialog2.setDialogTitle("Select python script file");
            jopensaveDialog2.setAcceptAllFileFilterUsed(true);
            FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("py", "Python script (*.py)");
            jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
            jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
        }
    };
    private final FileParameter interpreter;

    public PythonScriptSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.selectedFile, 1);
        this.interpreter = new FileParameter(this, "interpreter", "Python interpreter (optional)", "", "Select python interpreter (empty for system default)"){

            @Override
            public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.setDialogTitle("Select custom python interpreter");
                if (SystemUtils.IS_OS_WINDOWS) {
                    jopensaveDialog2.setAcceptAllFileFilterUsed(true);
                    FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("exe", "Executable (*.exe)");
                    jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
                    jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
                }
            }
        };
        this.addParameter(this.interpreter, 1);
        this.addOutput("value");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        File file = this.selectedFile.getFile(this.getWorkflow());
        if (file != null) {
            return FileHelper.getFileName(file);
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    @Generated
    public FileParameter getSelectedFile() {
        return this.selectedFile;
    }

    @Generated
    public FileParameter getInterpreter() {
        return this.interpreter;
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public PythonScriptSegmentation createFunction() {
            return new PythonScriptSegmentation(this);
        }

        public String toString() {
            return "PythonSegmentation";
        }

        @Override
        public String getName() {
            return "Python";
        }

        @Override
        public String getDescription() {
            return "Python segmentation script runner";
        }

        @Override
        public String getShortDescription() {
            return "Python script";
        }

        @Override
        public String getImageIcon() {
            return "python";
        }

        @Override
        public String getHelp() {
            return "python-script-segmentation";
        }
    }
}

