/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.MinMax;

public class RepresentativeSegmentation
extends AbstractSegmentation {
    public static final int MAX_NUMBER = 10000;
    private final MethodParameter methodParameter = new MethodParameter(this);
    private NumberParameter numberOfClusters;
    private IDParameter appliesTo;
    private TextParameter dimParameter;
    private BooleanParameter uniqueParameter;

    public RepresentativeSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.methodParameter);
        this.addParameter(new NumberParameter("number", "Number", 25.0, "Number of representative spectrum (Max number 10000)", new MinMax(1.0f, 10000.0f)));
        this.uniqueParameter = new BooleanParameter("unique", "Unique", "Add only unique spectrum", false);
        this.addParameter(this.uniqueParameter);
        this.uniqueParameter.setVisible(() -> !this.methodParameter.getValueStr().equals("kmeans"));
        this.dimParameter = new TextParameter("dim", "Dimension", "1x1", "Width x Height (pixels)");
        this.addParameter(this.dimParameter);
        this.dimParameter.setVisible(() -> !this.methodParameter.getValueStr().equals("kmeans"));
        this.numberOfClusters = new NumberParameter("clusters", "Clusters", 2.0, "");
        this.addParameter(this.numberOfClusters);
        this.numberOfClusters.setVisible(() -> this.methodParameter.getValueStr().equals("kmeans"));
        this.appliesTo = new IDParameter.LinkedIDParameter.AppliesToLinkIDParameter("appliesTo", "Applies to", "");
        this.addParameter(this.appliesTo);
        this.addOutput("value");
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string = super.getNodeString(functionTreeNode, n, textType);
        return string;
    }

    @Override
    public String appliesTo() {
        return this.appliesTo.getValueStr();
    }

    public class MethodParameter
    extends OptionParameter {
        public MethodParameter(RepresentativeSegmentation representativeSegmentation) {
            super("method", "Method", "", "");
            this.add(new OptionParameter.Option("evenly", "Evenly Spread"));
            this.add(new OptionParameter.Option("random", "Random"));
            this.add(new OptionParameter.Option("gaussian", "Random (Gaussian)"));
            this.add(new OptionParameter.Option("representative", "Spectral Evenly (PCA)"));
            this.add(new OptionParameter.Option("binning", "Spectral Binning (PCA)"));
            this.add(new OptionParameter.Option("spacefilling", "Spectral Space Filling (PCA - Very slow)"));
            this.add(new OptionParameter.Option("kmeans", "Spectral Clustering (k-means)"));
            this.add(new OptionParameter.Option("centroid", "Spectral Binning (Centroid)"));
            this.setIndex(1);
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "representative";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new RepresentativeSegmentation(this);
        }

        public String toString() {
            return "RepresentativeSegmentation";
        }

        @Override
        public String getName() {
            return "Representative spectrum";
        }

        @Override
        public String getDescription() {
            return "Representative spectrum";
        }

        @Override
        public String getHelp() {
            return "representative-spectrum";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("evenlyspread", "gaussian", "binning", "spacefilling", "clustering", "kmeans");
        }
    }
}

