/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberSliderParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.spatial.OnnxSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class SegmentAnythingSegmentation
extends OnnxSegmentation {
    private final ModelParameter modelTypeParameter;
    private final SizeParameter modelSizeParameter;
    private final HashMap<String, DownloadFile> checkSums = new HashMap();

    public SegmentAnythingSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.modelTypeParameter = new ModelParameter();
        this.addParameter(this.modelTypeParameter, 3);
        this.modelSizeParameter = new SizeParameter();
        this.addParameter(this.modelSizeParameter, 2);
        this.addParameter(new NumberSliderParameter("smooth", "Smoothing", 0.0, "", new MinMax(0.0f, 5.0f), 1.0f), 1);
        OnnxSegmentation.OnnxModelTypeParameter.OnnxModelType onnxModelType = this.getModelType(this.modelTypeParameter.getValueStr());
        this.typeParameter.setVisible(false);
        this.typeParameter.setValue((Object)onnxModelType);
        if (!onnxModelType.allowSelectFile()) {
            this.selectedFile.setValue(this.getFastSamModelFile());
        }
        this.selectedFile.setVisible(() -> this.getModelType(this.modelTypeParameter.getValueStr()).allowSelectFile());
        this.modelSizeParameter.setVisible(() -> !this.getModelType(this.modelTypeParameter.getValueStr()).allowSelectFile());
        this.taskParameter.setValue((Object)OnnxSegmentation.TaskParameter.TaskTypes.Segmentation);
        this.checkSums.put("FastSAM-s_180.onnx", new DownloadFile(189776943L, 47193234));
        this.checkSums.put("FastSAM-s_384.onnx", new DownloadFile(1006332382L, 47238602));
        this.checkSums.put("FastSAM-s_512.onnx", new DownloadFile(2718091305L, 47285648));
        this.checkSums.put("FastSAM-s_640.onnx", new DownloadFile(2887249504L, 47346128));
        this.checkSums.put("FastSAM-s_1024.onnx", new DownloadFile(1938951469L, 47608214));
        this.checkSums.put("FastSAM-x_180.onnx", new DownloadFile(889684838L, 288915007));
        this.checkSums.put("FastSAM-x_384.onnx", new DownloadFile(2331661377L, 288960375));
        this.checkSums.put("FastSAM-x_512.onnx", new DownloadFile(3352881194L, 289007421));
        this.checkSums.put("FastSAM-x_640.onnx", new DownloadFile(1488063054L, 289067901));
        this.checkSums.put("FastSAM-x_1024.onnx", new DownloadFile(2648685270L, 289329987));
    }

    @Override
    public void preRequisiteRuntimeExport(BreezeProgress breezeProgress) {
        if (this.allowSelectFile()) {
            return;
        }
        File file = this.getFastSamModelFile();
        this.selectedFile.setValue(file);
        String string = file.getName();
        if (!file.exists()) {
            if (!this.checkSums.containsKey(string)) {
                throw new IllegalArgumentException("File not supported: " + string);
            }
            DownloadFile downloadFile = this.checkSums.get(string);
            breezeProgress.setInfoText("Downloading model file - " + string);
            Optional<Boolean> optional = FileHelper.download(breezeProgress, downloadFile.getDownloadUrl(string), file, downloadFile.size);
            if (optional.orElse(false).booleanValue()) {
                if (FileUtils.checksumCRC32((File)file) != downloadFile.checksum) {
                    FileUtils.deleteQuietly((File)file);
                    throw new IllegalArgumentException("CRC mismatch");
                }
            } else {
                if (optional.isEmpty()) {
                    FileUtils.deleteQuietly((File)file);
                    throw new ErrorHandler.MessageException("Could not download model files, see how to manually download at:\n\nhttps://help.prediktera.com/breeze/manually-download-sam-model-files", "Could not download model");
                }
                FileUtils.deleteQuietly((File)file);
            }
        } else {
            if (!this.checkSums.containsKey(string)) {
                FileUtils.deleteQuietly((File)file);
                throw new IllegalArgumentException("File not supported");
            }
            if (FileUtils.checksumCRC32((File)file) != this.checkSums.get((Object)string).checksum) {
                FileUtils.deleteQuietly((File)file);
                throw new IllegalArgumentException("CRC mismatch");
            }
        }
        if (!file.getAbsolutePath().equals(this.selectedFile.getValueStr())) {
            this.selectedFile.setValue(file.getAbsolutePath());
        }
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Segment Anything");
        stringBuilder.append("@@(");
        stringBuilder.append(this.typeParameter.getValueStr());
        if (!this.allowSelectFile()) {
            stringBuilder.append("-");
            stringBuilder.append(this.modelSizeParameter.getValueStr());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean allowSelectFile() {
        return this.modelTypeParameter.allowSelectFile(this.modelTypeParameter.getValueObj());
    }

    private OnnxSegmentation.OnnxModelTypeParameter.OnnxModelType getModelType(String string) {
        if (StringHelper.equals((String)string, (String)"8")) {
            return OnnxSegmentation.OnnxModelTypeParameter.OnnxModelType.Yolo8;
        }
        if (StringHelper.equals((String)string, (String)"11")) {
            return OnnxSegmentation.OnnxModelTypeParameter.OnnxModelType.Yolo11;
        }
        return OnnxSegmentation.OnnxModelTypeParameter.OnnxModelType.FastSAM;
    }

    private File getFastSamModelFile() {
        File file = WorkspaceManager.getInstance().getWorkspace().getDownloadPath();
        String string = ((OptionParameter.Option)this.modelTypeParameter.getValueObj()).getDescription();
        String string2 = this.modelSizeParameter.getValueStr();
        String string3 = string + "_" + string2 + ".onnx";
        return new File(file, string3);
    }

    public class ModelParameter
    extends OptionParameter<OptionParameter.Option> {
        public ModelParameter() {
            super("model", "Model Type", "s", "");
            this.add(new OptionParameter.Option("s", "FastSAM-s"));
            this.add(new OptionParameter.Option("x", "FastSAM-x"));
            this.add(new OptionParameter.Option("8", "YOLOv8"));
            this.add(new OptionParameter.Option("11", "YOLO11"));
        }

        @Override
        public boolean setValue(Object object) {
            SegmentAnythingSegmentation.this.typeParameter.setValue((Object)SegmentAnythingSegmentation.this.getModelType(((OptionParameter.Option)object).getName()));
            if (!this.allowSelectFile(object)) {
                SegmentAnythingSegmentation.this.selectedFile.setValue(SegmentAnythingSegmentation.this.getFastSamModelFile());
            } else {
                SegmentAnythingSegmentation.this.selectedFile.setValue("");
            }
            return super.setValue(object);
        }

        public boolean allowSelectFile(Object object) {
            return SegmentAnythingSegmentation.this.getModelType(((OptionParameter.Option)object).getName()).allowSelectFile();
        }

        @Override
        public String getDisplayString() {
            return ((OptionParameter.Option)this.getValueObj()).getDescription();
        }
    }

    public class SizeParameter
    extends OptionParameter<OptionParameter.Option> {
        public SizeParameter() {
            super("size", "Image dimension", "512", "");
            this.add(new OptionParameter.Option("180", "180 x 180"));
            this.add(new OptionParameter.Option("384", "384 x 384"));
            this.add(new OptionParameter.Option("512", "512 x 512"));
            this.add(new OptionParameter.Option("640", "640 x 640"));
            this.add(new OptionParameter.Option("1024", "1024 x 1024"));
        }

        @Override
        public boolean setValue(Object object) {
            SegmentAnythingSegmentation.this.selectedFile.setValue(SegmentAnythingSegmentation.this.getFastSamModelFile());
            return super.setValue(object);
        }
    }

    private record DownloadFile(long checksum, int size) {
        public URL getDownloadUrl(String string) {
            RegInfo regInfo = RegisterKeyManager.getRegInfo();
            return new URI(String.format("https://internal.prediktera.se/api/download?filename=%s&userId=%d&licenseId=%s", URLEncoder.encode(string, StandardCharsets.UTF_8), regInfo.ID, regInfo.LID != 0 ? Integer.toString(regInfo.LID) : "")).toURL();
        }
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "segmentanything";
        }

        @Override
        public SegmentAnythingSegmentation createFunction() {
            return new SegmentAnythingSegmentation(this);
        }

        public String toString() {
            return "SegmentAnythingSegmentation";
        }

        @Override
        public String getName() {
            return "SegmentAnything";
        }

        @Override
        public String getDescription() {
            return "Segment anything image segmentation";
        }

        @Override
        public String getShortDescription() {
            return "Segment Anything";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "segment-anything";
        }

        @Override
        public List<String> getKeywords() {
            return List.of("deep", "dnn", "fastsam", "segment", "anything", "sam", "yolo");
        }
    }
}

