/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class ShapefileSegmentation
extends AbstractSegmentation {
    private final FileParameter parameter = new FileParameter(this, "file", "Shape file", "", "Select shape file"){

        @Override
        public void customizeDialog(jopensaveDialog jopensaveDialog2) {
            jopensaveDialog2.setAcceptAllFileFilterUsed(true);
            FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("shp", "Shape format (*.shp)");
            jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
            jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
        }
    };

    public ShapefileSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(this.parameter);
        this.addParameter(new NumberParameter("radius", "Point radius", 10.0, "Point radius in pixels"));
        this.addOutput("value");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        File file = this.parameter.getFile(this.getWorkflow());
        if (file != null && file.getName().length() > 0) {
            return FileHelper.getFileName(file);
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "layers";
        }

        @Override
        public ShapefileSegmentation createFunction() {
            return new ShapefileSegmentation(this);
        }

        public String toString() {
            return "ShapefileSegmentation";
        }

        @Override
        public String getName() {
            return "Shapefile";
        }

        @Override
        public String getShortDescription() {
            return "Shape file";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getDescription() {
            return "GIS Shape file";
        }

        @Override
        public String getHelp() {
            return "shapefile";
        }
    }
}

