/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.segmentation.spatial;

import java.awt.Rectangle;
import se.prediktera.breeze.common.util.image.RtPixelFloat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class SpatialRectangleObject
implements RtSpatialObject {
    protected final Rectangle boundingbox;
    private final int[][] path;
    private final RtPixelFloat centerpoint;
    private final int width;
    private final int height;
    private final int area;
    private final int circumference;
    private final int orientation;
    private final float regularity;
    private final float roundness;
    private final int d1;
    private final int d2;
    private float resolution = 1.0f;
    private final int max;

    public SpatialRectangleObject(int n, int n2, int n3, int n4) {
        this.path = new int[][]{{n, n2}, {n + n3, n2}, {n + n3, n2 + n4}, {n, n2 + n4}};
        this.boundingbox = new Rectangle(n, n2, n3, n4);
        this.centerpoint = new RtPixelFloat((float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
        this.width = n3;
        this.height = n4;
        this.area = n3 * n4;
        this.circumference = n3 * 2 + n4 * 2;
        this.d1 = Math.max(n3, n4);
        this.d2 = Math.min(n3, n4);
        this.max = this.d2 / 2;
        this.roundness = 1.0f;
        this.regularity = 1.0f;
        this.orientation = 0;
    }

    @Override
    public int[][] getPath() {
        return this.path;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.boundingbox;
    }

    @Override
    public RtPixelFloat getCenterPoint() {
        return this.centerpoint;
    }

    @Override
    public void forEveryPixel(RtSpatialObject.ForEveryPixelCallback forEveryPixelCallback) {
        for (int i = 0; i < this.boundingbox.width; ++i) {
            for (int j = 0; j < this.boundingbox.height; ++j) {
                forEveryPixelCallback.withPixel(this.boundingbox.x + i, this.boundingbox.y + j, 1);
            }
        }
    }

    @Override
    public void setResolution(float f) {
        this.resolution = f;
    }

    @Override
    public float getResolution() {
        return this.resolution;
    }

    @Override
    public int getArea() {
        return this.area;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getCircumference() {
        return this.circumference;
    }

    @Override
    public float getRegularity() {
        return this.regularity;
    }

    @Override
    public float getRoundness() {
        return this.roundness;
    }

    @Override
    public float getOrientation() {
        return this.orientation;
    }

    @Override
    public float getD1() {
        return this.d1;
    }

    @Override
    public float getD2() {
        return this.d2;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    public String toString() {
        return "SpatialRectangleObject [width=" + this.width + ", height=" + this.height + "]";
    }
}

