/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;

public class ASDFileParser {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public SpectrumFileHeader header;
    public SpectrumDataProcessor data;
    private final String name;
    static final byte FLOAT_FORMAT = 0;
    static final byte INTEGER_FORMAT = 1;
    static final byte DOUBLE_FORMAT = 2;
    static final byte UNKNOWN_FORMAT = 3;
    private static final String[] DATA_TYPES = new String[]{"raw", "reflectance", "radiance", "no_units", "irradiance", "qi", "transmittance", "unknown", "absorbance"};
    private static final String[] INSTRUMENTS = new String[]{"unknown", "PSII", "LSVNIR", "FieldSpec VNIR", "FieldSpec FR", "FieldSpec NIR", "CHEM", "FieldSpec FullRange Unattended"};
    private static final int SPECTRUM_DATA_OFFSET = 484;

    public ASDFileParser(File file) {
        this.name = FileHelper.getFileName(file);
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            this.header = new SpectrumFileHeader(randomAccessFile);
            this.data = new SpectrumDataProcessor(this, randomAccessFile, this.header);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static byte readByte(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        return (byte)randomAccessFile.read();
    }

    private static int readUShort(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        byte[] byArray = new byte[2];
        randomAccessFile.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getShort() & 0xFFFF;
    }

    private static int readInt(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt();
    }

    private static float readFloat(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getFloat();
    }

    private static long readLong(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        byte[] byArray = new byte[8];
        randomAccessFile.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getLong();
    }

    private static String readString(RandomAccessFile randomAccessFile, int n, long l) throws IOException {
        randomAccessFile.seek(l);
        byte[] byArray = new byte[n];
        randomAccessFile.readFully(byArray);
        return new String(byArray).trim();
    }

    private static String getDataType(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        int n = randomAccessFile.readUnsignedByte();
        if (n >= 0 && n < DATA_TYPES.length) {
            return DATA_TYPES[n];
        }
        return "unknown";
    }

    private static String getInstrumentName(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
        int n = randomAccessFile.readUnsignedByte();
        if (n >= 0 && n < INSTRUMENTS.length) {
            return INSTRUMENTS[n];
        }
        return "unknown";
    }

    private static Date getDate(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n = ASDFileParser.readInt(randomAccessFile, l);
        return new Date((long)n * 1000L);
    }

    private static TmStructure readTmStructure(RandomAccessFile randomAccessFile, long l) throws IOException {
        TmStructure tmStructure = new TmStructure();
        tmStructure.tm_sec = ASDFileParser.readUShort(randomAccessFile, l);
        tmStructure.tm_min = ASDFileParser.readUShort(randomAccessFile, l + 2L);
        tmStructure.tm_hour = ASDFileParser.readUShort(randomAccessFile, l + 4L);
        tmStructure.tm_mday = ASDFileParser.readUShort(randomAccessFile, l + 6L);
        tmStructure.tm_mon = ASDFileParser.readUShort(randomAccessFile, l + 8L);
        tmStructure.tm_year = ASDFileParser.readUShort(randomAccessFile, l + 10L);
        tmStructure.tm_wday = ASDFileParser.readUShort(randomAccessFile, l + 12L);
        tmStructure.tm_yday = ASDFileParser.readUShort(randomAccessFile, l + 14L);
        tmStructure.tm_isdst = ASDFileParser.readUShort(randomAccessFile, l + 16L);
        tmStructure.tm_year += 1900;
        --tmStructure.tm_mon;
        return tmStructure;
    }

    private static float[] readSpectrumData(RandomAccessFile randomAccessFile, short n, byte by, long l) throws IOException {
        float[] fArray = new float[n];
        int n2 = switch (by) {
            case 0 -> 4;
            case 1 -> 4;
            case 2 -> 8;
            case 3 -> throw new IOException("Unknown spectrum data format");
            default -> throw new IOException("Invalid spectrum data format");
        };
        randomAccessFile.seek(l);
        byte[] byArray = new byte[n * n2];
        randomAccessFile.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        block11: for (int i = 0; i < n; ++i) {
            switch (by) {
                case 0: {
                    fArray[i] = byteBuffer.getFloat();
                    continue block11;
                }
                case 1: {
                    fArray[i] = byteBuffer.getInt();
                    continue block11;
                }
                case 2: {
                    fArray[i] = (float)byteBuffer.getDouble();
                }
            }
        }
        return fArray;
    }

    public Reference getReference() {
        final InformationPanel.InformationList informationList = new InformationPanel.InformationList();
        SpectrumFileHeader spectrumFileHeader = this.data.header;
        informationList.add("Instrument", spectrumFileHeader.instrument);
        informationList.add("Date", sdf.format(spectrumFileHeader.dc_time));
        if (spectrumFileHeader.comments.length() > 0) {
            informationList.add("Comments", spectrumFileHeader.comments);
        }
        Reference reference = new Reference(this, this.name){

            @Override
            public InformationPanel.InformationList getInformation() {
                return informationList;
            }
        };
        reference.setColor(RtPerfectSpread.generateColor(1), false);
        float[] fArray = this.data.getProcessedSpectrum("reflectance");
        FloatMatrix floatMatrix = new FloatMatrix(fArray.length);
        for (int i = 0; i < floatMatrix.rows; ++i) {
            floatMatrix.put(i, fArray[i]);
        }
        reference.setMatrix(floatMatrix);
        reference.setWavelength(this.data.wavelength);
        return reference;
    }

    public static void main(String[] stringArray) {
        ASDFileParser aSDFileParser = new ASDFileParser(new File("C:\\Prediktera\\evince\\BreezeGuiTest\\src\\main\\resources\\spectrum\\asd\\halo.asd"));
        Reference reference = aSDFileParser.getReference();
        for (int i = 0; i < 10 && i < reference.matrix.rows; ++i) {
            System.out.println("Spectrum value " + reference.wavelength[i] + ": " + reference.matrix.get(i));
        }
    }

    public static class SpectrumFileHeader {
        public final String co;
        public final String comments;
        public final TmStructure when;
        public final byte fileVersion;
        public final byte itime;
        public final byte dc_corr;
        public final Date dc_time;
        public final String dataType;
        public final long ref_time;
        public final float startWavelength;
        public final float wavelengthStep;
        public final byte dataFormat;
        public final short channels;
        public final long it;
        public final String instrument;
        public final float swir1Gain;
        public final float swir2Gain;
        public final float splice1Wavelength;
        public final float splice2Wavelength;

        public SpectrumFileHeader(RandomAccessFile randomAccessFile) throws IOException {
            this.co = ASDFileParser.readString(randomAccessFile, 3, 0L);
            this.comments = ASDFileParser.readString(randomAccessFile, 157, 3L);
            this.when = ASDFileParser.readTmStructure(randomAccessFile, 160L);
            this.fileVersion = ASDFileParser.readByte(randomAccessFile, 179L);
            this.itime = ASDFileParser.readByte(randomAccessFile, 180L);
            this.dc_corr = ASDFileParser.readByte(randomAccessFile, 181L);
            this.dc_time = ASDFileParser.getDate(randomAccessFile, 182L);
            this.dataType = ASDFileParser.getDataType(randomAccessFile, 186L);
            this.ref_time = ASDFileParser.readLong(randomAccessFile, 187L);
            this.startWavelength = ASDFileParser.readFloat(randomAccessFile, 191L);
            this.wavelengthStep = ASDFileParser.readFloat(randomAccessFile, 195L);
            this.dataFormat = ASDFileParser.readByte(randomAccessFile, 199L);
            this.channels = (short)ASDFileParser.readUShort(randomAccessFile, 204L);
            this.it = ASDFileParser.readLong(randomAccessFile, 390L);
            this.instrument = ASDFileParser.getInstrumentName(randomAccessFile, 431L);
            this.swir1Gain = ASDFileParser.readInt(randomAccessFile, 436L);
            this.swir2Gain = ASDFileParser.readInt(randomAccessFile, 438L);
            this.splice1Wavelength = ASDFileParser.readFloat(randomAccessFile, 444L);
            this.splice2Wavelength = ASDFileParser.readFloat(randomAccessFile, 448L);
        }
    }

    public class SpectrumDataProcessor {
        public final float[] wavelength;
        public final float[] spectrum;
        public final float[] whiteReference;
        public final SpectrumFileHeader header;
        public final int referenceFlag;
        public final long wrTime;
        public final long spectrumTime;
        public final String specDescription;

        public SpectrumDataProcessor(ASDFileParser aSDFileParser, RandomAccessFile randomAccessFile, SpectrumFileHeader spectrumFileHeader) throws IOException {
            this.header = spectrumFileHeader;
            this.wavelength = SpectrumDataProcessor.createWavelength(spectrumFileHeader);
            this.spectrum = ASDFileParser.readSpectrumData(randomAccessFile, spectrumFileHeader.channels, spectrumFileHeader.dataFormat, 484L);
            int n = 484 + spectrumFileHeader.channels * 8;
            this.referenceFlag = ASDFileParser.readUShort(randomAccessFile, n);
            this.wrTime = ASDFileParser.readLong(randomAccessFile, n += 2);
            this.spectrumTime = ASDFileParser.readLong(randomAccessFile, n += 8);
            int n2 = ASDFileParser.readUShort(randomAccessFile, n += 8);
            this.specDescription = ASDFileParser.readString(randomAccessFile, n2, n += 2);
            this.whiteReference = ASDFileParser.readSpectrumData(randomAccessFile, spectrumFileHeader.channels, spectrumFileHeader.dataFormat, n += n2);
        }

        private static float[] createWavelength(SpectrumFileHeader spectrumFileHeader) {
            float[] fArray = new float[spectrumFileHeader.channels];
            for (int i = 0; i < spectrumFileHeader.channels; ++i) {
                fArray[i] = spectrumFileHeader.startWavelength + (float)i * spectrumFileHeader.wavelengthStep;
            }
            return fArray;
        }

        public float[] getProcessedSpectrum(String string) {
            if ("reflectance".equals(string)) {
                if ("radiance".equals(this.header.dataType) || "reflectance".equals(this.header.dataType)) {
                    return this.divideArrays(this.spectrum, this.whiteReference);
                }
                if ("raw".equals(this.header.dataType)) {
                    return this.divideArrays(this.normalizeSpectrum(this.spectrum), this.normalizeSpectrum(this.whiteReference));
                }
            } else if ("radiance".equals(string)) {
                if ("radiance".equals(this.header.dataType) || "reflectance".equals(this.header.dataType)) {
                    return this.spectrum;
                }
                if ("raw".equals(this.header.dataType)) {
                    return this.normalizeSpectrum(this.spectrum);
                }
            } else if ("raw".equals(string)) {
                if ("raw".equals(this.header.dataType)) {
                    return this.spectrum;
                }
            } else if ("white_reference".equals(string)) {
                if ("radiance".equals(this.header.dataType) || "reflectance".equals(this.header.dataType)) {
                    return this.whiteReference;
                }
                if ("raw".equals(this.header.dataType)) {
                    return this.normalizeSpectrum(this.whiteReference);
                }
            }
            throw new IllegalArgumentException("Invalid type of data requested.");
        }

        public float[] normalizeSpectrum(float[] fArray) {
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray2[i] = (float)i < this.header.splice1Wavelength ? fArray[i] / (float)this.header.it : ((float)i >= this.header.splice1Wavelength && (float)i <= this.header.splice2Wavelength ? fArray[i] * this.header.swir1Gain / 2048.0f : fArray[i] * this.header.swir2Gain / 2048.0f);
            }
            return fArray2;
        }

        private float[] divideArrays(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray3[i] = fArray2[i] != 0.0f ? fArray[i] / fArray2[i] : 0.0f;
            }
            return fArray3;
        }
    }

    public static class TmStructure {
        public int tm_sec;
        public int tm_min;
        public int tm_hour;
        public int tm_mday;
        public int tm_mon;
        public int tm_year;
        public int tm_wday;
        public int tm_yday;
        public int tm_isdst;
    }
}

