/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.unmixing.ConstrainedSpectralUnmixer;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.Sample;

public class Analyzer {
    private Sample sample;
    private final ConstrainedSpectralUnmixer unmixer;

    public Analyzer(int[] nArray, List<File> list, int n, int n2, float f) {
        List<Reference> list2 = Reference.read(list, null);
        this.unmixer = new ConstrainedSpectralUnmixer(list2, n, nArray, n2, f);
    }

    public void loadSample(Sample sample) {
        this.sample = sample;
    }

    public List<RtFrame> makeResponseImageFromSample() {
        this.sample = this.unmixer.loadSample(this.sample);
        ArrayList<RtFrame> arrayList = new ArrayList<RtFrame>();
        for (RtFrame rtFrame : this.sample.getFrames()) {
            FloatMatrix floatMatrix = this.unmixer.unmix(rtFrame.getMatrix(0));
            arrayList.add(new RtFrame(floatMatrix, 1));
        }
        return arrayList;
    }

    public ConstrainedSpectralUnmixer getUnmixer() {
        return this.unmixer;
    }

    public void showImage() {
        this.sample.showImage();
    }
}

