/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.util.List;
import org.jblas.FloatMatrix;
import org.jblas.JavaBlas;
import org.jblas.Solve;
import se.prediktera.breeze.common.realtime.unmixing.IResampler;
import se.prediktera.breeze.common.realtime.unmixing.NonNegativeLeastSquares;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.Sample;

public class ConstrainedSpectralUnmixer {
    private Sample sample;
    private final int[] range;
    private final List<Reference> referenceList;
    private float[] wavelength;
    private int nWl;
    private int nEndMembers;
    private final int p;
    private FloatMatrix LAMBDA;
    private FloatMatrix LAMBDAPLUS;
    private FloatMatrix P;
    private FloatMatrix E;
    private FloatMatrix ETilde;
    private final NonNegativeLeastSquares NNLS;
    private boolean firstSample;

    public ConstrainedSpectralUnmixer(List<Reference> list, int n, int[] nArray, int n2, float f) {
        this.referenceList = list;
        this.p = n;
        this.NNLS = new NonNegativeLeastSquares(n2, f);
        this.range = nArray;
        this.firstSample = true;
    }

    public Sample loadSample(Sample sample) {
        this.sample = sample.crop(this.range);
        if (this.firstSample) {
            this.makeCSUMMatrices(this.sample.wavelength);
            this.firstSample = false;
        }
        return this.sample;
    }

    public void makeCSUMMatrices(float[] fArray) {
        int n;
        this.wavelength = fArray;
        this.nWl = this.wavelength.length;
        this.loadReferences();
        int n2 = this.p + 1;
        this.LAMBDA = FloatMatrix.zeros((int)this.nWl, (int)n2);
        this.LAMBDA.putColumn(0, FloatMatrix.ones((int)this.nWl));
        float[] fArray2 = new float[this.nWl];
        float f = this.range[0];
        float f2 = this.range[1];
        float f3 = f2 - f;
        for (n = 0; n < this.nWl; ++n) {
            fArray2[n] = (f2 - this.wavelength[n]) / f3;
        }
        for (n = 1; n < n2; ++n) {
            this.LAMBDA.putColumn(n, this.floatArrayPower(fArray2, n));
        }
        this.LAMBDAPLUS = Solve.pinv((FloatMatrix)this.LAMBDA.transpose().mmul(this.LAMBDA)).mmul(this.LAMBDA.transpose());
        this.P = FloatMatrix.eye((int)this.nWl).sub(this.LAMBDA.mmul(this.LAMBDAPLUS));
        this.ETilde = this.P.mmul(this.E);
        this.NNLS.initialize(this.ETilde);
    }

    private void loadReferences() {
        this.nEndMembers = this.referenceList.size();
        this.E = FloatMatrix.zeros((int)this.nWl, (int)this.nEndMembers);
        IResampler.LinearResampler linearResampler = new IResampler.LinearResampler();
        for (int i = 0; i < this.nEndMembers; ++i) {
            Reference reference = this.referenceList.get(i);
            reference.interpolate(this.wavelength, linearResampler);
            this.E.putColumn(i, reference.getMatrix());
        }
    }

    private FloatMatrix floatArrayPower(float[] fArray, int n) {
        int n2 = fArray.length;
        FloatMatrix floatMatrix = FloatMatrix.zeros((int)n2);
        for (int i = 0; i < n2; ++i) {
            floatMatrix.put(i, (float)Math.pow(fArray[i], n));
        }
        return floatMatrix;
    }

    public FloatMatrix unmix(FloatMatrix floatMatrix) {
        int n = this.nEndMembers + this.p + 1 + 1;
        FloatMatrix floatMatrix2 = new FloatMatrix(n);
        return this.unmix(floatMatrix, floatMatrix2);
    }

    public FloatMatrix unmix(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        FloatMatrix floatMatrix3 = this.P.mmul(floatMatrix);
        NonNegativeLeastSquares.AnalysisOutput analysisOutput = this.NNLS.unmixFrame(this.ETilde, floatMatrix3);
        FloatMatrix floatMatrix4 = analysisOutput.getA();
        FloatMatrix floatMatrix5 = this.LAMBDAPLUS.mmul(floatMatrix.sub(this.E.mmul(floatMatrix4)));
        FloatMatrix floatMatrix6 = this.E.mmul(floatMatrix4);
        FloatMatrix floatMatrix7 = floatMatrix.sub(this.LAMBDA.mmul(floatMatrix5));
        FloatMatrix floatMatrix8 = floatMatrix7.sub(floatMatrix6);
        floatMatrix8.muli(floatMatrix8);
        FloatMatrix floatMatrix9 = floatMatrix8.columnSums();
        floatMatrix8 = floatMatrix7.subRowVector(floatMatrix7.columnMeans());
        floatMatrix8.muli(floatMatrix8);
        FloatMatrix floatMatrix10 = floatMatrix8.columnSums();
        FloatMatrix floatMatrix11 = floatMatrix9.div(floatMatrix10).mmul(-1.0f).add(1.0f);
        ConstrainedSpectralUnmixer.concatVertically(floatMatrix4, floatMatrix5, floatMatrix11, floatMatrix2);
        return floatMatrix2;
    }

    public static void concatVertically(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, FloatMatrix floatMatrix3, FloatMatrix floatMatrix4) {
        for (int i = 0; i < floatMatrix.columns; ++i) {
            JavaBlas.rcopy((int)floatMatrix.rows, (float[])floatMatrix.data, (int)floatMatrix.index(0, i), (int)1, (float[])floatMatrix4.data, (int)floatMatrix4.index(0, i), (int)1);
            JavaBlas.rcopy((int)floatMatrix2.rows, (float[])floatMatrix2.data, (int)floatMatrix2.index(0, i), (int)1, (float[])floatMatrix4.data, (int)floatMatrix4.index(floatMatrix.rows, i), (int)1);
            JavaBlas.rcopy((int)floatMatrix3.rows, (float[])floatMatrix3.data, (int)floatMatrix3.index(0, i), (int)1, (float[])floatMatrix4.data, (int)floatMatrix4.index(floatMatrix.rows + floatMatrix2.rows, i), (int)1);
        }
    }
}

