/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.segmentation.ConstrainedSpectralUnmixerSegmentation;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.entry.workflow.Workflow;

public class ConstrainedSpectralUnmixerSetting
extends MembersSetting {
    private final String version = "1";
    private final ConstrainedSpectralUnmixerSegmentation.UnxmixingExpressionParameter expressionParameter;
    private final ScatterCorrectionParameter scatterCorrectionParameter;
    private final MethodParameter methodParameter;
    private final TypeParameter typeParameter = new TypeParameter(this);

    public ConstrainedSpectralUnmixerSetting(AbstractBreezeFunction abstractBreezeFunction, boolean bl) {
        super(abstractBreezeFunction);
        abstractBreezeFunction.addParameter(this.typeParameter, 5);
        this.methodParameter = new MethodParameter(this);
        abstractBreezeFunction.addParameter(this.methodParameter, 5);
        this.scatterCorrectionParameter = new ScatterCorrectionParameter(this);
        abstractBreezeFunction.addParameter(this.scatterCorrectionParameter, 5);
        this.expressionParameter = new ConstrainedSpectralUnmixerSegmentation.UnxmixingExpressionParameter(true);
        abstractBreezeFunction.addParameter(this.expressionParameter, 5);
        this.typeParameter.setVisible(bl);
        this.spectralLibraryGroupParameter.setVisible(this.typeParameter::isClassification);
    }

    public ConstrainedSpectralUnmixerSegmentation.UnxmixingExpressionParameter getExpressionParameter() {
        return this.expressionParameter;
    }

    public int getScatterCorrection() {
        return this.scatterCorrectionParameter.getIndex();
    }

    public int getMethod() {
        return this.methodParameter.getIndex();
    }

    @Override
    protected int getParameterHashCode(FunctionTreeNode functionTreeNode) {
        int n = super.getParameterHashCode(functionTreeNode);
        return n += FunctionParameter.hashCode(this.scatterCorrectionParameter, this.methodParameter, this.typeParameter, this.expressionParameter);
    }

    @Override
    protected RtAnalyse createAnalyse(FunctionTreeNode functionTreeNode, String string) {
        RtAnalyse rtAnalyse = new RtAnalyse(string, "Unmixing", BasicAnalyse.ModelMethod.QuantificationUnmixing, this.function.getStudyId(), "1");
        List<Reference> list = this.getEndMembers(Workflow.getWorkflow(functionTreeNode), false);
        if (this.isQuantification()) {
            PropertyFactor catClass;
            for (Reference stringArray2 : list) {
                String i = stringArray2.getName();
                catClass = new PropertyFactor(i, i, "");
                catClass.setMax(1.0f);
                rtAnalyse.getPropertyFactors().add(catClass);
            }
            int n = this.getScatterCorrection();
            String[] stringArray = new String[]{"Baseline", "Slope", "Parabola"};
            for (int propertyFactor2 = 1; propertyFactor2 <= n; ++propertyFactor2) {
                catClass = new PropertyFactor(stringArray[propertyFactor2 - 1], stringArray[propertyFactor2 - 1], "");
                catClass.setMax(1.0f);
                rtAnalyse.getPropertyFactors().add(catClass);
            }
            PropertyFactor reference = new PropertyFactor("R2", "R2", "");
            reference.setMax(1.0f);
            rtAnalyse.getPropertyFactors().add(reference);
            catClass = new PropertyFactor("Expression", "Expression", "");
            catClass.setMax(1.0f);
            rtAnalyse.getPropertyFactors().add(catClass);
        } else {
            CategoryFactor categoryFactor = rtAnalyse.getCategoryFactors().add(CategoryFactor.withNoClass("Classification", "ucid"));
            for (Reference reference : list) {
                CatClass catClass = categoryFactor.addClass(reference.getName());
                if (reference.isCustomColor()) {
                    catClass.setColor(reference.getColor());
                    continue;
                }
                reference.setColor(catClass.getColor(), false);
            }
        }
        return rtAnalyse;
    }

    @Override
    protected String getName() {
        return "Unmixing";
    }

    @Override
    protected void addParameters(RtModelParameters.RtModuleSetup rtModuleSetup) {
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("correction", this.getScatterCorrection()));
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("type", this.isQuantification() ? 0.0 : 1.0));
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("method", this.getMethod()));
        rtModuleSetup.add(new RtModelParameters.RtParameterString("expression", this.getExpressionParameter().getExpression()));
    }

    public boolean isQuantification() {
        return this.typeParameter.isQuantification();
    }

    public class TypeParameter
    extends OptionParameter {
        public TypeParameter(ConstrainedSpectralUnmixerSetting constrainedSpectralUnmixerSetting) {
            super("type", "Type", "0", "");
            this.add(new OptionParameter.Option("0", "Quantification"));
            this.add(new OptionParameter.Option("1", "Classification"));
        }

        public boolean isQuantification() {
            return this.getIndex() == 0;
        }

        public boolean isClassification() {
            return this.getIndex() == 1;
        }
    }

    private class MethodParameter
    extends OptionParameter {
        public MethodParameter(ConstrainedSpectralUnmixerSetting constrainedSpectralUnmixerSetting) {
            super("method", "Method", "0", "");
            this.add(new OptionParameter.Option("0", "None Negative Least Squares"));
            this.add(new OptionParameter.Option("1", "Sum To One Least Squares"));
        }
    }

    private class ScatterCorrectionParameter
    extends OptionParameter {
        public ScatterCorrectionParameter(ConstrainedSpectralUnmixerSetting constrainedSpectralUnmixerSetting) {
            super("correction", "Scatter correction", "1", "");
            this.add(new OptionParameter.Option("0", "None"));
            this.add(new OptionParameter.Option("1", "Baseline"));
            this.add(new OptionParameter.Option("2", "Slope"));
            this.add(new OptionParameter.Option("3", "Parabola"));
        }
    }

    public static interface ContrainedUnmixingInterface {
        public ConstrainedSpectralUnmixerSetting getSetting();
    }
}

