/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;

public class EditGroupingCustomPanel
extends AbstractBreezeCustomPanel {
    private final BreezeTablePanel table;
    private final BreezeInputField nameTextField = new BreezeInputField("Grouping name", "", "", BreezeInputFieldHelper.Format.OneRow);
    private final BreezeFrame frame;
    private final BreezeButton removeGroupingButton;
    private GroupingUtils.Grouping grouping;

    public EditGroupingCustomPanel(BreezeFrame breezeFrame, GroupingUtils.Grouping grouping) {
        this.frame = breezeFrame;
        this.grouping = grouping;
        boolean bl = !grouping.isReadOnly();
        this.table = new BreezeTablePanel();
        this.setBackground(BreezeTheme.getInstance().getDialogBackground());
        this.setLayout(new GridBagLayout());
        this.nameTextField.setValue(grouping.getGroupingName());
        this.nameTextField.addChangeListener(textActionEvent -> grouping.setGroupingName(this.nameTextField.getValue()));
        this.nameTextField.setEnabled(bl);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 20, 0, 50);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameTextField, gridBagConstraints);
        BreezeButton breezeButton = EntryMainHelper.createButton("Add new grouping", "add", this::addNewGroup);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(10, 5, 0, 20);
        this.add((Component)breezeButton, gridBagConstraints2);
        this.removeGroupingButton = EntryMainHelper.createButton("Remove grouping", "delete", this::removeGrouping);
        this.removeGroupingButton.setEnabled(!grouping.isReadOnly());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new Insets(10, 5, 0, 20);
        gridBagConstraints3.anchor = 13;
        this.add((Component)this.removeGroupingButton, gridBagConstraints3);
        this.table.getTable().setDefaultEditor(GroupCatClass.class, new SelectMembersPanel.CatClassCellEditor(this.table::updateTable));
        this.table.getTable().setDefaultRenderer(GroupCatClass.class, new SelectMembersPanel.MicaCatClassCellRenderer());
        this.table.getTable().setDefaultEditor(String.class, new BreezeTable.BreezeTextCellEditor((n, string) -> {
            if (!grouping.isReadOnly()) {
                GroupCatClass groupCatClass = (GroupCatClass)this.table.getTable().getValueAt(n, 0);
                groupCatClass.setName(string);
                this.table.updateTable();
            }
        }));
        this.table.addRowHeader(50);
        this.table.initTable(new DefaultBreezeTableImpl(this){

            @Override
            public Vector createVOVector(Object object) {
                Vector<Object> vector = new Vector<Object>();
                GroupingUtils.Group group = (GroupingUtils.Group)object;
                vector.add(new GroupCatClass(null, group));
                vector.add(group.getGroupName());
                return vector;
            }

            @Override
            public List<Object> getTableHeader(List list) {
                return Arrays.asList("Color", "Name");
            }

            @Override
            public int[] getColumnWidth() {
                return new int[]{30, 70};
            }
        }, null, false);
        this.table.setRowHeight(30);
        this.table.getTable().getSelectionModel().setSelectionMode(2);
        List<GroupingUtils.Group> list = grouping.getGroups();
        this.table.setTableList(list, Optional.ofNullable(list).map(List::getFirst).orElse(null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 20, 0, 20);
        this.add((Component)((Object)this.table), gridBagConstraints);
        this.table.getScrollPane().setHorizontalScrollBarPolicy(31);
        BreezeFrame.setRelativeSize(this, 0.6);
    }

    private void addNewGroup() {
        BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "New grouping", "Enter new grouping name:", "", breezeActionEvent -> {
            GroupingUtils.Grouping grouping = new GroupingUtils.Grouping();
            Pair<File, String> pair = GroupingUtils.getGroupingFile();
            grouping.setSourceFile((File)pair.getLeft());
            grouping.setId((String)pair.getRight());
            grouping.setGroupingName(breezeActionEvent.getInputText());
            this.grouping = grouping;
            this.nameTextField.setText(grouping.getGroupingName());
            this.nameTextField.setEnabled(true);
            this.removeGroupingButton.setEnabled(true);
            this.table.setTableList(Collections.emptyList(), null);
            this.table.setEditable(true);
            this.table.updateTable();
        });
    }

    private void removeGrouping() {
        BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Delete", "Permanently delete grouping \"" + this.grouping.getGroupingName() + "\"?", null, breezeActionEvent -> {
            this.grouping.setMarkedForDeletion(true);
            this.nameTextField.setText("[DELETED]");
            this.nameTextField.setEnabled(false);
            this.removeGroupingButton.setEnabled(!this.grouping.isReadOnly());
            this.table.setEditable(false);
        });
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return this.grouping;
    }
}

