/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import se.prediktera.breeze.common.realtime.unmixing.IResampler;
import se.prediktera.breeze.common.util.type.RtThreader;

public class GaussianResampler
implements IResampler {
    private static final double PI = Math.PI;
    private static final double FWHMTOSIGMA = 0.42466090014401;
    private static final double SQRT_PI = Math.sqrt(Math.PI);

    @Override
    public float[] resample(float[] fArray, float[] fArray2, float[] fArray3) {
        float[][] fArray4;
        float[] fArray5 = new float[fArray3.length];
        float[] fArray6 = GaussianResampler.calculateFWHMFromPositionUnit(fArray3, 1.0f);
        if (!GaussianResampler.gaussianDistribution(fArray2, fArray3, fArray6, fArray4 = GaussianResampler.create2dMatrix(fArray3.length, fArray2.length, 0.0f))) {
            throw new RuntimeException("Cannot calculate Gaussian weights");
        }
        if (!GaussianResampler.gaussianResample(fArray, fArray4, fArray5)) {
            throw new RuntimeException("Cannot do Gaussian resampling");
        }
        return fArray5;
    }

    private static float[][] create2dMatrix(int n, int n2, float f) {
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = f;
            }
        }
        return fArray;
    }

    private static boolean gaussianDistribution(float[] fArray, float f, float f2, float[] fArray2) {
        float f3 = (float)((double)f2 * 0.42466090014401 + 1.0E-10);
        float f4 = 1.0f / (2.0f * f3 * f3);
        double d = 1.0 / ((double)f3 * SQRT_PI);
        float f5 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f6 = fArray[i] - f;
            fArray2[i] = (float)(Math.exp(-f6 * f6 * f4) * d);
            f5 += fArray2[i];
        }
        if (f5 == 0.0f) {
            return false;
        }
        float f7 = 1.0f / f5;
        int n = 0;
        while (n < fArray2.length) {
            int n2 = n++;
            fArray2[n2] = fArray2[n2] * f7;
        }
        return true;
    }

    private static boolean gaussianDistribution(final float[] fArray, final float[] fArray2, final float[] fArray3, final float[][] fArray4) {
        if (fArray2.length != fArray3.length) {
            return false;
        }
        new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n, int n2) {
                for (int i = n; i < n2; ++i) {
                    float f = fArray2[i];
                    float f2 = fArray3[i];
                    if (GaussianResampler.gaussianDistribution(fArray, f, f2, fArray4[i])) continue;
                    throw new RuntimeException("Cannot calculate Gaussian weights for all positions");
                }
            }
        }.execute(fArray2.length);
        return true;
    }

    private static boolean gaussianResample(float[] fArray, float[][] fArray2, float[] fArray3) {
        if (fArray2.length == 0 || fArray.length == 0) {
            return false;
        }
        if (fArray2[0].length != fArray.length) {
            return false;
        }
        for (int i = 0; i < fArray3.length; ++i) {
            float f = 0.0f;
            for (int j = 0; j < fArray.length; ++j) {
                f += fArray[j] * fArray2[i][j];
            }
            fArray3[i] = f;
        }
        return true;
    }

    private static float[] calculateFWHMFromPositionUnit(float[] fArray, float f) {
        float[] fArray2 = GaussianResampler.calculatePixelSize(fArray);
        float[] fArray3 = new float[fArray2.length];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray3[i] = fArray2[i] * f;
        }
        return fArray3;
    }

    private static float[] calculatePixelSize(float[] fArray) {
        if (fArray.length < 2) {
            return new float[0];
        }
        float[] fArray2 = new float[fArray.length];
        fArray2[0] = Math.abs(fArray[1] - fArray[0]);
        for (int i = 1; i < fArray.length - 1; ++i) {
            fArray2[i] = Math.abs((fArray[i + 1] - fArray[i - 1]) / 2.0f);
        }
        fArray2[fArray.length - 1] = Math.abs(fArray[fArray.length - 1] - fArray[fArray.length - 2]);
        return fArray2;
    }
}

