/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.map.common.error.Logg;

public class GroupingUtils {
    public static final String GROUPINGS_DIRECTORY_NAME = "Spectral groupings";
    public static final Grouping NONE_GROUPING = new Grouping("None", "NONE", null, true, true, false, false, new File("0"), null, null);
    private static File testGroupingsDirectory = null;

    public static List<Grouping> listGroupings() {
        return GroupingUtils.listGroupings(Collections.emptyList());
    }

    public static List<Grouping> listGroupings(List<File> list) {
        File file = GroupingUtils.getOrCreateGroupingDirectory();
        ArrayList<Grouping> arrayList = new ArrayList<Grouping>();
        File[] fileArray = file.listFiles();
        if (ObjectUtils.isEmpty((Object)fileArray)) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            try {
                Grouping grouping = GroupingUtils.deserializeGroupingFile(file2);
                if (!ObjectUtils.isEmpty(list)) {
                    if (!list.stream().anyMatch(grouping::containsEndMemberFile)) continue;
                }
                arrayList.add(grouping);
            }
            catch (IOException | JSONException throwable) {
                Logg.warn((String)("Cannot deserialize grouping file at: " + file2.getAbsolutePath()), (Object[])new Object[]{throwable});
            }
        }
        return arrayList.stream().sorted(Comparator.comparing(Grouping::getGroupingName)).collect(Collectors.toList());
    }

    public static File getGroupingsDirectory() {
        if (testGroupingsDirectory != null) {
            return testGroupingsDirectory;
        }
        return new File(WorkspaceManager.getInstance().getWorkspace().getCustomizePath(), GROUPINGS_DIRECTORY_NAME);
    }

    public static Pair<File, String> getGroupingFile() {
        File file = GroupingUtils.getOrCreateGroupingDirectory();
        String string = UUID.randomUUID().toString().substring(0, 8);
        return Pair.of((Object)new File(file, "grouping-" + string + ".json"), (Object)string);
    }

    public static File getGroupingFileFromId(String string) {
        File file = GroupingUtils.getOrCreateGroupingDirectory();
        return new File(file, "grouping-" + string + ".json");
    }

    private static File getOrCreateGroupingDirectory() {
        File file = GroupingUtils.getGroupingsDirectory();
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException("Unable to create grouping directory: " + String.valueOf(file));
            }
            Logg.debug((String)("Grouping directory created: " + String.valueOf(file)), (Object[])new Object[0]);
        }
        if (FileHelper.isDirectoryEmpty(file)) {
            File file2 = Paths.get(SettingsManager.getBreezeInstallFolder(), "Data", "mica", GROUPINGS_DIRECTORY_NAME).toFile();
            if (!file2.exists()) {
                Logg.error((String)("Cannot find built-in grouping directory: " + file2.getAbsolutePath()), (Object[])new Object[0]);
            } else {
                Logg.debug((String)("Grouping directory filled with builtin from: " + file2.getAbsolutePath()), (Object[])new Object[0]);
                FileUtils.copyDirectoryToDirectory((File)file2, (File)file.getParentFile());
            }
        }
        return file;
    }

    public static void serializeGroupingFile(Grouping grouping) throws IOException {
        GroupingUtils.serializeGroupingFile(grouping.getSourceFile(), grouping);
    }

    public static void serializeGroupingFile(File file, Grouping grouping) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(GroupingUtils.serializeGroupingToJsonObject(grouping).toString(4));
        }
    }

    public static String serializeToCompactXmlValidString(Grouping grouping) {
        JSONObject jSONObject = GroupingUtils.serializeGroupingToJsonObject(grouping);
        return StringEscapeUtils.escapeXml10((String)jSONObject.toString());
    }

    public static JSONObject serializeGroupingToJsonObject(Grouping grouping) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("groupingName", (Object)grouping.getGroupingName());
        if (StringUtils.isBlank((CharSequence)grouping.getId())) {
            jSONObject.put("id", (Object)UUID.randomUUID().toString().substring(0, 8));
        } else {
            jSONObject.put("id", (Object)grouping.getId());
        }
        jSONObject.put("readOnly", grouping.isReadOnly());
        if (grouping.hasLegacyHashCode()) {
            jSONObject.put("legacyHashCode", (Object)grouping.getLegacyHashCode());
        }
        JSONArray jSONArray = new JSONArray();
        if (ObjectUtils.isNotEmpty(grouping.getGroups())) {
            for (Group group : grouping.getGroups()) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("groupName", (Object)group.getGroupName());
                jSONObject2.put("colorHex", (Object)group.getColorHex());
                jSONObject2.put("elements", (Object)new JSONArray(group.getElements()));
                jSONArray.put((Object)jSONObject2);
            }
        }
        jSONObject.put("groups", (Object)jSONArray);
        jSONObject.put("endMemberSourceFiles", grouping.getEndMemberFiles());
        return jSONObject;
    }

    public static Grouping deserializeGroupingString(String string, File file) {
        JSONObject jSONObject = new JSONObject(string);
        String string2 = jSONObject.getString("groupingName");
        String string3 = jSONObject.getString("id");
        JSONArray jSONArray = jSONObject.getJSONArray("endMemberSourceFiles");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (ObjectUtils.isNotEmpty((Object)jSONArray)) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(new File(jSONArray.getString(i)));
            }
        }
        JSONArray jSONArray2 = jSONObject.getJSONArray("groups");
        boolean bl = jSONObject.has("readOnly") && jSONObject.getBoolean("readOnly");
        String string4 = jSONObject.has("legacyHashCode") ? jSONObject.getString("legacyHashCode") : null;
        Grouping grouping = new Grouping(string2, string3, string4, bl, false, false, false, file == null ? GroupingUtils.getGroupingFileFromId(string3) : file, null, arrayList);
        ArrayList<Group> arrayList2 = new ArrayList<Group>();
        for (int i = 0; i < jSONArray2.length(); ++i) {
            JSONObject jSONObject2 = jSONArray2.getJSONObject(i);
            String string5 = jSONObject2.getString("groupName");
            String string6 = jSONObject2.getString("colorHex");
            JSONArray jSONArray3 = jSONObject2.getJSONArray("elements");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int j = 0; j < jSONArray3.length(); ++j) {
                arrayList3.add(jSONArray3.getString(j));
            }
            arrayList2.add(new Group(string5, string6, arrayList3, grouping));
        }
        grouping.setGroups(arrayList2);
        return grouping;
    }

    public static Grouping deserializeGroupingFile(File file) throws IOException {
        return GroupingUtils.deserializeGroupingString(Files.readString(file.toPath()), file);
    }

    @Generated
    public static void setTestGroupingsDirectory(File file) {
        testGroupingsDirectory = file;
    }

    public static class Grouping {
        private String groupingName;
        private String id;
        private String legacyHashCode;
        private boolean readOnly;
        private boolean isNone;
        private boolean isUpdated;
        private boolean isMarkedForDeletion;
        private File sourceFile;
        private List<Group> groups;
        private List<File> endMemberFiles;

        public Optional<Group> getGroupFromEndMember(String string) {
            if (ObjectUtils.isNotEmpty(this.groups)) {
                return this.groups.stream().filter(group -> Optional.ofNullable(group.elements).orElse(Collections.emptyList()).contains(string)).findFirst();
            }
            return Optional.empty();
        }

        public List<String> getGroupNames() {
            if (ObjectUtils.isNotEmpty(this.groups)) {
                return this.groups.stream().map(Group::getGroupName).toList();
            }
            return Collections.emptyList();
        }

        public Optional<Group> getGroupFromGroupName(String string) {
            if (ObjectUtils.isNotEmpty(this.groups)) {
                return this.groups.stream().filter(group -> group.getGroupName().equals(string)).findFirst();
            }
            return Optional.empty();
        }

        public boolean hasLegacyHashCode() {
            return StringUtils.isNotBlank((CharSequence)this.legacyHashCode);
        }

        public void addEndMemberFiles(List<File> list) {
            if (ObjectUtils.isEmpty(list)) {
                return;
            }
            if (this.endMemberFiles == null) {
                this.endMemberFiles = new ArrayList<File>(list);
            } else {
                LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(this.endMemberFiles);
                linkedHashSet.addAll(list);
                this.endMemberFiles = new ArrayList<File>(linkedHashSet);
            }
        }

        public void addEndMemberFile(File file) {
            if (this.endMemberFiles == null) {
                this.endMemberFiles = new ArrayList<File>();
            }
            if (file == null) {
                return;
            }
            if (!this.endMemberFiles.contains(file)) {
                this.endMemberFiles.add(file);
            }
        }

        public void addGroup(Group group) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>();
            }
            group.setGrouping(this);
            this.groups.add(group);
        }

        public boolean containsEndMemberFile(File file) {
            if (ObjectUtils.isEmpty(this.endMemberFiles)) {
                return true;
            }
            return this.endMemberFiles.contains(file) || this.endMemberFiles.stream().anyMatch(file2 -> file2.getName().equals(file.getName()));
        }

        public void saveToFile() throws IOException {
            this.saveToFile(false);
        }

        public void saveToFile(boolean bl) throws IOException {
            if (!bl) {
                this.legacyHashCode = null;
            }
            GroupingUtils.serializeGroupingFile(this);
        }

        public Grouping copyWithNewIdAndSourceFile() {
            Pair<File, String> pair = GroupingUtils.getGroupingFile();
            Grouping grouping = new Grouping(this.groupingName, (String)pair.getRight(), null, false, false, true, false, (File)pair.getLeft(), null, (List<File>)(this.endMemberFiles != null ? new ArrayList<File>(this.endMemberFiles) : null));
            if (ObjectUtils.isNotEmpty(this.getGroups())) {
                grouping.setGroups(this.getGroups().stream().map(group -> group.copy(grouping)).collect(Collectors.toCollection(ArrayList::new)));
            }
            return grouping;
        }

        public int hashCode() {
            return Objects.hash(this.groupingName, this.id, this.isNone, this.groups, this.endMemberFiles);
        }

        @Generated
        public void setGroupingName(String string) {
            this.groupingName = string;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        @Generated
        public void setLegacyHashCode(String string) {
            this.legacyHashCode = string;
        }

        @Generated
        public void setReadOnly(boolean bl) {
            this.readOnly = bl;
        }

        @Generated
        public void setNone(boolean bl) {
            this.isNone = bl;
        }

        @Generated
        public void setUpdated(boolean bl) {
            this.isUpdated = bl;
        }

        @Generated
        public void setMarkedForDeletion(boolean bl) {
            this.isMarkedForDeletion = bl;
        }

        @Generated
        public void setSourceFile(File file) {
            this.sourceFile = file;
        }

        @Generated
        public void setGroups(List<Group> list) {
            this.groups = list;
        }

        @Generated
        public void setEndMemberFiles(List<File> list) {
            this.endMemberFiles = list;
        }

        @Generated
        public String getGroupingName() {
            return this.groupingName;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getLegacyHashCode() {
            return this.legacyHashCode;
        }

        @Generated
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Generated
        public boolean isNone() {
            return this.isNone;
        }

        @Generated
        public boolean isUpdated() {
            return this.isUpdated;
        }

        @Generated
        public boolean isMarkedForDeletion() {
            return this.isMarkedForDeletion;
        }

        @Generated
        public File getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public List<Group> getGroups() {
            return this.groups;
        }

        @Generated
        public List<File> getEndMemberFiles() {
            return this.endMemberFiles;
        }

        @Generated
        public Grouping(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, File file, List<Group> list, List<File> list2) {
            this.groupingName = string;
            this.id = string2;
            this.legacyHashCode = string3;
            this.readOnly = bl;
            this.isNone = bl2;
            this.isUpdated = bl3;
            this.isMarkedForDeletion = bl4;
            this.sourceFile = file;
            this.groups = list;
            this.endMemberFiles = list2;
        }

        @Generated
        public Grouping() {
        }
    }

    public static class Group {
        private String groupName;
        private String colorHex;
        private List<String> elements;
        private Grouping grouping;

        public CatClass getCatClass(CategoryFactor categoryFactor) {
            CatClass catClass = new CatClass(this.groupName, categoryFactor);
            catClass.setColor(this.colorHex);
            return catClass;
        }

        public void addElement(String string) {
            if (this.elements == null) {
                this.elements = new ArrayList<String>();
            }
            if (!this.elements.contains(string)) {
                this.elements.add(string);
            }
        }

        public void removeElement(String string) {
            if (ObjectUtils.isEmpty(this.elements)) {
                return;
            }
            this.elements.remove(string);
        }

        public Group copy(Grouping grouping) {
            return new Group(this.groupName, this.colorHex, (List<String>)(ObjectUtils.isEmpty(this.elements) ? null : new ArrayList<String>(this.elements)), grouping);
        }

        public int hashCode() {
            return Objects.hash(this.groupName, this.colorHex, this.elements);
        }

        @Generated
        public void setGroupName(String string) {
            this.groupName = string;
        }

        @Generated
        public void setColorHex(String string) {
            this.colorHex = string;
        }

        @Generated
        public void setElements(List<String> list) {
            this.elements = list;
        }

        @Generated
        public void setGrouping(Grouping grouping) {
            this.grouping = grouping;
        }

        @Generated
        public String getGroupName() {
            return this.groupName;
        }

        @Generated
        public String getColorHex() {
            return this.colorHex;
        }

        @Generated
        public List<String> getElements() {
            return this.elements;
        }

        @Generated
        public Grouping getGrouping() {
            return this.grouping;
        }

        @Generated
        public Group(String string, String string2, List<String> list, Grouping grouping) {
            this.groupName = string;
            this.colorHex = string2;
            this.elements = list;
            this.grouping = grouping;
        }
    }
}

