/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import se.prediktera.breeze.common.realtime.unmixing.GaussianResampler;

public interface IResampler {
    public float[] resample(float[] var1, float[] var2, float[] var3);

    default public float[] tryResample(float[] fArray, float[] fArray2, float[] fArray3) {
        try {
            return this.resample(fArray, fArray2, fArray3);
        }
        catch (Exception exception) {
            if (this instanceof GaussianResampler) {
                return new LinearResampler().resample(fArray, fArray2, fArray3);
            }
            throw exception;
        }
    }

    public static class LinearResampler
    implements IResampler {
        @Override
        public float[] resample(float[] fArray, float[] fArray2, float[] fArray3) {
            float[] fArray4 = new float[fArray3.length];
            block0: for (int i = 0; i < fArray3.length; ++i) {
                float f = fArray3[i];
                if (f < fArray2[0]) {
                    fArray4[i] = this.interpolate(fArray2[0], fArray2[1], fArray[0], fArray[1], fArray3[i]);
                    continue;
                }
                if (f > fArray2[fArray2.length - 1]) {
                    fArray4[i] = this.interpolate(fArray2[fArray2.length - 2], fArray2[fArray2.length - 1], fArray[fArray2.length - 2], fArray[fArray2.length - 1], fArray3[i]);
                    continue;
                }
                for (int j = 1; j < fArray2.length; ++j) {
                    if (!(f <= fArray2[j])) continue;
                    fArray4[i] = this.interpolate(fArray2[j - 1], fArray2[j], fArray[j - 1], fArray[j], fArray3[i]);
                    continue block0;
                }
            }
            return fArray4;
        }

        public float interpolate(float f, float f2, float f3, float f4, float f5) {
            float f6 = (f4 - f3) / (f2 - f);
            float f7 = f3;
            return f6 * (f5 - f) + f7;
        }
    }
}

