/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyseList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.PropertyFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.segmentation.model.AbstractModelSegmentation;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SpectralLibraryGroupParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public abstract class MembersSetting {
    protected final AbstractBreezeFunction function;
    private final TextParameter rangeParameter;
    private final EndMemberFileParameter[] endMembersParameter = new EndMemberFileParameter[10];
    private final WorkflowAnalyseParameter analyseParameter;
    protected final SpectralLibraryGroupParameter spectralLibraryGroupParameter;

    public MembersSetting(AbstractBreezeFunction abstractBreezeFunction) {
        this.function = abstractBreezeFunction;
        this.rangeParameter = new TextParameter("range", "Range", "", "Eg: 460:980 or empty = all");
        abstractBreezeFunction.addParameter(this.rangeParameter, 3);
        for (int i = 0; i < this.endMembersParameter.length; ++i) {
            this.endMembersParameter[i] = new EndMemberFileParameter(i + 1);
            abstractBreezeFunction.addParameter(this.endMembersParameter[i], 2);
        }
        this.spectralLibraryGroupParameter = new SpectralLibraryGroupParameter(this.endMembersParameter);
        abstractBreezeFunction.addParameter(this.spectralLibraryGroupParameter, 3);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        abstractBreezeFunction.addParameter(this.analyseParameter, 2);
        this.analyseParameter.setVisible(false);
    }

    public boolean isEnabled() {
        if (this.function != null) {
            if (this.function.getNode() != null) {
                return this.function.getNode().isEnabled();
            }
            return true;
        }
        return false;
    }

    public List<float[]> getRange(boolean bl) {
        return MembersSetting.getRange(this.function, this.rangeParameter, bl);
    }

    public static List<float[]> getRange(AbstractBreezeFunction abstractBreezeFunction, TextParameter textParameter, boolean bl) {
        return MembersSetting.getRange(abstractBreezeFunction, textParameter, bl, -1.0f, -1.0f);
    }

    public static List<float[]> getRange(AbstractBreezeFunction abstractBreezeFunction, TextParameter textParameter, boolean bl, float f, float f2) {
        String string = textParameter.getText().trim();
        if (string.isEmpty()) {
            return List.of(new float[]{f, f2});
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        for (String string2 : string.split(";")) {
            String string3 = string2.trim();
            String[] stringArray = string3.split(":");
            if (stringArray.length != 2) {
                if (bl) {
                    throw new AbstractBreezeFunction.MethodException(abstractBreezeFunction, "Range is invalid: " + string);
                }
                Logg.warn((String)("Invalid range: " + string), (Object[])new Object[0]);
                continue;
            }
            float f3 = RtDataFormat.toNumberFloat(stringArray[0]);
            float f4 = RtDataFormat.toNumberFloat(stringArray[1]);
            if (bl && f3 > f4) {
                throw new AbstractBreezeFunction.MethodException(abstractBreezeFunction, "Range is invalid: " + string);
            }
            arrayList.add(new float[]{f3, f4});
        }
        return arrayList;
    }

    private List<EndMemberFileParameter> getEndMemberParameters(Workflow workflow, boolean bl) {
        ArrayList<EndMemberFileParameter> arrayList = new ArrayList<EndMemberFileParameter>();
        for (EndMemberFileParameter endMemberFileParameter : this.endMembersParameter) {
            File file;
            if (endMemberFileParameter == null || (file = endMemberFileParameter.getFile(workflow)) == null) continue;
            if (!file.exists() && bl) {
                throw new AbstractBreezeFunction.MethodException(this.function, "Cannot locate " + endMemberFileParameter.getAliasOrName() + " file: " + file.getAbsolutePath());
            }
            arrayList.add(endMemberFileParameter);
        }
        return arrayList;
    }

    public List<Reference> getEndMembers(Workflow workflow, boolean bl) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        for (EndMemberFileParameter endMemberFileParameter : this.getEndMemberParameters(workflow, bl)) {
            if (!endMemberFileParameter.exists(workflow)) continue;
            for (Reference reference : endMemberFileParameter.read(workflow)) {
                if (bl && this.nameExists(arrayList, reference)) {
                    throw new AbstractBreezeFunction.MethodException(this.function, "More than one included end member with same name:\n\n" + reference.getName());
                }
                arrayList.add(reference);
            }
        }
        return arrayList;
    }

    private boolean nameExists(ArrayList<Reference> arrayList, Reference reference) {
        if (reference.isIncluded()) {
            for (Reference reference2 : arrayList) {
                if (!reference2.isIncluded() || !reference2.getName().equalsIgnoreCase(reference.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected int getParameterHashCode(FunctionTreeNode functionTreeNode) {
        Workflow workflow = Workflow.getWorkflow(functionTreeNode);
        int n = 0;
        if (workflow != null) {
            n += StringHelper.hashCode(workflow.getStudyId());
        }
        n += FunctionParameter.hashCode(this.rangeParameter);
        for (EndMemberFileParameter endMemberFileParameter : this.getEndMemberParameters(workflow, false)) {
            n += endMemberFileParameter.getHashCode();
        }
        return n;
    }

    protected abstract RtAnalyse createAnalyse(FunctionTreeNode var1, String var2);

    protected abstract String getName();

    public RtAnalyse getOrCreateAnalyse(FunctionTreeNode functionTreeNode) {
        return MembersSetting.createAnalyse(functionTreeNode, String.valueOf(this.getParameterHashCode(functionTreeNode)), this.analyseParameter, string -> {
            RtAnalyse rtAnalyse = this.createAnalyse(functionTreeNode, string);
            rtAnalyse.setObjectMethod(this);
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(this.createRtModel(Workflow.getWorkflow(functionTreeNode), false));
            rtAnalyse.setModelParameters(rtModelParameters);
            return rtAnalyse;
        });
    }

    public static RtAnalyse createAnalyse(FunctionTreeNode functionTreeNode, String string, TextParameter textParameter, CreateAnalyseCallback createAnalyseCallback) {
        if (!BreezeMasterCache.isInstanceMasterCache()) {
            return null;
        }
        RtAnalyseList rtAnalyseList = BreezeMasterCache.getInstance().getRtAnalyseList();
        RtAnalyse rtAnalyse = (RtAnalyse)rtAnalyseList.byId(string);
        if (rtAnalyse == null) {
            RtAnalyse rtAnalyse2 = (RtAnalyse)rtAnalyseList.byId(textParameter.getValueStr());
            if (rtAnalyse2 != null) {
                try {
                    rtAnalyseList.remove(rtAnalyse2);
                }
                catch (Exception exception) {
                    Logg.error((String)"Cannot remove analyse", (Throwable)exception);
                }
            }
            rtAnalyse = createAnalyseCallback.create(string);
            rtAnalyseList.add(rtAnalyse);
            if (rtAnalyse2 != null && functionTreeNode != null && !string.equals(rtAnalyse2.getUid())) {
                MembersSetting.replaceAnalyse(functionTreeNode.getRoot(), functionTreeNode, rtAnalyse2, rtAnalyse);
            }
            createAnalyseCallback.deferredCreate(rtAnalyse);
        }
        rtAnalyse.setAlias(functionTreeNode != null ? functionTreeNode.getAlias() : null);
        textParameter.setValueStr(rtAnalyse.getUid());
        return rtAnalyse;
    }

    private static void replaceAnalyse(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2, BasicAnalyse basicAnalyse, BasicAnalyse basicAnalyse2) {
        if (functionTreeNode != functionTreeNode2) {
            AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
            if (basicAnalyse.getUid().equals(functionTreeNode.getAnalyseUid())) {
                if (abstractBreezeFunction instanceof AbstractModelSegmentation) {
                    AbstractModelSegmentation object = (AbstractModelSegmentation)abstractBreezeFunction;
                    object.setAnalyse(basicAnalyse2);
                } else if (abstractBreezeFunction instanceof AbstractModelDescriptor) {
                    AbstractModelDescriptor abstractModelDescriptor = (AbstractModelDescriptor)abstractBreezeFunction;
                    abstractModelDescriptor.setAnalyse(basicAnalyse2);
                }
            } else {
                boolean bl;
                boolean bl2 = false;
                for (FunctionParameter functionParameter : abstractBreezeFunction.getParameterList()) {
                    PropertyFactorParameter propertyFactorParameter;
                    if (!(functionParameter instanceof PropertyFactorParameter) || !(propertyFactorParameter = (PropertyFactorParameter)functionParameter).replaceAnalyse(basicAnalyse, basicAnalyse2)) continue;
                    bl = true;
                }
                if (bl) {
                    abstractBreezeFunction.getAnalyse();
                }
            }
        }
        for (FunctionTreeNode functionTreeNode3 : functionTreeNode.getChildList()) {
            MembersSetting.replaceAnalyse(functionTreeNode3, functionTreeNode2, basicAnalyse, basicAnalyse2);
        }
    }

    public static void delete(RtAnalyse rtAnalyse) {
        if (!BreezeMasterCache.isInstanceMasterCache()) {
            return;
        }
        BreezeMasterCache.getInstance().getRtAnalyseList().remove(rtAnalyse);
    }

    protected void addParameters(RtModelParameters.RtModuleSetup rtModuleSetup) {
    }

    public RtModelParameters.RtModel createRtModel(Workflow workflow, boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel(this.getName());
        RtModelParameters.RtModuleSetupList rtModuleSetupList = rtModel.getModules();
        boolean bl2 = bl && this.isEnabled();
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        List<float[]> list = this.getRange(bl2);
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("regions", list.size()));
        for (int i = 0; i < list.size(); ++i) {
            float[] fArray = list.get(i);
            Object object = i > 0 ? Integer.valueOf(i + 1) : "";
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("min" + String.valueOf(object), fArray[0]));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("max" + String.valueOf(object), fArray[1]));
        }
        this.addParameters(rtModuleSetup);
        List<Reference> list2 = this.getEndMembers(workflow, bl2);
        if (list2.isEmpty() && bl2) {
            throw new AbstractBreezeFunction.MethodException(this.function, "No end member files are chosen");
        }
        rtModuleSetupList.add(rtModuleSetup);
        int n = 0;
        for (Reference reference : list2) {
            if (!reference.isIncluded()) continue;
            RtModelParameters.RtModuleSetup rtModuleSetup2 = new RtModelParameters.RtModuleSetup("endMember" + ++n);
            rtModuleSetup2.add(new RtModelParameters.RtParameterString("name", reference.getName()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterString("color", RtPerfectSpread.getColorToString(reference.getColor())));
            rtModuleSetup2.add(new RtModelParameters.RtParameterVector("wavelength", reference.getWavelength()));
            rtModuleSetup2.add(new RtModelParameters.RtParameterVector("vector", reference.getMatrix().data));
            rtModuleSetupList.add(rtModuleSetup2);
        }
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("endMembers", n));
        return rtModel;
    }

    public static String getFirstName(List<Reference> list) {
        for (Reference reference : list) {
            if (!reference.isIncluded()) continue;
            return reference.getName();
        }
        return "none";
    }

    @Generated
    public TextParameter getRangeParameter() {
        return this.rangeParameter;
    }

    @Generated
    public SpectralLibraryGroupParameter getSpectralLibraryGroupParameter() {
        return this.spectralLibraryGroupParameter;
    }

    public static class EndMemberFileParameter
    extends FileParameter {
        private static File lastFolder = null;
        private String settings;
        private int index;

        public EndMemberFileParameter(String string, String string2, String string3) {
            super(string, string2, string3, "");
        }

        public EndMemberFileParameter(int n) {
            super("endMember" + n, "End Member " + n, "", "");
            this.index = n;
        }

        @Override
        public void copy(FunctionParameter functionParameter) {
            super.copy(functionParameter);
            this.settings = ((EndMemberFileParameter)functionParameter).settings;
        }

        public int getHashCode() {
            int n = StringHelper.hashCode(this.getValueStr());
            return n += StringHelper.hashCode(this.settings);
        }

        @Override
        public Element save(Element element) {
            Element element2 = super.save(element);
            if (this.settings != null) {
                XmlParserHelper.setAttribute((Node)element2, "settings", this.settings);
            }
            return element2;
        }

        @Override
        public void parse(Node node) {
            super.parse(node);
            this.settings = XmlParserHelper.getAttribute(node, "settings");
        }

        public List<Reference> read(Workflow workflow) {
            List<Reference> list = this.parseReferences(workflow);
            if (this.settings != null) {
                List<EndMemberRecord> list2 = EndMemberRecord.parse(this.settings);
                for (int i = 0; i < list2.size(); ++i) {
                    if (i >= list.size()) continue;
                    Reference reference = list.get(i);
                    EndMemberRecord endMemberRecord = list2.get(i);
                    reference.setColor(endMemberRecord.color(), true);
                    reference.setIncluded(endMemberRecord.included());
                }
            } else {
                for (Reference reference : list) {
                    if (list.size() != 1 || reference.isCustomColor()) continue;
                    reference.setColor(RtPerfectSpread.generateColor(this.index), false);
                }
            }
            return list;
        }

        protected List<Reference> parseReferences(Workflow workflow) {
            return Reference.read(this.getFile(workflow), workflow);
        }

        public void setSettings(List<Reference> list) {
            JSONArray jSONArray = new JSONArray();
            for (Reference reference : list) {
                jSONArray.put((Object)new EndMemberRecord(reference.getColor(), reference.isIncluded(), "").toJSON());
            }
            this.settings = jSONArray.toString().replaceAll("\"", "'");
        }

        @Override
        public void customizeDialog(jopensaveDialog jopensaveDialog2) {
            EndMemberFileParameter.addAllSupported(jopensaveDialog2);
            jopensaveDialog2.setDialogTitle("Select " + this.getAliasOrName());
            if (jopensaveDialog2.getSelectedFile() == null) {
                if (lastFolder == null) {
                    lastFolder = this.getDefaultFolder();
                }
                jopensaveDialog2.setCurrentDirectory(lastFolder);
            }
        }

        public static void addAllSupported(jopensaveDialog jopensaveDialog2) {
            jopensaveDialog2.addExtension(new String[]{"txt", "csv"}, "CSV and txt files");
            jopensaveDialog2.addExtension(new String[]{"mcf", ""}, "USGS PRISM MICA library file (*.mcf)");
            jopensaveDialog2.addExtension(new String[]{"sli", ""}, "Envi library files (*.sli)");
            jopensaveDialog2.addExtension(new String[]{"asd", ""}, "ASD file format (*.asd)");
            jopensaveDialog2.addAllSupported();
        }

        @Override
        public void setValueStr(String string) {
            super.setValueStr(string);
            File file = new File(string);
            if (file.exists()) {
                lastFolder = file.getParentFile();
            }
        }
    }

    public static interface CreateAnalyseCallback {
        public RtAnalyse create(String var1);

        default public void deferredCreate(RtAnalyse rtAnalyse) {
        }
    }

    private record EndMemberRecord(Color color, boolean included, String group) {
        public JSONObject toJSON() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("c", (Object)RtPerfectSpread.getColorToString(this.color));
            if (!this.included) {
                jSONObject.put("i", this.included);
            }
            if (!this.group.isEmpty()) {
                jSONObject.put("g", (Object)this.group);
            }
            return jSONObject;
        }

        public static List<EndMemberRecord> parse(String string) {
            ArrayList<EndMemberRecord> arrayList;
            block4: {
                arrayList = new ArrayList<EndMemberRecord>();
                if (string == null) break block4;
                if (string.startsWith("[")) {
                    JSONArray jSONArray = new JSONArray(string.replaceAll("'", "\""));
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        arrayList.add(EndMemberRecord.fromJSON(jSONArray.getJSONObject(i)));
                    }
                } else {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(";")) {
                        String[] stringArray2 = string2.split(",");
                        arrayList.add(new EndMemberRecord(RtPerfectSpread.getColorFromString(stringArray2[0]), stringArray2.length != 2, ""));
                    }
                }
            }
            return arrayList;
        }

        public static EndMemberRecord fromJSON(JSONObject jSONObject) {
            Color color = RtPerfectSpread.getColorFromString(jSONObject.optString("c", "red"));
            boolean bl = jSONObject.optBoolean("i", true);
            String string = jSONObject.optString("g", "");
            return new EndMemberRecord(color, bl, string);
        }
    }

    public static interface MembersSettingInterface {
        public MembersSetting getSetting();
    }
}

