/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.util.HashMap;
import org.jblas.FloatMatrix;
import org.jblas.Solve;

public class NonNegativeLeastSquares {
    private final int maxIterOuterLoop;
    private final float tolerance;
    private HashMap<FloatMatrix, FloatMatrix> _zCrossInv;
    private FloatMatrix _zTr;
    private FloatMatrix _zCross;

    public NonNegativeLeastSquares(int n, float f) {
        this.maxIterOuterLoop = n;
        this.tolerance = f;
    }

    public void initialize(FloatMatrix floatMatrix) {
        this._zTr = floatMatrix.transpose();
        this._zCross = this._zTr.mmul(floatMatrix);
        int n = this._zCross.rows;
        HashMap<FloatMatrix, FloatMatrix> hashMap = new HashMap<FloatMatrix, FloatMatrix>();
        char[] cArray = new char[]{};
        int n2 = 1;
        while (true) {
            Object object = Integer.toBinaryString(n2);
            while (((String)object).length() < n) {
                object = "0" + (String)object;
            }
            cArray = ((String)object).toCharArray();
            if (cArray.length > n) break;
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = Integer.parseUnsignedInt(Character.toString(cArray[i]));
            }
            FloatMatrix floatMatrix2 = new FloatMatrix(fArray);
            boolean[] blArray = new boolean[floatMatrix2.getLength()];
            int n3 = 0;
            for (int i = 0; i < floatMatrix2.getLength(); ++i) {
                if (floatMatrix2.get(i) == 0.0f) continue;
                blArray[i] = true;
                ++n3;
            }
            FloatMatrix floatMatrix3 = FloatMatrix.zeros((int)n3, (int)n3);
            int n4 = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                int n5 = 0;
                for (int j = 0; j < blArray.length; ++j) {
                    if (!blArray[j]) continue;
                    floatMatrix3.put(n4, n5++, this._zCross.get(i, j));
                }
                ++n4;
            }
            hashMap.put(floatMatrix2, Solve.pinv((FloatMatrix)floatMatrix3));
            ++n2;
        }
        this._zCrossInv = hashMap;
    }

    public FloatMatrix nnls(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) throws ArithmeticException {
        int n = floatMatrix.columns;
        FloatMatrix floatMatrix3 = FloatMatrix.zeros((int)n);
        FloatMatrix floatMatrix4 = FloatMatrix.ones((int)n);
        FloatMatrix floatMatrix5 = FloatMatrix.zeros((int)n, (int)1);
        FloatMatrix floatMatrix6 = FloatMatrix.zeros((int)n, (int)1);
        FloatMatrix floatMatrix7 = floatMatrix.transpose();
        FloatMatrix floatMatrix8 = floatMatrix7.mmul(floatMatrix);
        FloatMatrix floatMatrix9 = floatMatrix7.mmul(floatMatrix2);
        FloatMatrix floatMatrix10 = floatMatrix9.sub(floatMatrix8.mmul(floatMatrix5));
        int n2 = floatMatrix10.length - 1;
        int n3 = 0;
        while ((int)floatMatrix4.max() == 1 && floatMatrix10.get(this.whereNonZero(floatMatrix4)).max() > 0.0f) {
            if (++n3 > this.maxIterOuterLoop) {
                return null;
            }
            int[] nArray = floatMatrix10.sortingPermutation();
            int n4 = n2;
            int n5 = nArray[n4];
            while ((int)floatMatrix4.get(n5) == 0) {
                n5 = nArray[--n4];
            }
            floatMatrix3.put(n5, 1.0f);
            floatMatrix4.put(n5, 0.0f);
            floatMatrix6 = this.updateS(floatMatrix6, floatMatrix8, floatMatrix9, floatMatrix3, floatMatrix4);
            if (floatMatrix6.get(n5) <= 0.0f) {
                floatMatrix10.put(n5, 0.0f);
                break;
            }
            int n6 = (int)floatMatrix3.sum();
            int n7 = n6 - 1;
            int n8 = 0;
            while (floatMatrix6.get(this.whereNonZero(floatMatrix3)).min() <= 0.0f) {
                if (++n8 > n7) {
                    return null;
                }
                FloatMatrix floatMatrix11 = floatMatrix6.le(0.0f);
                FloatMatrix floatMatrix12 = floatMatrix3.and(floatMatrix11);
                int[] nArray2 = this.FloatMatrix2intArray(floatMatrix12);
                int[] nArray3 = this.whereNonZero(this.intArray2FloatMatrix(nArray2));
                FloatMatrix floatMatrix13 = floatMatrix5.get(nArray3).div(floatMatrix5.get(nArray3).sub(floatMatrix6.get(nArray3)));
                floatMatrix13.sorti();
                float f = floatMatrix13.get(0);
                if (f <= 0.0f || f >= 1.0f) {
                    return null;
                }
                floatMatrix5.addi(floatMatrix6.sub(floatMatrix5).mul(f));
                floatMatrix5.put(this.whereNonZero(floatMatrix5.lt(this.tolerance)), 0.0f);
                FloatMatrix floatMatrix14 = floatMatrix5.le(0.0f);
                int[] nArray4 = this.whereNonZero(floatMatrix14);
                floatMatrix3.put(nArray4, 0.0f);
                floatMatrix4.put(nArray4, 1.0f);
                floatMatrix6 = this.updateS(floatMatrix6, floatMatrix8, floatMatrix9, floatMatrix3, floatMatrix4);
            }
            floatMatrix5 = floatMatrix6.dup();
            floatMatrix10 = floatMatrix9.sub(floatMatrix8.mmul(floatMatrix5));
        }
        return floatMatrix5;
    }

    public AnalysisOutput unmixFrame(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        int n = floatMatrix2.columns;
        int n2 = floatMatrix.columns;
        FloatMatrix floatMatrix3 = FloatMatrix.zeros((int)n2, (int)n);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            FloatMatrix floatMatrix4 = this.nnls(floatMatrix, floatMatrix2.getColumn(i));
            if (floatMatrix4 != null) {
                floatMatrix3.putColumn(i, floatMatrix4);
                continue;
            }
            floatMatrix3.putColumn(i, FloatMatrix.zeros((int)floatMatrix.columns));
            ++n3;
        }
        AnalysisOutput analysisOutput = new AnalysisOutput(floatMatrix3, n3);
        return analysisOutput;
    }

    private int[] FloatMatrix2intArray(FloatMatrix floatMatrix) {
        int[] nArray = new int[floatMatrix.length];
        for (int i = 0; i < floatMatrix.length; ++i) {
            nArray[i] = (int)floatMatrix.get(i);
        }
        return nArray;
    }

    private FloatMatrix intArray2FloatMatrix(int[] nArray) {
        int n = nArray.length;
        FloatMatrix floatMatrix = new FloatMatrix(n);
        for (int i = 0; i < n; ++i) {
            floatMatrix.put(i, (float)nArray[i]);
        }
        return floatMatrix;
    }

    private FloatMatrix updateS(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, FloatMatrix floatMatrix3, FloatMatrix floatMatrix4, FloatMatrix floatMatrix5) {
        boolean[] blArray = new boolean[floatMatrix4.length];
        int n = 0;
        for (int i = 0; i < floatMatrix4.length; ++i) {
            if (floatMatrix4.get(i) == 0.0f) continue;
            blArray[i] = true;
            ++n;
        }
        FloatMatrix floatMatrix6 = FloatMatrix.zeros((int)n, (int)1);
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            floatMatrix6.put(n2, floatMatrix3.get(i));
            ++n2;
        }
        FloatMatrix floatMatrix7 = this._zCrossInv.get(floatMatrix4).mmul(floatMatrix6);
        int n3 = 0;
        for (n2 = 0; n2 < floatMatrix4.length; ++n2) {
            if (floatMatrix5.get(n2) == 1.0f) {
                floatMatrix.put(n2, 0.0f);
                continue;
            }
            if (floatMatrix4.get(n2) != 1.0f) continue;
            floatMatrix.put(n2, floatMatrix7.get(n3++));
        }
        return floatMatrix;
    }

    private int[] whereNonZero(FloatMatrix floatMatrix) {
        int n = floatMatrix.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (floatMatrix.get(i) == 0.0f) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (floatMatrix.get(i) == 0.0f) continue;
            nArray[n3++] = i;
        }
        return nArray;
    }

    static class AnalysisOutput {
        private final int count;
        private final FloatMatrix a;

        public AnalysisOutput(FloatMatrix floatMatrix, int n) {
            this.count = n;
            this.a = floatMatrix;
        }

        public FloatMatrix getA() {
            return this.a;
        }

        public int getCount() {
            return this.count;
        }
    }
}

