/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.type.RgbBands;

public class PlotDialog
extends JDialog {
    public PlotDialog(List<RtFrame> list) {
        this.setTitle("Plot");
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().add((Component)new Content(list), "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void show(List<RtFrame> list) {
        PlotDialog plotDialog = new PlotDialog(list);
        plotDialog.setVisible(true);
    }

    private class Content
    extends JPanel {
        BufferedImage image;

        public Content(List<RtFrame> list) {
            int n;
            RtFrame rtFrame = list.get(0);
            int n2 = rtFrame.getColumns().value;
            int n3 = list.size();
            this.setPreferredSize(new Dimension(n2, n3));
            this.image = new BufferedImage(n2, n3, 1);
            WritableRaster writableRaster = this.image.getRaster();
            int[] nArray = new int[3];
            RgbBands rgbBands = RgbBands.fromBandCount(rtFrame.getRows());
            float f = Float.MAX_VALUE;
            float f2 = Float.MIN_VALUE;
            for (int i = 0; i < n3; ++i) {
                RtFrame rtFrame2 = list.get(i);
                for (int j = 0; j < n2; ++j) {
                    for (n = 0; n < rgbBands.size(); ++n) {
                        float f3 = rtFrame2.getFrameValue(rgbBands.get(n), j);
                        f = Math.min(f, f3);
                        f2 = Math.max(f2, f3);
                    }
                }
            }
            float f4 = f2 - f;
            for (int i = 0; i < n3; ++i) {
                RtFrame rtFrame3 = list.get(i);
                for (n = 0; n < n2; ++n) {
                    for (int j = 0; j < rgbBands.size(); ++j) {
                        float f5 = rtFrame3.getFrameValue(rgbBands.get(j), n);
                        nArray[j] = (int)((f5 - f) / f4 * 256.0f);
                    }
                    writableRaster.setPixel(n, i, nArray);
                }
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.image, 0, 0, null);
        }
    }
}

