/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.usgs.SpecprFile;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsMicaFile;
import se.prediktera.breeze.common.realtime.unmixing.ASDFileParser;
import se.prediktera.breeze.common.realtime.unmixing.IResampler;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.map.common.error.Logg;

public class Reference
extends BreezeIntervalClass {
    private final String name;
    protected float[] wavelength;
    protected FloatMatrix matrix;
    private final CatClass catClass = new CatClass("", null);
    private boolean customColor;
    private final InformationPanel.InformationList informationList = new InformationPanel.InformationList();
    private File file;

    public Reference(String string) {
        this.name = string;
        this.catClass.setColor(Color.black);
    }

    public Reference(File file) {
        this(FileHelper.getFileName(file));
        try {
            this.parseFiles(Files.readAllLines(file.toPath()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Reference(String string, List<String> list) {
        this(string);
        this.parseFiles(list);
    }

    public void parseFiles(List<String> list) {
        int n;
        List<Object> list2;
        List<Object> list3;
        int n2 = Reference.getFirstRow(list);
        String string = list.get(n2);
        String string2 = Reference.getDelimiter(string);
        if (this.isVerticle(list)) {
            list3 = new ArrayList();
            list2 = new ArrayList();
            for (n = n2; n < list.size(); ++n) {
                String[] stringArray = list.get(n).split(string2, 2);
                if (stringArray.length != 2) continue;
                list3.add(stringArray[0]);
                list2.add(stringArray[1]);
            }
        } else {
            list3 = Arrays.asList(string.split(string2));
            list2 = Arrays.asList(list.get(n2 + 1).split(string2));
        }
        n = list3.size() - 1;
        this.wavelength = new float[n];
        this.matrix = new FloatMatrix(n, 1);
        for (int i = 1; i < list3.size(); ++i) {
            String string3 = ((String)list3.get(i)).trim();
            String string4 = ((String)list2.get(i)).trim();
            this.wavelength[i - 1] = RtDataFormat.toNumberFloat(string3);
            this.matrix.put(i - 1, RtDataFormat.toNumberFloat(string4));
        }
    }

    private static int getFirstRow(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).toLowerCase();
            if (!string.startsWith("wavelength")) continue;
            return i;
        }
        return 0;
    }

    public static String getDelimiter(String string) {
        if (string.contains(";")) {
            return ";";
        }
        if (string.contains("\t")) {
            return "\t";
        }
        return ",";
    }

    private boolean isVerticle(List<String> list) {
        return list.size() > 5;
    }

    public FloatMatrix interpolateTo(float[] fArray, IResampler iResampler) {
        return new FloatMatrix(this.interpolateToArray(fArray, iResampler));
    }

    public float[] interpolateToArray(float[] fArray, IResampler iResampler) {
        return iResampler.tryResample(this.matrix.data, this.wavelength, fArray);
    }

    public void interpolate(float[] fArray, IResampler iResampler) {
        this.matrix = this.interpolateTo(fArray, iResampler);
        this.wavelength = fArray;
    }

    public void transform(List<RtModule> list) {
        Reference.transform(list, this.matrix);
    }

    public static void transform(List<RtModule> list, FloatMatrix floatMatrix) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).apply(floatMatrix, 0);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public InformationPanel.InformationList getInformation() {
        return this.informationList;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public float Min() {
        return this.wavelength[0];
    }

    public float Max() {
        return this.wavelength[this.wavelength.length - 1];
    }

    public CatClass getCatClass() {
        return this.catClass;
    }

    public Color getColor() {
        return this.catClass.getColor();
    }

    public void setColor(Color color, boolean bl) {
        this.customColor = bl;
        this.catClass.setColor(color);
    }

    public boolean isCustomColor() {
        return this.customColor;
    }

    public void setWavelength(float[] fArray) {
        this.wavelength = fArray;
    }

    public float[] getWavelength() {
        return this.wavelength;
    }

    public void setMatrix(FloatMatrix floatMatrix) {
        this.matrix = floatMatrix;
    }

    public FloatMatrix getMatrix() {
        return this.matrix;
    }

    public int getLength() {
        return this.matrix.rows;
    }

    public static List<File> readFiles(File file, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            arrayList.add(new File(file, string + ".txt"));
        }
        return arrayList;
    }

    public static List<Reference> read(List<File> list, Workflow workflow) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        for (File file : list) {
            arrayList.addAll(Reference.read(file, workflow));
        }
        return arrayList;
    }

    public static List<Reference> read(File file, Workflow workflow) {
        List<Reference> list = Reference.readReferences(file, workflow);
        Reference.checkScaling(workflow, list);
        return list;
    }

    private static void checkScaling(Workflow workflow, List<Reference> list) {
        double d = UsgsMicaFile.calculateWavelengthFactor(workflow);
        for (Reference reference : list) {
            double d2;
            float[] fArray = reference.getWavelength();
            if (fArray.length == 0 || !((d2 = Reference.findMaxValue(fArray)) < 10.0 && d == 1000.0) && (!(d2 > 10.0) || d != 1.0)) continue;
            double d3 = d2 > 10.0 ? 1.0 / d : d;
            int n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = (float)((double)fArray[n2] * d3);
            }
        }
    }

    private static double findMaxValue(float[] fArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (float f : fArray) {
            if (!((double)f > d)) continue;
            d = f;
        }
        return d;
    }

    public static List<Reference> readReferences(File file, Workflow workflow) {
        String string = FileHelper.getFileExtension(file);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        if (string.equalsIgnoreCase("sli")) {
            arrayList.addAll(Reference.readSli(file));
        } else if (string.equalsIgnoreCase("asd")) {
            arrayList.add(new ASDFileParser(file).getReference());
        } else if (string.equalsIgnoreCase("mcf")) {
            arrayList.addAll(new UsgsMicaFile(file, workflow).getReferences());
        } else if (string.equalsIgnoreCase("")) {
            arrayList.addAll(new SpecprFile(file, workflow).getReferences());
        } else {
            try {
                List<String> list = Files.readAllLines(file.toPath());
                if (list.size() > 0) {
                    if (Reference.isMultipleColumns(list)) {
                        Reference.readMultipleColumns(list, arrayList);
                    } else if (Reference.isMultiple((String)list.get(0))) {
                        Reference.readMultiple(list, arrayList);
                    } else {
                        arrayList.add(new Reference(FileHelper.getFileName(file), list));
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Not a valid end member file:\n\n" + file.getAbsolutePath(), exception);
            }
        }
        for (Reference reference : arrayList) {
            reference.setFile(file);
        }
        return arrayList;
    }

    private void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static List<Reference> readSli(File file) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        RawFileImpl rawFileImpl = new RawFileImpl(file);
        RawHeader rawHeader = rawFileImpl.header();
        BandNames bandNames = rawHeader.spectraNames();
        FrameListFromRaw frameListFromRaw = rawFileImpl.readFrames();
        float[] fArray = rawHeader.bandNames().toFloatArray();
        for (int i = 0; i < frameListFromRaw.size(); ++i) {
            Reference reference = new Reference(bandNames.get(i));
            reference.setColor(RtPerfectSpread.generateColor(i), false);
            RawFrame rawFrame = (RawFrame)frameListFromRaw.get(i);
            FloatMatrix floatMatrix = new FloatMatrix(rawFrame.getColumns().value);
            for (int j = 0; j < floatMatrix.rows; ++j) {
                floatMatrix.put(j, rawFrame.getFrameValue(0, j));
            }
            reference.setMatrix(floatMatrix);
            reference.setWavelength(fArray);
            arrayList.add(reference);
        }
        return arrayList;
    }

    public static boolean isMultiple(File file) throws IOException {
        if (file.isFile() && file.exists()) {
            boolean bl;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                bl = Reference.isMultiple(bufferedReader.readLine());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    Logg.error((String)"Error checking multiple file", (Throwable)exception);
                }
            }
            bufferedReader.close();
            return bl;
        }
        return false;
    }

    public static boolean isMultiple(String string) {
        return string.startsWith("ENVI ASCII Plot File");
    }

    public static boolean isMultipleColumns(List<String> list) {
        if (list.size() > 0) {
            String[] stringArray = list.get(0).split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().equalsIgnoreCase("column_" + (i + 1))) continue;
                return false;
            }
            return stringArray.length > 0;
        }
        return false;
    }

    public static void readMultiple(List<String> list, ArrayList<Reference> arrayList) {
        Object object;
        String string;
        Object object2;
        String string2;
        int n;
        for (n = 2; n < list.size() && (string2 = list.get(n)).startsWith("Column"); ++n) {
            object2 = string2.split(":", 2);
            if (((String[])object2).length <= 1) continue;
            string = object2[1].trim();
            object = new Reference(string);
            object.setColor(RtPerfectSpread.generateColor(arrayList.size() + 1), false);
            arrayList.add((Reference)object);
        }
        if (arrayList.size() > 0) {
            string2 = Reference.getDelimiterMultiple(list.get(n), arrayList.size());
            object2 = new ArrayList();
            while (n < list.size()) {
                string = list.get(n);
                object = string.trim().split(string2);
                if (((String[])object).length >= arrayList.size()) {
                    float[] fArray = new float[((String[])object).length];
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        fArray[i] = RtDataFormat.toNumberFloat(object[i].trim());
                    }
                    ((ArrayList)object2).add(fArray);
                }
                ++n;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = arrayList.get(i);
                object.wavelength = new float[((ArrayList)object2).size()];
                object.matrix = new FloatMatrix(((ArrayList)object2).size(), 1);
                for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                    float[] fArray = (float[])((ArrayList)object2).get(j);
                    object.wavelength[j] = fArray[0];
                    object.matrix.put(j, 0, fArray[i + 1]);
                }
            }
        }
    }

    public static void readMultipleColumns(List<String> list, ArrayList<Reference> arrayList) {
        if (list == null || list.size() <= 2) {
            return;
        }
        String string = list.get(1);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String[] stringArray2;
            int n;
            String string3 = stringArray[i].trim();
            if (!string3.toLowerCase().startsWith("wavelength") || i + 1 >= stringArray.length) continue;
            String string4 = stringArray[i + 1].trim();
            Reference reference = new Reference(string4);
            reference.setColor(RtPerfectSpread.generateColor(arrayList.size() + 1), false);
            arrayList.add(reference);
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            ArrayList<Float> arrayList3 = new ArrayList<Float>();
            for (n = 2; n < list.size() && (stringArray2 = (string2 = list.get(n)).trim().split(",")).length > i + 1; ++n) {
                String string5 = stringArray2[i].trim();
                String string6 = stringArray2[i + 1].trim();
                if (string5.isEmpty() || string6.isEmpty()) break;
                try {
                    float f = RtDataFormat.toNumberFloat(string5);
                    float f2 = RtDataFormat.toNumberFloat(string6);
                    if (f2 < 0.0f) continue;
                    arrayList2.add(Float.valueOf(f));
                    arrayList3.add(Float.valueOf(f2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid number format at line " + n + ": " + string2);
                    break;
                }
            }
            reference.wavelength = new float[arrayList2.size()];
            reference.matrix = new FloatMatrix(arrayList3.size(), 1);
            for (n = 0; n < arrayList2.size(); ++n) {
                reference.wavelength[n] = ((Float)arrayList2.get(n)).floatValue();
                reference.matrix.put(n, 0, ((Float)arrayList3.get(n)).floatValue());
            }
        }
    }

    private static String getDelimiterMultiple(String string, int n) {
        int n2 = StringHelper.countCharInLine(string, ';');
        if (n2 > 0 && n2 >= n - 1) {
            return ";";
        }
        return "\\ +";
    }
}

