/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.unmixing.PlotDialog;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;

public class Sample {
    private final List<RtFrame> frames;
    public float[] wavelength;

    public Sample(File file) {
        int n;
        RawFileImpl rawFileImpl = new RawFileImpl(file);
        FrameListFromRaw frameListFromRaw = new FrameListFromRaw(file);
        RawHeader rawHeader = rawFileImpl.header();
        this.wavelength = new float[rawHeader.bandCount().value];
        BandNames bandNames = rawHeader.bandNames();
        for (n = 0; n < this.wavelength.length; ++n) {
            this.wavelength[n] = RtDataFormat.toNumberFloat(bandNames.get(n));
        }
        this.frames = new ArrayList<RtFrame>();
        for (n = 0; n < frameListFromRaw.size(); ++n) {
            RtFrame rtFrame = new RtFrame((Frame)frameListFromRaw.get(n), 1);
            for (int i = 0; i < rtFrame.getColumns().value; ++i) {
                for (int j = 0; j < rtFrame.getRows().value; ++j) {
                    float f = rtFrame.getFrameValue(j, i);
                    f = (float)Math.max(0.001, (double)f);
                    float f2 = (float)(-Math.log(f));
                    rtFrame.setFrameValue(j, i, f2);
                }
            }
            this.frames.add(rtFrame);
        }
    }

    public Sample(List<RtFrame> list, float[] fArray) {
        this.frames = list;
        this.wavelength = fArray;
    }

    public List<RtFrame> getFrames() {
        return this.frames;
    }

    public void showImage() {
        PlotDialog.show(this.frames);
    }

    public Sample crop(int[] nArray) {
        int[] nArray2 = Sample.wavelengthStartEnd(nArray, this.wavelength);
        float[] fArray = Sample.wavelengthCrop(nArray2, this.wavelength);
        ArrayList<RtFrame> arrayList = new ArrayList<RtFrame>();
        for (int i = 0; i < this.frames.size(); ++i) {
            RtFrame rtFrame = this.frames.get(i);
            RtFrame rtFrame2 = new RtFrame(new FloatMatrix(fArray.length, rtFrame.columns.value), 1);
            Sample.copyRegion(rtFrame.getMatrix(0), rtFrame2.getMatrix(0), nArray2);
            arrayList.add(rtFrame2);
        }
        return new Sample(arrayList, fArray);
    }

    public static int[] wavelengthStartEnd(int[] nArray, float[] fArray) {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] >= (float)nArray[0] && n < 0) {
                n = i;
            }
            if (!(fArray[i] <= (float)nArray[1])) continue;
            n2 = i;
        }
        return new int[]{n, n2};
    }

    public static float[] wavelengthCrop(int[] nArray, float[] fArray) {
        float[] fArray2 = new float[nArray[1] - nArray[0] + 1];
        int n = nArray[0];
        int n2 = 0;
        while (n <= nArray[1]) {
            fArray2[n2] = fArray[n];
            ++n;
            ++n2;
        }
        return fArray2;
    }

    public static void copyRegion(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[] nArray) {
        for (int i = 0; i < floatMatrix2.columns; ++i) {
            int n = nArray[0];
            int n2 = 0;
            while (n <= nArray[1]) {
                float f = floatMatrix.get(n, i);
                floatMatrix2.put(n2, i, f);
                ++n;
                ++n2;
            }
        }
    }
}

