/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.lang3.ObjectUtils;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.descriptor.usgs.groups.MicaGroups;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SpectralLibraryGroupParameter;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeColorChooser;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.DynamicTableModel;
import se.prediktera.breeze.frontend.common.swing.table.editor.DefaultComponentCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.main.record.edit.DuplicateStringContentValidator;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;

public class SelectMembersPanel
extends AbstractBreezeCustomPanel {
    private final BreezeFrame frame;
    private final List<? extends Reference> references;
    private final SpectralLibraryGroupParameter spectralLibraryGroupParameter;
    private final File endmemberFile;
    private GroupingUtils.Grouping grouping;
    private final InformationPanel informationPanel;
    private final BreezeTablePanel table;

    public SelectMembersPanel(final BreezeFrame breezeFrame, final List<? extends Reference> list, SpectralLibraryGroupParameter spectralLibraryGroupParameter, File file) {
        this.frame = breezeFrame;
        this.references = list;
        this.spectralLibraryGroupParameter = spectralLibraryGroupParameter;
        this.endmemberFile = file;
        if (spectralLibraryGroupParameter != null) {
            this.grouping = spectralLibraryGroupParameter.getGrouping();
            this.grouping.setUpdated(false);
        }
        this.informationPanel = new InformationPanel();
        this.setLayout(new BorderLayout());
        BreezeSplitPane breezeSplitPane = new BreezeSplitPane();
        BreezeSplitPane breezeSplitPane2 = new BreezeSplitPane(0);
        this.table = new BreezeTablePanel();
        this.table.getScrollPane().setHorizontalScrollBarPolicy(31);
        this.table.setRootModel(new DynamicTableModel(this.table.getHeaderVec(), this.table.getHeaderColor(), true){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }
        });
        this.table.getTable().setDefaultRenderer(CatClass.class, new CatClassCellRenderer());
        this.table.getTable().setDefaultEditor(CatClass.class, new CatClassCellEditor(() -> {}));
        this.table.getTable().setDefaultRenderer(MicaGroups.MicaCatClass.class, new MicaCatClassCellRenderer());
        this.table.getTable().setDefaultRenderer(GroupCatClass.class, new MicaCatClassCellRenderer());
        this.table.addRowHeader(50);
        SpectralPlot spectralPlot = new SpectralPlot(){

            public String getToolTipText(MouseEvent mouseEvent) {
                DataWrapper dataWrapper;
                double[] dArray = new double[2];
                this.Screen2Real(dArray, mouseEvent.getX(), mouseEvent.getY());
                if (dArray[0] > 0.0 && (dataWrapper = this.getWrapperClosestTo(dArray[0], dArray[1])) != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
                    stringBuilder.append("<tr><td>").append("Name:").append("</td>");
                    stringBuilder.append("<td>").append(dataWrapper).append("</td></tr>");
                    stringBuilder.append("<tr><td>").append(this.getXaxisDesc()).append(":").append("</td>");
                    stringBuilder.append("<td>").append(RtDataFormat.toString(dArray[0])).append("</td></tr>");
                    stringBuilder.append("<tr><td>").append(this.getYaxisDesc()).append(":").append("</td>");
                    stringBuilder.append("<td>").append(RtDataFormat.toString(dArray[1])).append("</td></tr>");
                    stringBuilder.append("</table></html>");
                    return stringBuilder.toString();
                }
                return super.getToolTipText(mouseEvent);
            }
        };
        ToolTipManager.sharedInstance().registerComponent((JComponent)spectralPlot);
        if (list.isEmpty()) {
            throw new ErrorHandler.InformationMessageException("No spectrum available for selection");
        }
        spectralPlot.setYdesc("Reflectance");
        spectralPlot.setXdesc("Wavelength");
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        spectralPlot.setBackground(breezeTheme.getPanelBackground());
        spectralPlot.setForeground(breezeTheme.getLabelForeground());
        ListSelectionModel listSelectionModel = this.table.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(arg_0 -> this.lambda$new$1(spectralPlot, arg_0));
        this.table.getTable().addPropertyChangeListener(arg_0 -> this.lambda$new$2(spectralPlot, arg_0));
        this.table.initTable(new DefaultBreezeTableImpl(){

            @Override
            public Vector<Object> createVOVector(Object object) {
                Vector<Object> vector = new Vector<Object>();
                Reference reference = (Reference)object;
                CatClass catClass = reference.getCatClass();
                vector.add(catClass);
                vector.add(reference);
                if (SelectMembersPanel.this.showGroupColumn()) {
                    GroupCatClass groupCatClass = new GroupCatClass(reference.getName(), catClass.getFactor(), SelectMembersPanel.this.grouping);
                    if (groupCatClass.getGroupClass() != null) {
                        vector.add(groupCatClass);
                    } else {
                        vector.add(new GroupCatClass("", null, SelectMembersPanel.this.grouping));
                    }
                }
                return vector;
            }

            @Override
            public List<Object> getTableHeader(List list) {
                if (SelectMembersPanel.this.showGroupColumn()) {
                    return Arrays.asList("", "Name", SelectMembersPanel.this.grouping.getGroupingName());
                }
                return Arrays.asList("", "Name");
            }

            @Override
            public int[] getColumnWidth() {
                if (SelectMembersPanel.this.showGroupColumn()) {
                    return new int[]{10, 45, 45};
                }
                return new int[]{15, 85};
            }
        }, null, false);
        this.table.addIntervalListener(new int[]{1}, () -> {});
        this.table.setTableList(list, list.getFirst());
        this.table.setRowHeight(30);
        int n = 400 + (this.showGroupColumn() ? 200 : 0);
        this.table.setMinimumSize(new Dimension(n / 2, 0));
        this.table.setPreferredSize(new Dimension(n, 0));
        this.table.getTable().addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SelectMembersPanel this$0;
            {
                this.this$0 = selectMembersPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
                    breezeContextMenu.addTitle("Choose color for selected rows");
                    BreezeColorChooser breezeColorChooser = new BreezeColorChooser(false);
                    Object object = this.this$0.table.getSelectedVO();
                    if (object instanceof Reference) {
                        Reference reference = (Reference)object;
                        breezeColorChooser.setSelectedItem(reference.getColor());
                    }
                    breezeColorChooser.addActionListener(actionEvent -> {
                        for (Object e : this.this$0.table.getSelectedValues()) {
                            ((Reference)e).setColor(breezeColorChooser.getSelectedColor(), true);
                            this.this$0.table.updateTable();
                        }
                        breezeContextMenu.close();
                    });
                    breezeColorChooser.requestFocus();
                    breezeContextMenu.addComponent(breezeColorChooser);
                    breezeContextMenu.addSeparator();
                    if (this.this$0.showGroupColumn()) {
                        breezeContextMenu.addButtonCloseClick("Group", () -> this.this$0.addToGroup());
                        breezeContextMenu.addButtonCloseClick("Ungroup", () -> this.this$0.unGroup());
                        breezeContextMenu.addSeparator();
                    }
                    breezeContextMenu.addButtonCloseClick("Include Only", () -> this.this$0.setIncluded(this.this$0.table, true, true));
                    breezeContextMenu.addButtonCloseClick("Include", () -> this.this$0.setIncluded(this.this$0.table, true, false));
                    breezeContextMenu.addButtonCloseClick("Exclude", () -> this.this$0.setIncluded(this.this$0.table, false, false));
                    if (breezeContextMenu.resize()) {
                        breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                        breezeContextMenu.setPositionLater(mouseEvent);
                    }
                }
            }
        });
        breezeSplitPane.setLeftComponent((Component)((Object)this.table));
        breezeSplitPane.setRightComponent(breezeSplitPane2);
        breezeSplitPane2.setTopComponent((Component)spectralPlot);
        breezeSplitPane2.setBottomComponent(new BreezeScrollPane(this.informationPanel));
        breezeSplitPane2.setResizeWeight(0.8);
        breezeSplitPane2.setOneTouchExpandable(true);
        this.add((Component)breezeSplitPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 5));
        jPanel.setOpaque(false);
        jPanel.add(EntryMainHelper.createButton("Include Only", "explore/add_box", () -> this.setIncluded(this.table, true, true)));
        jPanel.add(new BreezeSeparator(1, 4, 60));
        jPanel.add(EntryMainHelper.createButton("Include", "explore/library_add", () -> this.setIncluded(this.table, true, false)));
        jPanel.add(EntryMainHelper.createButton("Exclude", "explore/disabled_by_default", () -> this.setIncluded(this.table, false, false)));
        jPanel.add(new BreezeSeparator(1, 4, 60));
        jPanel.add(EntryMainHelper.createButton("Select all", "explore/done_all", () -> this.table.getTable().selectAll()));
        jPanel.add(EntryMainHelper.createButton("Deselect all", "explore/remove_done", () -> this.table.getTable().clearSelection()));
        jPanel.add(new BreezeSeparator(1, 4, 60));
        if (this.showGroupColumn()) {
            jPanel.add(EntryMainHelper.createButton("Group", "tab_group", this::addToGroup));
            jPanel.add(EntryMainHelper.createButton("Ungroup", "ungroup", this::unGroup));
            jPanel.add(new BreezeSeparator(1, 4, 60));
        }
        final BreezeInputField breezeInputField = new BreezeInputField("Filter", "", "", textActionEvent -> this.filter(list, textActionEvent.getText()), BreezeInputFieldHelper.Format.TwoRows);
        BreezeTextField breezeTextField = breezeInputField.getTextField();
        breezeTextField.setCheckTextChanged(false);
        breezeTextField.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ SelectMembersPanel this$0;
            {
                this.this$0 = selectMembersPanel;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.this$0.filter(list, breezeInputField.getValue());
            }
        });
        Dimension dimension = new Dimension(200, 25);
        breezeTextField.setMinimumSize(dimension);
        breezeTextField.setPreferredSize(dimension);
        jPanel.add(breezeInputField);
        this.add((Component)jPanel, "North");
        BreezeFrame.setRelativeSize(this, 0.8);
    }

    private void filter(List<? extends Reference> list, String string) {
        List<? extends Reference> list2;
        this.table.setTableList(list2, !(list2 = this.doFilter(list, string)).isEmpty() ? list2.getFirst() : null);
    }

    private List<? extends Reference> doFilter(List<? extends Reference> list, String string) {
        if (string.isEmpty()) {
            return list;
        }
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        String string2 = StringHelper.removeSpace(string.toLowerCase());
        for (Reference reference : list) {
            String string3 = StringHelper.removeSpace(reference.getName());
            if (string3.toLowerCase().contains(string2)) {
                arrayList.add(reference);
                continue;
            }
            if (!this.showGroupColumn()) continue;
            this.grouping.getGroupFromEndMember(reference.getName()).ifPresent(group -> arrayList.add(reference));
        }
        return arrayList;
    }

    private void updatePlot(BreezeTablePanel breezeTablePanel, SpectralPlot spectralPlot) {
        ArrayList<6> arrayList = new ArrayList<6>();
        List list = breezeTablePanel.getSelectedValues();
        for (Object e : list) {
            Reference reference = (Reference)e;
            final float[] fArray = reference.getMatrix().data;
            DataWrapper dataWrapper = new DataWrapper(this, reference.getWavelength(), fArray, reference.getName()){

                public boolean isMissing(int n) {
                    return fArray[n] == 0.0f;
                }
            };
            dataWrapper.setColor(reference.getColor());
            dataWrapper.setStroke((Stroke)new BasicStroke(2.0f, 1, 0, 10.0f));
            arrayList.add(dataWrapper);
        }
        this.informationPanel.set(list);
        spectralPlot.setData(arrayList);
    }

    private void addToGroup() {
        if (this.grouping.isNone()) {
            throw new ErrorHandler.InformationMessageException("Please select a group");
        }
        this.showCopyReadOnlyGroupingAndChangeCurrentGrouping(this::showAddToGroupDialog);
    }

    private void unGroup() {
        this.showCopyReadOnlyGroupingAndChangeCurrentGrouping(grouping -> {
            for (Object e : this.table.getSelectedValues()) {
                Reference reference = (Reference)e;
                String string = reference.getName();
                grouping.getGroupFromEndMember(string).ifPresent(group -> group.removeElement(string));
            }
            this.table.updateTable();
            this.table.repaint();
        });
    }

    private void showCopyReadOnlyGroupingAndChangeCurrentGrouping(final Consumer<GroupingUtils.Grouping> consumer) {
        if (this.grouping.isReadOnly()) {
            BreezeActionListener breezeActionListener = new BreezeActionListener(){
                final /* synthetic */ SelectMembersPanel this$0;
                {
                    this.this$0 = selectMembersPanel;
                }

                @Override
                public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    GroupingUtils.Grouping grouping = this.this$0.grouping.copyWithNewIdAndSourceFile();
                    grouping.setGroupingName(breezeActionEvent.getInputText());
                    this.this$0.grouping = grouping;
                    this.this$0.table.updateHeaderVec();
                    this.this$0.table.updateTableHeaders();
                    consumer.accept(grouping);
                }
            };
            BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Enter new groupings name", "The selected grouping is read-only - enter a new name for the copy of this grouping", this.grouping.getGroupingName() + " (copy)", breezeActionListener);
        } else {
            consumer.accept(this.grouping);
        }
    }

    private void showAddToGroupDialog(GroupingUtils.Grouping grouping) {
        AddToGroupDialog addToGroupDialog = new AddToGroupDialog(grouping);
        BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Add to group (" + grouping.getGroupingName() + ")", "", (AbstractBreezeCustomPanel)addToGroupDialog, null, breezeActionEvent -> {
            GroupingUtils.Group group2 = addToGroupDialog.getResult();
            for (Object e : this.table.getSelectedValues()) {
                Reference reference = (Reference)e;
                String string = reference.getName();
                grouping.getGroupFromEndMember(string).ifPresent(group -> group.removeElement(string));
                group2.getElements().add(string);
            }
            if (addToGroupDialog.isNewGroup()) {
                grouping.addGroup(group2);
                grouping.setUpdated(true);
            }
            grouping.addEndMemberFile(this.endmemberFile);
            this.table.updateTable();
            this.table.repaint();
        });
    }

    private void setIncluded(BreezeTablePanel breezeTablePanel, boolean bl, boolean bl2) {
        if (bl2) {
            for (Reference reference : this.references) {
                reference.setIncluded(!bl);
            }
        }
        for (Reference reference : breezeTablePanel.getSelectedValues()) {
            reference.setIncluded(bl);
        }
        breezeTablePanel.repaint();
    }

    public List<Reference> getIncluded() {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        for (int i = 0; i < this.table.getTable().getRowCount(); ++i) {
            Reference reference = (Reference)this.table.getTable().getValueAt(i, 1);
            if (!reference.isIncluded()) continue;
            arrayList.add(reference);
        }
        return arrayList;
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return this.grouping;
    }

    public boolean showGroupColumn(OptionParameter.Option option) {
        return option != null && option.getIndex() != 2;
    }

    private boolean showGroupColumn() {
        return this.spectralLibraryGroupParameter != null && !this.grouping.isNone();
    }

    private /* synthetic */ void lambda$new$2(2 var1_1, PropertyChangeEvent propertyChangeEvent) {
        if ("tableCellEditor".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getOldValue() != null) {
            this.updatePlot(this.table, var1_1);
        }
    }

    private /* synthetic */ void lambda$new$1(2 var1_1, ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updatePlot(this.table, var1_1);
        }
    }

    private class InformationPanel
    extends JPanel {
        private final JPanel panel;

        public InformationPanel() {
            super(new GridBagLayout());
            this.panel = new JPanel(new GridBagLayout());
            Color color = BreezeTheme.getInstance().getPanelBackground();
            this.setBackground(color);
            this.panel.setBackground(color);
            this.add((Component)new BreezeLabel("Information"), GridBagHelper.create(0, new Insets(6, 6, 0, 6)));
            this.add((Component)this.panel, GridBagHelper.createLast(1, new Insets(0, 0, 0, 0)));
        }

        public void set(List list) {
            this.panel.removeAll();
            if (list.size() == 1) {
                Reference reference = (Reference)list.getFirst();
                this.panel.add((Component)new BreezeLabelField("Name", 100, reference.getName(), 0), GridBagHelper.create(this.panel.getComponentCount(), new Insets(12, 12, 0, 12)));
                if (SelectMembersPanel.this.showGroupColumn()) {
                    SelectMembersPanel.this.grouping.getGroupFromEndMember(reference.getName()).ifPresent(group -> this.panel.add((Component)new BreezeLabelField("Group", 100, group.getGroupName(), 0), GridBagHelper.create(this.panel.getComponentCount(), new Insets(12, 12, 0, 12))));
                }
                InformationPanel.InformationList informationList = reference.getInformation();
                for (Map.Entry<String, String> entry : informationList.getList()) {
                    this.panel.add((Component)new BreezeLabelField(entry.getKey(), 100, entry.getValue(), 0), GridBagHelper.create(this.panel.getComponentCount(), new Insets(12, 12, 0, 12)));
                }
            } else if (list.size() > 1) {
                for (int i = 0; i < list.size(); ++i) {
                    Reference reference = (Reference)list.get(i);
                    this.panel.add((Component)new BreezeLabelField("Name " + (i + 1), 100, reference.getName(), 0), GridBagHelper.create(this.panel.getComponentCount(), new Insets(12, 12, 0, 12)));
                }
            }
            this.panel.add((Component)new BreezeLabel(""), GridBagHelper.createLast(this.panel.getComponentCount(), new Insets(0, 0, 0, 0)));
            this.revalidate();
            this.repaint();
        }
    }

    public static class CatClassCellRenderer
    extends BreezeTableCellRenderer {
        private CatClass catClass = null;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof CatClass) {
                this.catClass = (CatClass)object;
            }
            return super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.getBackground());
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.fillRect(0, 0, n, n2);
            CatClass.render(graphics, this.catClass, 7, n2 - 14);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n3 = n2 / 3;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n - n3 * 2, n2 - n3 * 2);
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(n3, 0.0f);
            generalPath.lineTo((float)n3 / 2.0f, n3);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.setTransform(affineTransform);
            this.getUI().paint(graphics2D, this);
        }
    }

    public static class CatClassCellEditor
    extends DefaultComponentCellEditor {
        private final BreezeColorChooser comboBox = new BreezeColorChooser(false);
        private CatClass catClass;

        public CatClassCellEditor(CatClassCellListener catClassCellListener) {
            this.comboBox.addActionListener(actionEvent -> {
                this.catClass.setColor(this.comboBox.getSelectedColor());
                catClassCellListener.onChanged();
                this.stopCellEditing();
            });
            this.setClickCountToStart(1);
        }

        @Override
        public final Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            jTable.getSelectionModel().setSelectionInterval(n, n);
            this.catClass = (CatClass)object;
            this.comboBox.setSelectedItem(this.catClass.getColor());
            SwingUtilities.invokeLater(this.comboBox::togglePopup);
            return super.getTableCellEditorComponent(jTable, this.comboBox, bl, n, n2);
        }

        public static interface CatClassCellListener {
            public void onChanged();
        }
    }

    public static class MicaCatClassCellRenderer
    extends BreezeTableCellRenderer {
        private CatClass catClass = null;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof CatClass) {
                this.catClass = (CatClass)object;
            }
            return super.getTableCellRendererComponent(jTable, this.catClass.getName(), bl, bl2, n, n2);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.getBackground());
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.fillRect(0, 0, n, n2);
            CatClass.render(graphics, this.catClass, 7, n2 - 14);
            this.getUI().paint(graphics2D, this);
        }
    }

    private class AddToGroupDialog
    extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
        private final BreezeInputField nameInputField = new BreezeInputField("Enter new group name:", "", " ");
        private final BreezeComboBoxInputField<boxOptions> existingGroupsBox;
        private final BreezeColorChooser colorChooser = new BreezeColorChooser(true);

        public AddToGroupDialog(GroupingUtils.Grouping grouping) {
            this.setLayout(new GridBagLayout());
            this.existingGroupsBox = new BreezeComboBoxInputField("Select group", " ", BreezeInputFieldHelper.Format.TwoRows);
            this.existingGroupsBox.addItem(new boxOptions("-- Add new group --", true));
            this.existingGroupsBox.addSeparator();
            if (ObjectUtils.isNotEmpty(grouping.getGroups())) {
                for (GroupingUtils.Group group : grouping.getGroups()) {
                    this.existingGroupsBox.addItem(new boxOptions(group.getGroupName(), false));
                }
            }
            this.existingGroupsBox.setChangedListener(boxOptions2 -> {
                this.nameInputField.setVisible(this.existingGroupsBox.getSelectedItem().isAddNew);
                this.colorChooser.setVisible(this.existingGroupsBox.getSelectedItem().isAddNew);
            });
            this.add(this.existingGroupsBox, GridBagHelper.create(this.getComponentCount(), new Insets(48, 24, 0, 24)));
            this.add((Component)this.nameInputField, GridBagHelper.create(this.getComponentCount(), new Insets(48, 24, 0, 24)));
            this.nameInputField.getTextField().setName("input");
            this.nameInputField.addValidator(new DuplicateStringContentValidator(grouping.getGroupNames()));
            this.colorChooser.setSelectedItem(RtPerfectSpread.generateColor(Optional.ofNullable(grouping.getGroups()).orElse(Collections.emptyList()).size()));
            this.colorChooser.setMinimumSize(new Dimension(120, 30));
            this.colorChooser.setPreferredSize(new Dimension(120, 30));
            this.add((Component)this.colorChooser, GridBagHelper.createLeft(this.getComponentCount(), new Insets(12, 24, 0, 24)));
            this.addEndBlock();
        }

        @Override
        public void onShow() {
            SwingUtilities.invokeLater(this.nameInputField::requestFocusAndSelectAll);
        }

        @Override
        public GroupingUtils.Group getResult() {
            if (this.existingGroupsBox.getSelectedItem().isAddNew) {
                return new GroupingUtils.Group(this.nameInputField.getValue(), BreezeColor.colorToHex(this.getColor()), new ArrayList<String>(), SelectMembersPanel.this.grouping);
            }
            return SelectMembersPanel.this.grouping.getGroupFromGroupName(this.existingGroupsBox.getSelectedItem().DisplayName).orElseThrow();
        }

        public boolean isNewGroup() {
            return this.existingGroupsBox.getSelectedItem().isAddNew;
        }

        public Color getColor() {
            return this.colorChooser.getSelectedColor();
        }

        private record boxOptions(String DisplayName, boolean isAddNew) {
            @Override
            public String toString() {
                return this.DisplayName;
            }
        }
    }

    public static class CatClassListCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        private CatClass catClass;

        public CatClassListCellRenderer() {
            super(5, 40);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.catClass = (CatClass)object;
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = (int)((double)this.getHeight() / 4.0);
            CatClass.render(graphics, this.catClass, n, this.getHeight() - n * 2);
        }

        @Override
        protected String getToolTip(Object object) {
            return null;
        }
    }
}

