/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.unmixing;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class SpectralLibraryGroupParameter
extends OptionParameter<GroupingOption> {
    private final MembersSetting.EndMemberFileParameter[] endMemberFileParameters;

    public SpectralLibraryGroupParameter(MembersSetting.EndMemberFileParameter[] endMemberFileParameterArray) {
        super("spectral_library_group", "Group", "0", "");
        this.endMemberFileParameters = endMemberFileParameterArray;
        this.add(new GroupingOption(GroupingUtils.NONE_GROUPING));
        for (GroupingUtils.Grouping grouping : GroupingUtils.listGroupings(this.getEndMemberFiles(null))) {
            this.add(new GroupingOption(grouping));
        }
    }

    public List<File> getEndMemberFiles(Workflow workflow) {
        return Arrays.stream(this.endMemberFileParameters).map(endMemberFileParameter -> endMemberFileParameter.getFile(workflow)).filter(FileHelper::exists).toList();
    }

    public GroupingUtils.Grouping getGrouping() {
        return ((GroupingOption)this.getValueObj()).getGrouping();
    }

    @Override
    public boolean setValue(Object object) {
        GroupingUtils.Grouping grouping;
        if (object instanceof GroupingUtils.Grouping && !this.contains(new GroupingOption(grouping = (GroupingUtils.Grouping)object))) {
            GroupingOption groupingOption = new GroupingOption(grouping);
            this.add(groupingOption);
            return super.setValue(groupingOption);
        }
        if (object instanceof GroupingUtils.Grouping) {
            GroupingUtils.Grouping grouping2 = (GroupingUtils.Grouping)object;
            boolean bl = super.setValue(new GroupingOption(grouping2));
            ((GroupingOption)this.getValueObj()).setDescription(grouping2.getGroupingName());
            return bl;
        }
        return super.setValue(object);
    }

    @Override
    public void remove(GroupingUtils.Grouping grouping) {
        this.remove(new GroupingOption(grouping));
    }

    @Override
    public String getNodeString() {
        return ((GroupingOption)this.getValueObj()).getGrouping().toString();
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        XmlParserHelper.setAttribute((Node)element2, "info", GroupingUtils.serializeToCompactXmlValidString(((GroupingOption)this.getValueObj()).getGrouping()));
        return element2;
    }

    @Override
    public void parse(Node node) {
        super.parse(node);
        String string = XmlParserHelper.getAttribute(node, "info");
        if (string != null) {
            this.setValue(GroupingUtils.deserializeGroupingString(StringEscapeUtils.unescapeXml((String)string), null));
        }
    }

    public int getHashCode() {
        GroupingUtils.Grouping grouping = this.getGrouping();
        if (grouping.hasLegacyHashCode()) {
            return Integer.parseUnsignedInt(grouping.getLegacyHashCode(), 16);
        }
        return grouping.hashCode();
    }

    public static class GroupingOption
    extends OptionParameter.Option {
        private final GroupingUtils.Grouping grouping;

        public GroupingOption(GroupingUtils.Grouping grouping) {
            super(grouping.getId(), grouping.getGroupingName());
            this.grouping = grouping;
        }

        @Generated
        public GroupingUtils.Grouping getGrouping() {
            return this.grouping;
        }
    }
}

