/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.variable;

import java.awt.Color;
import java.util.Arrays;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.realtime.variable.SampleTrackInterface;
import se.prediktera.breeze.common.realtime.variable.VariableHolder;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class RtBasicVariable {
    protected final VariableHolder holder;
    private final String name;
    protected float min;
    protected float max;
    protected float abs;
    protected float invAbs;
    private final float[] minArray = new float[3];
    private final float[] maxArray = new float[3];
    private final float[] invAbsArray = new float[3];
    private boolean dynamic;

    public RtBasicVariable(VariableHolder variableHolder, String string, float f, float f2) {
        this.holder = variableHolder;
        this.name = string;
        this.updateMinMax(f, f2);
    }

    private float invAbs(float f, float f2) {
        float f3 = f2 - f;
        if (f3 > 0.0f) {
            return 1.0f / f3;
        }
        return 0.0f;
    }

    public Factor getFactor() {
        return null;
    }

    public VariableHolder getHolder() {
        return this.holder;
    }

    public void setMinMax(MinMax minMax) {
        this.updateMinMax(minMax.min().floatValue(), minMax.max().floatValue());
        if (this.isRuntime()) {
            TcpManager.getInstance().setProperty("VisualizationVariableMinMax", minMax.min() + ";" + minMax.max());
        }
    }

    protected boolean isRuntime() {
        return this.holder != null && this.holder.isRuntime();
    }

    public MinMax getMinMax() {
        return new MinMax(this.min, this.max);
    }

    public void updateMinMax(float f, float f2) {
        this.min = f;
        this.max = f2;
        this.abs = f2 - f;
        this.invAbs = this.invAbs(f, f2);
        this.dynamic = this.abs == 0.0f;
        Arrays.fill(this.minArray, f);
        Arrays.fill(this.maxArray, f2);
        for (int i = 0; i < this.invAbsArray.length; ++i) {
            this.invAbsArray[i] = this.invAbs(this.minArray[i], this.maxArray[i]);
        }
    }

    public final int getValue(FrameStack frameStack, int n, int n2, int n3) {
        float f = this.getHolder().getResultFrame(frameStack).getFrameValue(n2, n);
        if (this.dynamic) {
            if (f < this.minArray[n3]) {
                this.minArray[n3] = f;
                this.invAbsArray[n3] = this.invAbs(this.minArray[n3], this.maxArray[n3]);
            }
            if (f > this.maxArray[n3]) {
                this.maxArray[n3] = f;
                this.invAbsArray[n3] = this.invAbs(this.minArray[n3], this.maxArray[n3]);
            }
        }
        return BreezeColor.toRGB((f - this.minArray[n3]) * this.invAbsArray[n3]);
    }

    public int[] getValue(FrameStack frameStack, int n, int[][] nArray, int n2) {
        return null;
    }

    public boolean isModel() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    public Color getColor(SampleTrackInterface sampleTrackInterface) {
        return null;
    }

    public BasicAnalyse getAnalyse() {
        return this.holder.getAnalyse();
    }

    public boolean isObjectOnly() {
        return false;
    }

    public String getNameAndId() {
        return this.name;
    }

    public boolean supportLegend() {
        return true;
    }
}

