/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.variable;

import java.awt.Color;
import java.util.HashMap;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.SampleTrackInterface;
import se.prediktera.breeze.common.realtime.variable.VariableHolder;

public class RtCategoryVariable
extends RtBasicVariable {
    private final boolean useblending = true;
    private final double offset = 0.0;
    private final int[][][] classColorIndex;
    private final CategoryFactor factor;
    private final BasicAnalyse.ModelMethod modelMethod;
    private final int[] noColor = new int[4];
    private final boolean objectOnly;
    private final HashMap<Integer, CatClass> hashMap = new HashMap();

    public RtCategoryVariable(VariableHolder variableHolder, CategoryFactor categoryFactor, String string, BasicAnalyse.ModelMethod modelMethod, boolean bl, CategoryFactor categoryFactor2) {
        super(variableHolder, string, 0.0f, 1.0f);
        this.factor = categoryFactor;
        this.modelMethod = modelMethod;
        this.objectOnly = bl;
        this.classColorIndex = categoryFactor2.createClassColorIndexFromClassTypes(true, 0.0);
    }

    @Override
    public final CategoryFactor getFactor() {
        return this.factor;
    }

    @Override
    public final int[] getValue(FrameStack frameStack, int n, int[][] nArray, int n2) {
        Frame frame = this.holder.getResultFrame(frameStack);
        short s = (short)frame.getFrameValue(0, n);
        if (s < this.classColorIndex[n2].length) {
            return this.classColorIndex[n2][s];
        }
        return this.noColor;
    }

    @Override
    public final boolean isModel() {
        return true;
    }

    public BasicAnalyse.ModelMethod getModelMethod() {
        return this.modelMethod;
    }

    @Override
    public Color getColor(SampleTrackInterface sampleTrackInterface) {
        BasicAnalyse basicAnalyse = this.holder.getAnalyse();
        if (basicAnalyse != null && this.factor != null) {
            int n = (int)sampleTrackInterface.getAnalyseValue(basicAnalyse.getUid(), this.factor.getUid());
            CatClass catClass = this.hashMap.get(n);
            if (catClass == null) {
                catClass = this.factor.getClassByValueIdx(n);
                this.hashMap.put(n, catClass);
            }
            return catClass.getColor();
        }
        return null;
    }

    @Override
    public boolean isObjectOnly() {
        return this.objectOnly;
    }

    @Override
    public String getNameAndId() {
        return super.getNameAndId() + ":" + this.factor.getUid();
    }
}

