/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.variable;

import java.awt.Color;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.SampleTrackInterface;
import se.prediktera.breeze.common.realtime.variable.VariableHolder;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.entry.workflow.VisualisationNode;

public class RtVariable
extends RtBasicVariable {
    private final PropertyFactor factor;
    private final int index;
    private final boolean objectOnly;
    private final int[][] colorIndex;

    public RtVariable(VariableHolder variableHolder, PropertyFactor propertyFactor, String string, int n, float f, float f2, boolean bl, VisualisationNode.ColorScale colorScale) {
        super(variableHolder, string, f, f2);
        this.factor = propertyFactor;
        this.index = n;
        this.colorIndex = colorScale.create().createColorIndex();
        this.objectOnly = bl;
    }

    @Override
    public PropertyFactor getFactor() {
        return this.factor;
    }

    @Override
    public final int[] getValue(FrameStack frameStack, int n, int[][] nArray, int n2) {
        return nArray[BreezeColor.toRGB((this.holder.getResultFrame(frameStack).getFrameValue(this.index, n) - this.min) * this.invAbs)];
    }

    @Override
    public Color getColor(SampleTrackInterface sampleTrackInterface) {
        BasicAnalyse basicAnalyse = this.holder.getAnalyse();
        if (basicAnalyse != null && this.factor != null) {
            float f = sampleTrackInterface.getAnalyseValue(basicAnalyse.getUid(), this.factor.getUid());
            int[] nArray = this.colorIndex[BreezeColor.toRGB((f - this.min) * this.invAbs)];
            return new Color(nArray[0], nArray[1], nArray[2]);
        }
        return null;
    }

    @Override
    public boolean isObjectOnly() {
        return this.objectOnly;
    }

    @Override
    public final boolean isModel() {
        return true;
    }

    @Override
    public String getNameAndId() {
        return super.getNameAndId() + ":" + this.factor.getUid();
    }
}

