/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.selection;

import java.util.ArrayList;
import se.prediktera.breeze.common.selection.Bin;
import se.prediktera.breeze.common.selection.MtSample;

public class Distribution {
    private Bin[] bins;
    int nrOfBins;
    float binInterval;
    private float minValue;
    private float maxValue;

    public Distribution(ArrayList<MtSample> arrayList, int n, float f) {
        this.initBins(arrayList, n, f);
        this.calcBins(arrayList, n);
    }

    public Distribution(ArrayList<MtSample> arrayList, int n, int n2) {
        this.nrOfBins = n2;
        this.initBins(arrayList, n);
        this.calcBins(arrayList, n);
    }

    public final boolean calcBins(ArrayList<MtSample> arrayList, int n) {
        int n2 = arrayList.size();
        ArrayList<MtSample> arrayList2 = null;
        int n3 = 0;
        for (int i = 0; i < this.nrOfBins; ++i) {
            arrayList2 = new ArrayList<MtSample>();
            float f = (float)i * this.binInterval + this.minValue;
            float f2 = (float)(i + 1) * this.binInterval + this.minValue;
            Bin bin = new Bin(f, f2);
            while (n3 < n2 && arrayList.get(n3).getValue(n) <= (double)(this.minValue + (float)(i + 1) * this.binInterval)) {
                arrayList2.add(arrayList.get(n3));
                ++n3;
            }
            bin.setSamples(arrayList2);
            this.bins[i] = bin;
        }
        return true;
    }

    public Bin getBin(int n) {
        return this.bins[n];
    }

    public int getBinIdx(double d) {
        return Math.min((int)((d - (double)this.minValue) / (double)(this.maxValue - this.minValue) * (double)this.bins.length), this.nrOfBins - 1);
    }

    public float getBinInterval() {
        return this.binInterval;
    }

    private void initBins(ArrayList<MtSample> arrayList, int n) {
        this.bins = new Bin[this.nrOfBins];
        this.minValue = (float)arrayList.get(0).getValue(n);
        this.maxValue = (float)arrayList.get(arrayList.size() - 1).getValue(n);
        this.binInterval = (this.maxValue - this.minValue) / (float)this.nrOfBins;
    }

    private void initBins(ArrayList<MtSample> arrayList, int n, float f) {
        this.binInterval = f;
        this.minValue = (float)arrayList.get(0).getValue(n);
        this.maxValue = (float)arrayList.get(arrayList.size() - 1).getValue(n);
        this.nrOfBins = (int)Math.ceil((this.maxValue - this.minValue) / f);
        this.bins = new Bin[this.nrOfBins];
    }
}

