/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import no.uib.cipr.matrix.DenseMatrix;
import se.prediktera.breeze.common.selection.Bin;
import se.prediktera.breeze.common.selection.Distribution;
import se.prediktera.breeze.common.selection.Grid;
import se.prediktera.breeze.common.selection.Grid1;
import se.prediktera.breeze.common.selection.Grid2;
import se.prediktera.breeze.common.selection.Grid3;
import se.prediktera.breeze.common.selection.MtSample;

public class MarengoTodeschini2 {
    public static Random staticRandom = new Random(0L);
    private float[][] distanceList;
    private final DenseMatrix scores;
    private final int rows;
    private int columns;

    public MarengoTodeschini2(DenseMatrix denseMatrix) {
        this.scores = denseMatrix;
        this.rows = denseMatrix.numRows();
        this.columns = denseMatrix.numColumns();
    }

    public float getDistance(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2) - n3 - 1;
        return this.distanceList[n3][n4];
    }

    public Grid selectSamples(int n, int n2) {
        staticRandom = new Random(0L);
        boolean bl = n2 > 0;
        ArrayList<MtSample> arrayList = this.createSampleObjects();
        int n3 = n;
        if (n2 > 0) {
            n3 = 10000;
        }
        int n4 = Math.min(n, n3);
        Grid grid = null;
        Grid grid2 = this.arrangeIntoGrid(25, false, arrayList);
        grid = arrayList.size() > n3 ? this.createDesignGrid(grid2, n3) : grid2;
        if (!bl) {
            return grid;
        }
        this.calcAllDistances(grid);
        Grid grid3 = this.createDesignGrid(grid, n4);
        Grid[] gridArray = new Grid[]{grid3, grid};
        if (n2 > 0) {
            this.runMarengoTodeschini(gridArray, 0, 1, n2, false);
        }
        return gridArray[0];
    }

    private Grid arrangeIntoGrid(Distribution[] distributionArray, ArrayList<MtSample> arrayList) {
        Grid grid = null;
        if (distributionArray.length == 1) {
            Bin[] binArray = new Bin[distributionArray[0].nrOfBins];
            ArrayList<Bin> arrayList2 = new ArrayList<Bin>();
            for (int i = 0; i < distributionArray[0].nrOfBins; ++i) {
                binArray[i] = new Bin(distributionArray, new int[]{i});
                if (binArray[i].getSamples().size() <= 0) continue;
                arrayList2.add(binArray[i]);
            }
            grid = new Grid1(binArray);
        } else if (distributionArray.length == 2) {
            int n;
            Bin[][] binArray = new Bin[distributionArray[0].nrOfBins][distributionArray[1].nrOfBins];
            for (int i = 0; i < distributionArray[0].nrOfBins; ++i) {
                for (int j = 0; j < distributionArray[1].nrOfBins; ++j) {
                    binArray[i][j] = new Bin(distributionArray, new int[]{i, j});
                }
            }
            for (MtSample mtSample : arrayList) {
                n = distributionArray[0].getBinIdx(mtSample.getValue(0));
                int n2 = distributionArray[1].getBinIdx(mtSample.getValue(1));
                binArray[n][n2].addSample(mtSample);
            }
            ArrayList arrayList3 = new ArrayList();
            for (int i = 0; i < distributionArray[0].nrOfBins; ++i) {
                for (n = 0; n < distributionArray[1].nrOfBins; ++n) {
                    if (binArray[i][n].getSamples().size() <= 0) continue;
                    arrayList3.add(binArray[i][n]);
                }
            }
            grid = new Grid2(binArray);
        } else if (distributionArray.length == 3) {
            int n;
            int n3;
            Bin[][][] binArray = new Bin[distributionArray[0].nrOfBins][distributionArray[1].nrOfBins][distributionArray[2].nrOfBins];
            for (int i = 0; i < distributionArray[0].nrOfBins; ++i) {
                for (int j = 0; j < distributionArray[1].nrOfBins; ++j) {
                    for (n3 = 0; n3 < distributionArray[2].nrOfBins; ++n3) {
                        binArray[i][j][n3] = new Bin(distributionArray, new int[]{i, j, n3});
                    }
                }
            }
            for (MtSample mtSample : arrayList) {
                n3 = distributionArray[0].getBinIdx(mtSample.getValue(0));
                n = distributionArray[1].getBinIdx(mtSample.getValue(1));
                int n4 = distributionArray[2].getBinIdx(mtSample.getValue(2));
                binArray[n3][n][n4].addSample(mtSample);
            }
            ArrayList arrayList4 = new ArrayList();
            for (int i = 0; i < distributionArray[0].nrOfBins; ++i) {
                for (n3 = 0; n3 < distributionArray[1].nrOfBins; ++n3) {
                    for (n = 0; n < distributionArray[2].nrOfBins; ++n) {
                        if (binArray[i][n3][n].getSamples().size() <= 0) continue;
                        arrayList4.add(binArray[i][n3][n]);
                    }
                }
            }
            grid = new Grid3(binArray);
        }
        return grid;
    }

    private Grid arrangeIntoGrid(int n, boolean bl, ArrayList<MtSample> arrayList) {
        Collections.sort(arrayList, new SampleComparator(0));
        Distribution[] distributionArray = new Distribution[arrayList.get(0).getNrOfValues()];
        if (bl) {
            for (int i = 0; i < distributionArray.length; ++i) {
                Collections.sort(arrayList, new SampleComparator(i));
                distributionArray[i] = new Distribution(arrayList, i, n);
            }
        } else {
            distributionArray[0] = new Distribution(arrayList, 0, 25);
            float f = distributionArray[0].getBinInterval();
            for (int i = 1; i < distributionArray.length; ++i) {
                Collections.sort(arrayList, new SampleComparator(i));
                distributionArray[i] = new Distribution(arrayList, i, f);
            }
        }
        return this.arrangeIntoGrid(distributionArray, arrayList);
    }

    private void calcAllDistances(ArrayList<MtSample> arrayList) {
        int n;
        int n2 = arrayList.size();
        this.distanceList = new float[n2][];
        for (n = 0; n < n2; ++n) {
            arrayList.get(n).setDistIdx(n);
        }
        for (n = 0; n < n2; ++n) {
            arrayList.get(n).setDistIdx(n);
            float[] fArray = new float[n2 - (n + 1)];
            for (int i = n + 1; i < n2; ++i) {
                fArray[i - (n + 1)] = this.calcDistance(arrayList.get(n), arrayList.get(i));
            }
            this.distanceList[n] = fArray;
        }
    }

    private void calcAllDistances(Grid grid) {
        this.calcAllDistances(grid.getSamples());
    }

    private float calcDistance(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        if (fArray.length != fArray2.length) {
            return -99.0f;
        }
        for (int i = 0; i < fArray.length; ++i) {
            f = (float)((double)f + Math.pow(fArray[i] - fArray2[i], 2.0));
        }
        return (float)Math.sqrt(f);
    }

    private float calcDistance(MtSample mtSample, MtSample mtSample2) {
        return this.calcDistance(mtSample.getValues(), mtSample2.getValues());
    }

    private Grid createDesignGrid(Grid grid, int n) {
        Grid grid2 = grid.clone();
        while (grid2.getNrOfSamples() < n) {
            grid2.addSample(grid.removeRandomSample());
        }
        grid2.createNonEmptyBinList();
        return grid2;
    }

    private ArrayList<MtSample> createSampleObjects() {
        ArrayList<MtSample> arrayList = new ArrayList<MtSample>();
        this.columns = Math.min(3, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            float[] fArray = new float[this.columns];
            for (int j = 0; j < this.columns; ++j) {
                fArray[j] = (float)this.scores.get(i, j);
            }
            arrayList.add(new MtSample(i, fArray));
        }
        return arrayList;
    }

    private double getDmin(int n, Grid grid, boolean bl) {
        MtSample mtSample = grid.getSample(n);
        return grid.getDmin(mtSample, bl, mtSample, this);
    }

    private double getDmin(int n, int n2, Grid grid, Grid grid2, boolean bl) {
        MtSample mtSample = grid.getSample(n);
        MtSample mtSample2 = grid2.getSample(n2);
        return grid.getDmin(mtSample2, bl, mtSample, this);
    }

    private boolean isConverging(ArrayList<int[]> arrayList) {
        return arrayList.size() < 3 || arrayList.get(0)[0] != arrayList.get(2)[0] || arrayList.get(0)[1] != arrayList.get(2)[1];
    }

    private void runMarengoTodeschini(Grid[] gridArray, int n, int n2, int n3, boolean bl) {
        int n4 = gridArray[n2].getNrOfSamples();
        int n5 = gridArray[n].getNrOfSamples();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray = new int[gridArray.length];
        int[] nArray2 = new int[gridArray.length];
        Grid[] gridArray2 = new Grid[2];
        boolean bl2 = !bl;
        long l = 0L;
        float f = 0.0f;
        float f2 = 0.0f;
        while (f > 1.0f || l == 0L) {
            f = 0.0f;
            if (l > 0L && this.isConverging(arrayList)) {
                this.substituteBest(gridArray[n], gridArray[n2], arrayList.get(0));
            }
            for (int i = 0; i < n5; ++i) {
                float f3 = (float)this.getDmin(i, gridArray[n], bl2);
                float f4 = 0.0f;
                for (int j = 0; j < n4; ++j) {
                    float f5 = (float)this.getDmin(i, j, gridArray[n], gridArray[n2], bl2);
                    if (!(f5 > f4)) continue;
                    f4 = f5;
                    nArray = new int[]{i, j};
                }
                float f6 = f4 / f3;
                if (!(f6 > f)) continue;
                f = f6;
                nArray2 = (int[])nArray.clone();
            }
            arrayList.add(0, (int[])nArray2.clone());
            if (f < f2) {
                f2 = f;
                gridArray2[n] = gridArray[n].clone();
                gridArray2[n2] = gridArray[n2].clone();
            }
            System.out.println(++l + " " + f);
            if (l <= (long)n3) continue;
        }
        gridArray = gridArray2;
    }

    private void substituteBest(Grid grid, Grid grid2, int[] nArray) {
        MtSample mtSample = grid.removeSample(nArray[0]);
        MtSample mtSample2 = grid2.removeSample(nArray[1]);
        grid.addSample(mtSample2);
        grid2.addSample(mtSample);
    }

    public static class SampleComparator
    implements Comparator<MtSample> {
        private int sortIdx;

        public SampleComparator(int n) {
            this.sortIdx = n;
        }

        @Override
        public int compare(MtSample mtSample, MtSample mtSample2) {
            if (this.getValue(mtSample) < this.getValue(mtSample2)) {
                return -1;
            }
            if (this.getValue(mtSample) > this.getValue(mtSample2)) {
                return 1;
            }
            return 0;
        }

        public void setSortItem(short s) {
            this.sortIdx = s;
        }

        private double getValue(MtSample mtSample) {
            return mtSample.getValue(this.sortIdx);
        }
    }
}

