/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.util.List;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.RawFrame;

public class AverageFrame
extends FloatFrame {
    public AverageFrame(List<RawFrame> list) {
        super(list.get(0).getRows(), list.get(0).getColumns(), list.get(0).getBandNames());
        for (RawFrame rawFrame : list) {
            for (int i = 0; i < rawFrame.columns.value; ++i) {
                for (int j = 0; j < rawFrame.rows.value; ++j) {
                    this.setFrameValue(j, i, this.getFrameValue(j, i) + rawFrame.getFrameValue(j, i));
                }
            }
        }
        for (int i = 0; i < this.columns.value; ++i) {
            for (int j = 0; j < this.rows.value; ++j) {
                this.setFrameValue(j, i, this.getFrameValue(j, i) / (float)list.size());
            }
        }
    }

    public static float[] computeAverageSpectrum(List<RawFrame> list) {
        int n;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("frames must not be null or empty");
        }
        RawFrame rawFrame = list.get(0);
        int n2 = rawFrame.rows.value;
        int n3 = rawFrame.columns.value;
        double[] dArray = new double[n2];
        for (RawFrame object2 : list) {
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    int n4 = n;
                    dArray[n4] = dArray[n4] + (double)object2.getFrameValue(n, i);
                }
            }
        }
        int n5 = list.size() * n3;
        float[] fArray = new float[n2];
        for (n = 0; n < n2; ++n) {
            fArray[n] = (float)(dArray[n] / (double)n5);
        }
        return fArray;
    }
}

