/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class BreezeColor
extends Color {
    private static final Map<Color, String> colorNameMap = new HashMap<Color, String>();
    public static final Color LightBlue = new Color(173, 216, 230);
    public static final Color SkyBlue = new Color(135, 206, 235);
    public static final Color DeepSkyBlue = new Color(0, 191, 255);
    public static final Color SoftGreen = new Color(144, 238, 144);
    public static final Color Coral = new Color(255, 127, 80);
    public static final Color PaleYellow = new Color(255, 255, 204);
    public static final Color SoftPink = new Color(255, 182, 193);
    public static final Color CoolGray = new Color(128, 128, 128);
    public static final Color WarmOrange = new Color(255, 165, 0);

    public BreezeColor(Color color, int n) {
        super(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static int toRGB(double d) {
        return Math.max(0, Math.min(255, (int)Math.round(d * 255.0)));
    }

    public static int toIndex(double d, int n) {
        return Math.max(0, Math.min(n, (int)Math.round(d * (double)n)));
    }

    public static String colorToName(Color color) {
        return colorNameMap.getOrDefault(color, "Unknown");
    }

    public static String colorToHex(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    static {
        colorNameMap.put(LightBlue, "LightBlue");
        colorNameMap.put(SkyBlue, "SkyBlue");
        colorNameMap.put(DeepSkyBlue, "DeepSkyBlue");
        colorNameMap.put(SoftGreen, "SoftGreen");
        colorNameMap.put(Coral, "Coral");
        colorNameMap.put(PaleYellow, "PaleYellow");
        colorNameMap.put(SoftPink, "SoftPink");
        colorNameMap.put(CoolGray, "CoolGray");
        colorNameMap.put(WarmOrange, "WarmOrange");
        colorNameMap.put(Color.BLACK, "Black");
        colorNameMap.put(Color.BLUE, "Blue");
        colorNameMap.put(Color.CYAN, "Cyan");
        colorNameMap.put(Color.DARK_GRAY, "DarkGray");
        colorNameMap.put(Color.GRAY, "Gray");
        colorNameMap.put(Color.GREEN, "Green");
        colorNameMap.put(Color.LIGHT_GRAY, "LightGray");
        colorNameMap.put(Color.MAGENTA, "Magenta");
        colorNameMap.put(Color.ORANGE, "Orange");
        colorNameMap.put(Color.PINK, "Pink");
        colorNameMap.put(Color.RED, "Red");
        colorNameMap.put(Color.WHITE, "White");
        colorNameMap.put(Color.YELLOW, "Yellow");
    }
}

