/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.common.util.BreezeColor;

public class BreezeColorTest {
    @Test
    public void testToRGB_Basic() {
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(0.0), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(0.5), (Matcher)Matchers.is((Object)128));
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(1.0), (Matcher)Matchers.is((Object)255));
    }

    @Test
    public void testToRGB_Clamping() {
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(-1.0), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(2.0), (Matcher)Matchers.is((Object)255));
    }

    @Test
    public void testToRGB_RoundingSpecific() {
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(0.9611764705882353), (Matcher)Matchers.is((Object)245));
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(0.9627450980392157), (Matcher)Matchers.is((Object)246));
        MatcherAssert.assertThat((Object)BreezeColor.toRGB(0.9603921568627451), (Matcher)Matchers.is((Object)245));
    }

    @Test
    public void testToIndex_Basic() {
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(0.0, 10), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(0.5, 10), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(1.0, 10), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testToIndex_Clamping() {
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(-0.2, 10), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(1.4, 10), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testToIndex_RoundingSpecific() {
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(0.9611764705882353, 255), (Matcher)Matchers.is((Object)245));
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(0.9627450980392157, 255), (Matcher)Matchers.is((Object)246));
        MatcherAssert.assertThat((Object)BreezeColor.toIndex(0.9603921568627451, 255), (Matcher)Matchers.is((Object)245));
    }
}

