/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.util.TrustAllCertificates;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.FileTools;
import se.prediktera.map.common.update.UpdateHelper;

public class FileHelper
extends FileTools {
    public static final int BUFFER_SIZE = 0xA00000;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(BreezeProgress breezeProgress, File file, File file2) {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);
             FileChannel fileChannel = fileInputStream.getChannel();
             FileChannel fileChannel2 = fileOutputStream.getChannel();){
            long l;
            long l2 = fileChannel.size();
            breezeProgress.setMaximumAndReset((int)(l2 / 0xA00000L));
            for (long i = 0L; i < l2 && !breezeProgress.isAborted(); i += l) {
                l = Math.min(0xA00000L, l2 - i);
                fileChannel2.transferFrom(fileChannel, i, l);
                breezeProgress.incStep();
            }
        }
        finally {
            if (breezeProgress.isAborted()) {
                FileUtils.deleteQuietly((File)file2);
            }
        }
    }

    public static boolean containsWorkflowConstants(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        for (FileConstant fileConstant : FileConstant.values()) {
            String string2 = fileConstant.getConstant();
            if (!StringHelper.contains((CharSequence)string2, (CharSequence)string)) continue;
            return true;
        }
        return false;
    }

    public static void copyFolder(BreezeProgress breezeProgress, File file, File file2) {
        FileHelper.copyFolder(breezeProgress, file, file2, false);
    }

    public static void copyFolder(BreezeProgress breezeProgress, File file, File file2, boolean bl) {
        List<File> list = FileHelper.getFiles(file, bl);
        FileHelper.copyFiles(breezeProgress, list, file2, file);
    }

    public static boolean isDirectoryEmpty(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            return stringArray == null || stringArray.length == 0;
        }
        return false;
    }

    public static List<File> getFiles(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        FileHelper.addFiles(arrayList, file, bl);
        return arrayList;
    }

    private static void addFiles(List<File> list, File file, boolean bl) {
        for (File file2 : Optional.ofNullable(file.listFiles()).orElse(new File[0])) {
            if (file2.isFile()) {
                list.add(file2);
                continue;
            }
            if (!bl || !file2.isDirectory()) continue;
            FileHelper.addFiles(list, file2, bl);
        }
    }

    public static List<RawFile> getRawFiles(File file) {
        ArrayList<RawFile> arrayList = new ArrayList<RawFile>();
        for (File file2 : FileHelper.getFiles(file, false)) {
            if (!FileHelper.getFileExtension(file2).equalsIgnoreCase("raw")) continue;
            arrayList.add(new RawFileImpl(file2));
        }
        return arrayList;
    }

    public static void copyFiles(BreezeProgress breezeProgress, List<File> list, File file) {
        FileHelper.copyFiles(breezeProgress, list, file, null);
    }

    private static void copyFiles(BreezeProgress breezeProgress, List<File> list, File file, File file2) {
        boolean bl = file.mkdirs();
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = breezeProgress.setGroupMaximumAndReset(list.size());
        for (File file3 : list) {
            if (file3.isFile()) {
                File file4;
                if (file2 != null) {
                    file4 = file.toPath().resolve(file2.toPath().relativize(file3.toPath())).toFile();
                    file4.getParentFile().mkdirs();
                } else {
                    file4 = new File(file, file3.getName());
                }
                FileHelper.copyFile(breezeProgress, file3, file4);
                arrayList.add(file4);
            }
            breezeProgress.incStepGroup(n);
        }
        if (breezeProgress.isAborted()) {
            for (File file3 : arrayList) {
                FileUtils.deleteQuietly((File)file3);
            }
            if (bl) {
                file.delete();
            }
        }
    }

    public static void moveFileToFolder(RawFile rawFile, File file) {
        FileHelper.moveFileToFolder(rawFile.file(), file);
        FileHelper.moveFileToFolder(rawFile.header().file(), file);
    }

    public static void moveFileToFolder(File file, File file2) {
        file2.mkdirs();
        FileHelper.moveFile(file, new File(file2, file.getName()));
    }

    public static void moveFiles(File file, File file2) {
        try {
            if (file2.isDirectory() && file2.exists()) {
                FileUtils.deleteDirectory((File)file2);
            }
            FileHelper.moveFile(file, file2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void moveFile(File file, File file2) {
        try {
            Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new RuntimeException("Cannot move file '" + file.getName() + "': currently opened by another application", accessDeniedException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to move file '" + file.getName() + "'", iOException);
        }
    }

    public static void moveReference(File file, File file2) {
        FileHelper.moveFile(file, file2);
        FileHelper.moveFile(RawHeader.findHeaderFileByRaw(file), RawHeader.findHeaderFileByRaw(file2));
    }

    public static int getFileChunkSize(File file) {
        return (int)(file.length() / 0xA00000L);
    }

    public static int getFolderChunkSize(File file) {
        return FileHelper.getFolderChunkSize(FileHelper.getFiles(file, false));
    }

    public static int getFolderChunkSize(List<File> list) {
        int n = 0;
        for (File file : list) {
            n += FileHelper.getFileChunkSize(file);
        }
        return n;
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).toLowerCase();
    }

    public static String getFileName(File file) {
        if (file != null) {
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n == -1) {
                return string;
            }
            return string.substring(0, n);
        }
        return "";
    }

    public static String sanitizeFileSystemName(String string) {
        return string.replaceAll("[/\\\\:*?\"<>|]", "_").replaceAll("[\\s.]+$", "");
    }

    public static String createValidFolderName(String string) {
        if (FileHelper.isValidName(string)) {
            return string;
        }
        return string.trim().replaceAll("[^a-zA-Z0-9 \\-_]", "_");
    }

    public static String createValidFilename(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(".\\/:*?\"<>|".indexOf(c) == -1 ? c : (char)'_');
        }
        if (stringBuilder.length() > 255) {
            stringBuilder.setLength(255);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidName(String string) {
        try {
            FileHelper.checkValidNameOrThrow(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void checkValidNameOrThrow(String string) {
        Paths.get(string, new String[0]);
        if (string.contains("/") || string.contains("\\") || string.contains(";")) {
            throw new InvalidPathException(string, "Path cannot contain /, \\ or ;");
        }
    }

    public static void openExplorerOnPath(Object object) {
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            FileHelper.openExplorerOnPath(entry.getFolder(), true);
        } else if (object instanceof BasicWorkflow) {
            BasicWorkflow basicWorkflow = (BasicWorkflow)object;
            FileHelper.openExplorerOnPath(basicWorkflow.getFolder(), true);
        }
    }

    public static void openExplorerOnPath(File file) {
        FileHelper.openExplorerOnPath(file, true);
    }

    public static void openExplorerOnPath(File file, boolean bl) {
        block3: {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Throwable throwable) {
                    Logg.error((String)"Cannot browse file directory", (Throwable)throwable);
                    if (!bl) break block3;
                    throw new ErrorHandler.InformationMessageException("Cannot open file path in Explorer: " + file.getAbsolutePath() + "\n\nPlease open the folder manually");
                }
            }
        }
    }

    public static File createTempFileInWorkspace(String string) {
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        File file = workspace.getTempPath();
        file.mkdirs();
        return File.createTempFile("runtime", "." + string, file);
    }

    public static File createTempFolderInWorkspace() {
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        File file = workspace.getTempPath();
        file.mkdirs();
        File file2 = new File(file, "runtime_" + System.currentTimeMillis());
        if (!file2.mkdir()) {
            throw new RuntimeException("Could not create temp directory: " + String.valueOf(file2));
        }
        return file2;
    }

    public static File getTempFileWithoutCreation(String string) {
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        File file = workspace.getTempPath();
        file.mkdirs();
        long l = new Random().nextLong();
        return new File(file, String.format("runtime%d.%s", l, string));
    }

    public static boolean mkdirs(File file) {
        return file.getParentFile().mkdirs();
    }

    public static Date getCreationDate(File file) {
        if (file != null) {
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                FileTime fileTime = basicFileAttributes.creationTime();
                return new Date(fileTime.toMillis());
            }
            catch (Exception exception) {
                return new Date(file.lastModified());
            }
        }
        return new Date();
    }

    public static File getFileUsingConstants(Workflow workflow, String string) {
        if (string != null && !string.isEmpty()) {
            for (FileConstant fileConstant : FileConstant.values()) {
                String string2 = fileConstant.getConstant();
                if (!string.contains(string2)) continue;
                string = string.replace(string2, FileHelper.getPath(workflow, fileConstant));
            }
            return new File(string);
        }
        return null;
    }

    private static String getPath(Workflow workflow, FileConstant fileConstant) {
        if (fileConstant.equals((Object)FileConstant.Workflow) && workflow != null) {
            return workflow.getFolder().getAbsolutePath();
        }
        return fileConstant.getPath().getAbsolutePath();
    }

    public static File getRawFile(File file) {
        if (file.isDirectory()) {
            File file2 = new File(file, "measurement.raw");
            if (file2.exists()) {
                return file2;
            }
            return new File(file, file.getName() + ".raw");
        }
        return file;
    }

    public static File getFirstEnumerateFolder(File file) {
        int n = 1;
        File file2 = file;
        while (file2.exists()) {
            file2 = new File(file2.getParentFile(), file.getName() + " (" + n++ + ")");
        }
        return file2;
    }

    public static File copyToTempFile(File file, String string) throws IOException {
        File file2 = File.createTempFile(string, file.getName());
        FileUtils.copyFile((File)file, (File)file2);
        return file2;
    }

    public static File copyToTempFile(File file) throws IOException {
        return FileHelper.copyToTempFile(file, "temp");
    }

    public static List<File> listFiles(File file2, String string) {
        return Arrays.asList(Optional.ofNullable(file2.listFiles((file, string2) -> string2.toLowerCase().endsWith(string))).orElse(new File[0]));
    }

    public static Path getJarPath() {
        try {
            URI uRI = FileHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path path = Path.of(uRI).toAbsolutePath();
            return Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("Unable to resolve application folder", uRISyntaxException);
        }
    }

    public static File resolveBreezeLocations(String ... stringArray) {
        Path path = FileHelper.getJarPath();
        if (path == null || stringArray == null) {
            return null;
        }
        Path path2 = path;
        for (String string : stringArray) {
            path2 = path2.resolve(string);
        }
        return path2.toFile();
    }

    public static String updateFilePath(String string, String string2, String string3) {
        if (string != null && string.startsWith(string2)) {
            return string.replaceFirst(Pattern.quote(string2), Matcher.quoteReplacement(string3));
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Boolean> download(BreezeProgress breezeProgress, URL uRL, File file, int n) {
        breezeProgress.setMaximumAndReset(n);
        TrustAllCertificates.disableSSLVerification();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n2;
            byte[] byArray = new byte[4096];
            while (-1 != (n2 = bufferedInputStream.read(byArray))) {
                if (breezeProgress.isAborted()) {
                    Optional<Boolean> optional = Optional.of(false);
                    return optional;
                }
                fileOutputStream.write(byArray, 0, n2);
                breezeProgress.incStep(n2);
            }
            return Optional.of(true);
        }
        catch (IOException iOException) {
            Logg.warn((String)"Error downloading", (Object[])new Object[]{iOException});
            return Optional.empty();
        }
    }

    public static int countFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            return fileArray.length;
        }
        return 0;
    }

    public static int countFilesWithData(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.length() <= 0L) continue;
                ++n;
            }
        }
        return n;
    }

    public static int countSubfoldersWithFile(File file, String string) {
        int n = 0;
        File[] fileArray = file.listFiles(File::isDirectory);
        if (fileArray != null) {
            block0: for (File file2 : fileArray) {
                File[] fileArray2 = file2.listFiles();
                if (fileArray2 == null) continue;
                for (File file3 : fileArray2) {
                    if (!file3.isFile() || !file3.getName().equals(string)) continue;
                    ++n;
                    continue block0;
                }
            }
        }
        return n;
    }

    public static void copyFileIfNotSame(File file, File file2) throws IOException {
        if (FileHelper.areSameFile(file, file2)) {
            return;
        }
        FileUtils.copyFile((File)file, (File)file2);
    }

    public static boolean areSameFile(File file, File file2) throws IOException {
        return file.getCanonicalPath().equals(file2.getCanonicalPath());
    }

    public static String getAbsolutePathOrEmpty(File file) {
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    public static File newNonExistingFile() {
        return new File(""){

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    public static boolean exists(RawFile rawFile) {
        return rawFile != null && FileHelper.exists(rawFile.file());
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean notExists(File file) {
        return !FileHelper.exists(file);
    }

    public static boolean contains(Path path, String string) throws IOException {
        List<String> list = Files.readAllLines(path);
        for (String string2 : list) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static BasicFileAttributes getFileAttributes(File file) {
        if (FileHelper.exists(file)) {
            try {
                return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        File file = new File("F:\\Study_2019_10_04.7z_tmp");
        file.delete();
        FileHelper.copyFile(new BreezeProgressImpl(), new File("F:\\Study_2019_10_04.7z"), file);
    }

    public static String getRawSize(Measurement measurement) {
        RawFile rawFile = measurement.rawFile();
        if (rawFile != null) {
            long l = rawFile.file().length();
            return UpdateHelper.formatSize((long)l);
        }
        return "empty";
    }

    public static List<Path> listRawAndImgFiles(List<File> list) {
        if (list == null || list.isEmpty()) {
            return List.of();
        }
        Set set = list.stream().filter(Objects::nonNull).map(File::toPath).map(Path::toAbsolutePath).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Path path2 : set) {
            if (!Files.isDirectory(path2, new LinkOption[0])) continue;
            try {
                Stream<Path> stream = Files.list(path2);
                try {
                    stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> {
                        String string = path.getFileName().toString().toLowerCase(Locale.ROOT);
                        return string.endsWith(".raw") || string.endsWith(".img");
                    }).forEach(arrayList::add);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return arrayList;
    }

    private static enum FileConstant {
        Workspace(""),
        Record("Record"),
        Play("Play"),
        Workflow("");

        private final String path;

        private FileConstant(String string2) {
            this.path = string2;
        }

        public String getConstant() {
            return "$" + this.toString().toLowerCase();
        }

        public File getPath() {
            return new File(WorkspaceManager.getInstance().getCurrentOrDefaultWorkspacePath(), this.path);
        }
    }
}

