/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public final class InternetProbe {
    public static final URI ENDPOINT = URI.create("https://license.prediktera.se/api/log/iprequest");

    public static Result checkOnline() {
        return InternetProbe.checkOnline(Duration.ofSeconds(3L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result checkOnline(Duration duration) {
        try (HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(duration).build();){
            HttpRequest httpRequest = HttpRequest.newBuilder(ENDPOINT).timeout(duration).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
            long l = System.nanoTime();
            HttpResponse<Void> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
            Duration duration2 = Duration.ofNanos(System.nanoTime() - l);
            if (httpResponse.statusCode() >= 200 && httpResponse.statusCode() < 400) {
                Result result = new Result(true, httpResponse.statusCode(), duration2, null);
                return result;
            }
            if (httpResponse.statusCode() == 405 || httpResponse.statusCode() == 501) {
                HttpRequest httpRequest2 = HttpRequest.newBuilder(ENDPOINT).timeout(duration).GET().build();
                long l2 = System.nanoTime();
                HttpResponse<Void> httpResponse2 = httpClient.send(httpRequest2, HttpResponse.BodyHandlers.discarding());
                Duration duration3 = Duration.ofNanos(System.nanoTime() - l2);
                boolean bl = httpResponse2.statusCode() >= 200 && httpResponse2.statusCode() < 400;
                Result result = new Result(bl, httpResponse2.statusCode(), duration3, bl ? null : "GET probe failed");
                return result;
            }
            Result result = new Result(false, httpResponse.statusCode(), duration2, "HEAD probe failed");
            return result;
        }
        catch (Exception exception) {
            return new Result(false, 0, Duration.ZERO, exception.getClass().getSimpleName() + ": " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        Result result = InternetProbe.checkOnline();
        String string = result.online() ? "Online, status=" + result.statusCode() + ", rtt=" + result.rtt().toMillis() + " ms" : "Offline, status=" + result.statusCode() + ", error=" + result.error();
        System.out.println(string);
    }

    public record Result(boolean online, int statusCode, Duration rtt, String error) {
        public boolean offline() {
            return !this.online();
        }
    }
}

