/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.util.Objects;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;

public class MinMax {
    public static final MinMax Percent = new MinMax(0.0f, 1.0f);
    public static final MinMax Percent100 = new MinMax(0.0f, 100.0f);
    private Float min;
    private Float max;

    public MinMax() {
    }

    public MinMax(String string) {
        if (!StringHelper.contains((CharSequence)string, (CharSequence)";")) {
            return;
        }
        String[] stringArray = string.split(";");
        this.min = Float.valueOf(RtDataFormat.toNumberFloat(stringArray[0]));
        this.max = Float.valueOf(RtDataFormat.toNumberFloat(stringArray[1]));
    }

    public MinMax(float f, float f2) {
        this.min = Float.valueOf(f);
        this.max = Float.valueOf(f2);
    }

    public MinMax(MinMax minMax) {
        this.min = minMax.min();
        this.max = minMax.max();
    }

    public void add(float f) {
        if (this.min == null) {
            this.min = this.max = Float.valueOf(f);
        } else {
            this.min = Float.valueOf(Math.min(this.min.floatValue(), f));
            this.max = Float.valueOf(Math.max(this.max.floatValue(), f));
        }
    }

    public void add(MinMax minMax) {
        if (this.min == null) {
            this.min = minMax.min;
            this.max = minMax.max;
        } else {
            this.min = Float.valueOf(Math.min(this.min.floatValue(), minMax.min.floatValue()));
            this.max = Float.valueOf(Math.max(this.max.floatValue(), minMax.max.floatValue()));
        }
    }

    public Float normalise(float f) {
        if (this.min != null) {
            return Float.valueOf((f - this.min.floatValue()) / (this.max.floatValue() - this.min.floatValue()));
        }
        return null;
    }

    public Float min() {
        return this.min;
    }

    public Float max() {
        return this.max;
    }

    public Float abs() {
        return Float.valueOf(this.max.floatValue() - this.min.floatValue());
    }

    public MinMax checkEmpty() {
        if (this.min == null) {
            this.min = Float.valueOf(0.0f);
        }
        if (this.max == null) {
            this.max = Float.valueOf(0.0f);
        }
        return this;
    }

    public MinMax clone() {
        return new MinMax(this);
    }

    public String formatRange() {
        return RtDataFormat.toString(this.min.floatValue()) + ";" + RtDataFormat.toString(this.max.floatValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof MinMax)) {
            return false;
        }
        MinMax minMax = (MinMax)object;
        return Objects.equals(this.min, minMax.min) && Objects.equals(this.max, minMax.max);
    }

    public String toString() {
        return String.format("Min: %.1f, max: %.1f", this.min, this.max);
    }
}

