/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public class PythonHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static List<String> getInstalledPythonVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (PythonHelper.hasBreezeVenv()) {
            arrayList.add("Breeze python");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Process process;
            block16: {
                ProcessBuilder processBuilder = new ProcessBuilder("py", "--list");
                processBuilder.redirectErrorStream(true);
                process = null;
                try {
                    process = processBuilder.start();
                }
                catch (IOException iOException) {
                    Logg.warn((String)"Failed to initiate py command", (Object[])new Object[]{iOException});
                    if (!iOException.getMessage().startsWith("Cannot run program \"py\"")) break block16;
                    return arrayList;
                }
            }
            if (process == null) {
                return arrayList;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            try {
                Object object;
                block17: {
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            String string2 = PythonHelper.getSwitchFromListLine(string);
                            if (!(string2 instanceof String)) continue;
                            object = string2;
                            arrayList.add((String)object);
                        }
                        object = arrayList;
                        if (Collections.singletonList(bufferedReader).get(0) == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(bufferedReader).get(0) != null) {
                            bufferedReader.close();
                        }
                        throw throwable;
                    }
                    bufferedReader.close();
                }
                return object;
            }
            finally {
                if (Collections.singletonList(inputStreamReader).get(0) != null) {
                    inputStreamReader.close();
                }
            }
        }
        arrayList.add("python");
        return arrayList;
    }

    public static String getSwitchFromListLine(String string) {
        String string2 = StringUtils.trim((String)string);
        if (StringHelper.startsWith((CharSequence)string2, (CharSequence)"-")) {
            if (StringUtils.containsWhitespace((CharSequence)string2)) {
                return string2.substring(1, StringUtils.indexOfAny((CharSequence)string2, (char[])new char[]{'\t', ' '}));
            }
            return string2.substring(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePythonScriptWithParams(BreezeProgressManager breezeProgressManager, String string, String string2, String string3, File ... fileArray) {
        breezeProgressManager.setConsoleVisible(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = StringUtils.isNotEmpty((CharSequence)string3) && !string3.equals("Breeze python");
        arrayList.add(PythonHelper.getPythonRunName(string, bl));
        if (bl && StringUtils.isEmpty((CharSequence)string)) {
            arrayList.add("-" + string3.replaceFirst("^-", ""));
            breezeProgressManager.addConsoleText("Using interpreter: " + string3);
        }
        arrayList.add(string2);
        for (File object2 : fileArray) {
            arrayList.add(object2.getAbsolutePath());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.redirectErrorStream(true);
        breezeProgressManager.addConsoleText("Loading python environment..");
        Logg.debug((String)("Executing python command: " + String.join((CharSequence)" ", arrayList)), (Object[])new Object[0]);
        Process process = processBuilder.start();
        StringBuilder stringBuilder = new StringBuilder();
        Thread thread = ThreadUtil.runAfterConditionIsMet(breezeProgressManager::isAborted, process::destroy, new Time.MilliSeconds(100L));
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string4;
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string4);
                breezeProgressManager.addConsoleText(string4);
            }
        }
        finally {
            thread.interrupt();
            thread.join(1000L);
        }
        if (!process.waitFor(5L, TimeUnit.SECONDS)) {
            throw new ErrorHandler.WarningMessageException("Process did not exit within timeout: " + String.valueOf(stringBuilder));
        }
        if (process.exitValue() != 0 && !breezeProgressManager.isAborted()) {
            throw new ErrorHandler.WarningMessageException("Script exited with non-zero: " + String.valueOf(stringBuilder));
        }
    }

    public static float[] executePythonScriptWithParamsInFile(String string, String string2, File file) {
        ProcessBuilder processBuilder = new ProcessBuilder(PythonHelper.getPythonRunName(string, false), string2, file.getAbsolutePath(), "");
        Process process = processBuilder.start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string3 = bufferedReader.readLine();
        if (string3 != null) {
            if (string3.startsWith("Error:")) {
                throw new RuntimeException(string3);
            }
            String[] stringArray = string3.substring(1, string3.length() - 1).replace(" ", "").split(",");
            if (stringArray.length > 0) {
                float[] fArray = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    fArray[i] = RtDataFormat.toNumberFloat(stringArray[i]);
                }
                return fArray;
            }
        }
        throw new IllegalArgumentException("No result received from python script.");
    }

    private static String getPythonRunName(String string, boolean bl) {
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            return string;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            if (PythonHelper.hasBreezeVenv() && !bl) {
                return PythonHelper.getBreezeVenvPath().getAbsolutePath();
            }
            return "py";
        }
        return "python";
    }

    public static float[] executePythonScript(String string, String string2, float[] fArray) {
        File file = PythonHelper.createTempFile();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            for (int i = 0; i < fArray.length; ++i) {
                if (i > 0) {
                    bufferedWriter.write(";");
                }
                bufferedWriter.write("" + fArray[i]);
            }
        }
        return PythonHelper.executePythonScriptWithParamsInFile(string, string2, file);
    }

    private static File getBreezeVenvPath() {
        Object object = "python";
        String string = "bin";
        if (SystemUtils.IS_OS_WINDOWS) {
            object = (String)object + ".exe";
            string = "Scripts";
        }
        return Paths.get(SettingsManager.getBreezeInstallFolder(), new String[]{"python", string, object}).toFile();
    }

    private static boolean hasBreezeVenv() {
        return PythonHelper.getBreezeVenvPath().exists();
    }

    public static float[] executePythonScript(String string, String string2, List<RtFrame> list, RtSpatialObject rtSpatialObject) {
        File file = PythonHelper.createTempFile();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            if (rtSpatialObject != null) {
                rtSpatialObject.forEveryPixel((n, n2, n3) -> {
                    RtFrame rtFrame = (RtFrame)list.get(n2);
                    try {
                        PythonHelper.writeBands(bufferedWriter, rtFrame, n);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                });
            } else {
                for (RtFrame rtFrame : list) {
                    for (int i = 0; i < rtFrame.getColumns().value; ++i) {
                        PythonHelper.writeBands(bufferedWriter, rtFrame, i);
                    }
                }
            }
        }
        return PythonHelper.executePythonScriptWithParamsInFile(string, string2, file);
    }

    private static File createTempFile() throws IOException {
        File file = File.createTempFile("values", ".txt");
        file.deleteOnExit();
        return file;
    }

    private static void writeBands(BufferedWriter bufferedWriter, RtFrame rtFrame, int n) throws IOException {
        for (int i = 0; i < rtFrame.getRows().value; ++i) {
            if (i > 0) {
                bufferedWriter.write(";");
            }
            bufferedWriter.write("" + rtFrame.getFrameValue(i, n));
        }
        bufferedWriter.write("\n");
    }

    public static void main(String[] stringArray) {
        System.out.println(PythonHelper.getInstalledPythonVersions());
        System.out.println(PythonHelper.getBreezeVenvPath());
    }
}

