/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import se.prediktera.breeze.common.util.RtScientificFormat;

public class RtDataFormat {
    private static RtScientificFormat sciFormat = new RtScientificFormat(3, 3, true);

    public static String convertDelimiters(String string) {
        return string.replace(",", ".");
    }

    public static String toString(double d) {
        return RtDataFormat.toString(d, 6);
    }

    public static String toString(double d, int n) {
        return RtDataFormat.toString(d, n, false);
    }

    public static String toStringAll(double d) {
        return RtDataFormat.toString(d, -1, false);
    }

    public static String toString(double d, int n, boolean bl) {
        if (Double.isInfinite(d)) {
            return "Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 0) {
            return String.valueOf(d).replaceAll(",", ".");
        }
        double d2 = Math.abs(d);
        int n2 = (int)d2;
        boolean bl2 = n2 != 0;
        int n3 = RtDataFormat.exp10(d2, bl2);
        if (bl && (bl2 ? n3 > n : n + n3 < 3)) {
            return RtDataFormat.toSciString(d, n >= 6 ? n - 3 : n);
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat.applyPattern(RtDataFormat.createPattern(n3, n));
        return decimalFormat.format(d);
    }

    private static String createPattern(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (n < 0) {
            stringBuilder.append("#.");
            stringBuilder.append("#".repeat(Math.max(0, n2 - 1)));
        } else {
            int n3 = 0;
            while (n3 < n2) {
                if (n == -1) {
                    stringBuilder.append(".");
                }
                stringBuilder.append("#");
                ++n3;
                --n;
            }
        }
        return stringBuilder.toString();
    }

    private static int exp10(double d, boolean bl) {
        int n = 0;
        double d2 = 1.0;
        if (bl) {
            while (d2 < d) {
                d2 *= 10.0;
                ++n;
            }
        } else {
            d2 /= 10.0;
            while (d2 > d) {
                d2 /= 10.0;
                --n;
            }
        }
        return n;
    }

    private static String toSciString(double d, int n) {
        if (sciFormat == null || sciFormat.getSigDigits() != n) {
            sciFormat = new RtScientificFormat(n, n, true);
        }
        return sciFormat.format(d);
    }

    public static String initialLetter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean isText(String string) {
        return Double.isNaN(RtDataFormat.toNumber(string));
    }

    public static boolean isNumber(String string) {
        return !Double.isNaN(RtDataFormat.toNumber(string));
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string.trim());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int toNumberInt(String string) {
        return (int)RtDataFormat.toNumber(string);
    }

    public static int toNumberInt(String string, int n) {
        return (int)RtDataFormat.toNumber(string, n);
    }

    public static float toNumberFloat(String string) {
        if (string != null) {
            try {
                return Float.parseFloat(RtDataFormat.convertDelimiters(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Float.NaN;
    }

    public static long toNumberLong(String string) {
        if (string != null) {
            try {
                return Long.parseLong(RtDataFormat.convertDelimiters(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static double toNumber(String string) {
        return RtDataFormat.toNumber(string, Double.NaN);
    }

    public static double toNumber(String string, double d) {
        if (string != null) {
            try {
                return Double.parseDouble(RtDataFormat.convertDelimiters(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public static String toPercent(double d) {
        return RtDataFormat.toPercent(d, true);
    }

    public static String toPercent(double d, boolean bl) {
        String string = RtDataFormat.toString(d * 100.0, 4);
        if (bl) {
            return string + "%";
        }
        return string;
    }

    public static String valueOf(double d) {
        return RtDataFormat.convertDelimiters(String.valueOf(d));
    }
}

