/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.awt.Color;
import java.util.Random;

public class RtPerfectSpread {
    public static final Object[][] colormap = new Object[][]{{"red", Color.red}, {"green", Color.green}, {"blue", Color.blue}, {"yellow", Color.yellow}, {"orange", Color.orange}, {"white", Color.white}, {"black", Color.black}, {"cyan", Color.cyan}, {"darkgray", Color.darkGray}, {"gray", Color.gray}, {"lightgray", Color.lightGray}, {"magenta", Color.magenta}, {"pink", Color.pink}, {"brown", Color.decode("#A52A2A")}, {"purple", new Color(255, 0, 255)}, {"none", new Color(255, 255, 255, 0)}, {"transparent", new Color(255, 255, 255, 0)}};
    private static final String[] colors = new String[]{"#ED2024", "#3AD23A", "#0076FF", "#FE8900", "#FFA6FE", "#FFDB66", "#01FFFE", "#010067", "#95003A", "#7E2DD2", "#FF00F6", "#FFEEE8", "#774D00", "#90FB92", "#4664BE", "#D5FF00", "#FF937E", "#6A826C", "#FF029D", "#006401", "#7A4782", "#007DB5", "#85A900", "#FF0056", "#A42400", "#00AE7E", "#683D3B", "#BDC6FF", "#263400", "#BDD393", "#00B917", "#9E008E", "#001544", "#C28C9F", "#FF74A3", "#01D0FF", "#004754", "#E56FFE", "#788231", "#0E4CA1", "#91D0CB", "#BE9970", "#968AE8", "#BB8800", "#43002C", "#DEFF74", "#00FFC6", "#FFE502", "#620E00", "#008F9C", "#98FF52", "#7544B1", "#B500FF", "#00FF78", "#FF6E41", "#005F39", "#6B6882", "#5FAD4E", "#A75740", "#A5FFD2", "#FFB167", "#009BFF", "#E85EBE"};

    public static Color generateColor(int n) {
        if (n < colors.length) {
            return RtPerfectSpread.getColorFromString(colors[n]);
        }
        Random random = new Random(n);
        float f = random.nextFloat();
        float f2 = random.nextFloat();
        float f3 = random.nextFloat();
        return new Color(f, f2, f3);
    }

    public static Color getColorFromString(String string) {
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '#') {
            return Color.decode(string);
        }
        if (string.startsWith("rgba(")) {
            String[] stringArray = string.substring(5, string.length() - 1).split(",");
            return new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), (int)(Double.parseDouble(stringArray[3]) * 255.0));
        }
        for (Object[] objectArray : colormap) {
            if (!string.equalsIgnoreCase(objectArray[0].toString())) continue;
            return (Color)objectArray[1];
        }
        throw new RuntimeException("Illegal color option: " + string);
    }

    public static String generateStringColor(int n) {
        return RtPerfectSpread.getColorToString(RtPerfectSpread.generateColor(n));
    }

    public static String getColorToString(Color color) {
        if (color == null) {
            return "";
        }
        char[] cArray = new char[7];
        cArray[0] = 35;
        String string = Integer.toHexString(color.getRed());
        if (string.length() == 1) {
            cArray[1] = 48;
            cArray[2] = string.charAt(0);
        } else {
            cArray[1] = string.charAt(0);
            cArray[2] = string.charAt(1);
        }
        string = Integer.toHexString(color.getGreen());
        if (string.length() == 1) {
            cArray[3] = 48;
            cArray[4] = string.charAt(0);
        } else {
            cArray[3] = string.charAt(0);
            cArray[4] = string.charAt(1);
        }
        string = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            cArray[5] = 48;
            cArray[6] = string.charAt(0);
        } else {
            cArray[5] = string.charAt(0);
            cArray[6] = string.charAt(1);
        }
        return String.valueOf(cArray);
    }

    public static Color blendDark(Color color, double d, double d2) {
        return new Color(RtPerfectSpread.blendDark(color.getRed(), d, d2), RtPerfectSpread.blendDark(color.getGreen(), d, d2), RtPerfectSpread.blendDark(color.getBlue(), d, d2));
    }

    public static int blendDark(int n, double d, double d2) {
        double d3 = RtPerfectSpread.calcPercent(d, d2);
        return (int)((double)n * d3 + (1.0 - d3) * 0.0);
    }

    public static Color blendWhite(Color color, double d, double d2) {
        return new Color(RtPerfectSpread.blendWhite(color.getRed(), d, d2), RtPerfectSpread.blendWhite(color.getGreen(), d, d2), RtPerfectSpread.blendWhite(color.getBlue(), d, d2));
    }

    public static int blendWhite(int n, double d, double d2) {
        double d3 = RtPerfectSpread.calcPercent(d, d2);
        return (int)((double)n * d3 + (1.0 - d3) * 255.0);
    }

    private static double calcPercent(double d, double d2) {
        return d2 + (1.0 - d2) * d;
    }

    public static Color withAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }
}

