/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class RtScientificFormat
extends Format {
    private static final double k = 1.0 / Math.log(10.0);
    private int sigDigit = 5;
    private int maxWidth = 8;
    private boolean SciNote = false;

    private static double Log10(double d) {
        if (Double.compare(d, 0.0) == 0) {
            return 0.0;
        }
        return Math.log(d) * k;
    }

    public RtScientificFormat() {
    }

    public RtScientificFormat(int n, int n2, boolean bl) {
        this.setSigDigits(n);
        this.setMaxWidth(n2);
        this.setScientificNotationStyle(bl);
    }

    public String format(double d) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        double d2 = d;
        if (Double.compare(d = Math.abs(d), 0.0) == 0) {
            return "0";
        }
        double d3 = RtScientificFormat.Log10(d);
        StringBuilder stringBuilder = new StringBuilder(this.sigDigit + 3);
        int n = (int)Math.floor(d3);
        if (n > -1 && Double.compare(d % Math.pow(10.0, n + 1), 0.0) == 0) {
            ++n;
        }
        int n2 = d3 < 0.0 ? this.sigDigit - n - 1 : this.sigDigit - n;
        double d4 = Math.pow(10.0, n2) * d;
        long l = Math.round(d4);
        String string = String.valueOf(l);
        BigDecimal bigDecimal = new BigDecimal(d4);
        long l2 = bigDecimal.longValue();
        String string2 = String.valueOf(l2);
        if (string.length() > string2.length()) {
            ++n;
        }
        if (!this.SciNote) {
            if (n < 0) {
                stringBuilder.append("0.");
                stringBuilder.append("0".repeat(Math.abs(n) - 1));
                stringBuilder.append(string);
            } else {
                int n3;
                String[] stringArray = new String[n + 1];
                for (n3 = 0; n3 <= n; ++n3) {
                    stringArray[n3] = "0";
                }
                for (n3 = 0; n3 < string.length() && n3 <= n; ++n3) {
                    stringArray[n3] = string.substring(n3, n3 + 1);
                }
                for (String string3 : stringArray) {
                    stringBuilder.append(string3);
                }
                int n4 = stringBuilder.length();
                if (n4 < this.sigDigit) {
                    stringBuilder.append('.');
                    int n5 = 0;
                    while (n4 < this.sigDigit) {
                        stringBuilder.append(string.substring(stringBuilder.length() + n5, stringBuilder.length() + n5 + 1));
                        ++n5;
                        ++n4;
                    }
                }
            }
            if (stringBuilder.length() > this.maxWidth) {
                stringBuilder = new StringBuilder(string.substring(0, 1));
                stringBuilder.append('.');
                stringBuilder.append(string.substring(1, this.sigDigit));
                stringBuilder.append('E');
                stringBuilder.append(n);
            }
        } else {
            stringBuilder = new StringBuilder(string.substring(0, 1));
            stringBuilder.append('.');
            stringBuilder.append(string.substring(1, this.sigDigit));
            stringBuilder.append('E');
            stringBuilder.append(n);
        }
        if (d2 > 0.0) {
            return stringBuilder.toString();
        }
        return "-" + String.valueOf(stringBuilder);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            String string = this.format(((Number)object).doubleValue());
            return stringBuffer.append(string);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean getScientificNotationStyle() {
        return this.SciNote;
    }

    public int getSigDigits() {
        return this.sigDigit;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    public void setMaxWidth(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("maxWidth");
        }
        this.maxWidth = n;
    }

    public void setScientificNotationStyle(boolean bl) {
        this.SciNote = bl;
    }

    public void setSigDigits(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("sigDigit");
        }
        this.sigDigit = n;
    }
}

