/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.util.HashMap;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.realtime.frame.RefFrame;
import se.prediktera.breeze.common.util.AbsorbanceToReflectance;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;

public class SignalNoiseRatio {
    private static final AbsorbanceToReflectance absToRef = new AbsorbanceToReflectance();
    private final RefFrame refFrame;
    private final FloatMatrix darkMatrix;
    private final FloatMatrix whiteMatrix;
    private final RtFramePredictor.ReferenceConvertTo convertTo;
    private final MaxSignal maxSignal;
    private final boolean shouldConvert;

    public SignalNoiseRatio(Measurement measurement) {
        this.convertTo = measurement.getConvertTo();
        this.maxSignal = measurement.getMaxSignal();
        boolean bl = this.shouldConvert = !this.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.None) && measurement.hasReferences();
        if (this.shouldConvert) {
            this.refFrame = RefFrame.createRefFrameFromReferences(measurement.whiteReference(), measurement.darkReference(), 1, null, new RtFramePredictor.RefSettings(measurement.getIntegrationTime()), null, false, null);
            FloatMatrix floatMatrix = this.refFrame.minRefFrame.floatMatrix[0];
            this.darkMatrix = floatMatrix.rowSums().divi((float)floatMatrix.columns);
            FloatMatrix floatMatrix2 = this.refFrame.oneDivAbsRefFrame.floatMatrix[0];
            this.whiteMatrix = floatMatrix2.rowSums().divi((float)floatMatrix2.columns);
        } else {
            this.refFrame = null;
            this.darkMatrix = null;
            this.whiteMatrix = null;
        }
    }

    public FloatMatrix calculate(float[] fArray) {
        int n;
        FloatMatrix floatMatrix = new FloatMatrix(fArray.length, 1);
        for (n = 0; n < fArray.length; ++n) {
            floatMatrix.put(n, fArray[n]);
        }
        if (this.shouldConvert) {
            if (this.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Absorbance)) {
                for (n = 0; n < fArray.length; ++n) {
                    floatMatrix.put(n, absToRef.convert(floatMatrix.get(n)));
                }
            }
            floatMatrix.muli(this.whiteMatrix);
            floatMatrix.divi(this.darkMatrix);
            floatMatrix.addi(1.0f);
        } else if (this.maxSignal != null) {
            floatMatrix.divi(this.maxSignal.value);
        }
        return floatMatrix;
    }

    public static Snr calculateMinSnr(List<Sample> list) {
        FloatMatrix floatMatrix = null;
        HashMap<Measurement, SignalNoiseRatio> hashMap = new HashMap<Measurement, SignalNoiseRatio>();
        for (Sample sample : list) {
            Measurement measurement = sample.measurement();
            SignalNoiseRatio signalNoiseRatio = (SignalNoiseRatio)hashMap.get(measurement);
            if (signalNoiseRatio == null) {
                signalNoiseRatio = new SignalNoiseRatio(measurement);
                hashMap.put(measurement, signalNoiseRatio);
            }
            float[] fArray = sample.getSamplePath().getAverageProfile();
            FloatMatrix floatMatrix2 = signalNoiseRatio.calculate(fArray);
            if (floatMatrix == null) {
                floatMatrix = new FloatMatrix(fArray.length, 1);
            }
            floatMatrix.addi(floatMatrix2);
        }
        return new Snr(floatMatrix.div((float)list.size()));
    }

    public static class Snr {
        public final FloatMatrix values;
        public final MinMax minMax = new MinMax();

        public Snr(FloatMatrix floatMatrix) {
            this.values = floatMatrix;
            for (int i = 0; i < floatMatrix.length; ++i) {
                this.minMax.add(floatMatrix.get(i));
            }
        }
    }
}

