/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.jblas.FloatMatrix;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertiesHelper;

public class StrayLightManager {
    private final float[][] refStrayLight;
    private RtFrame actualStrayLight;
    private IntegrationTime refItegrationTime;
    private IntegrationTime actualIntegrationTime;
    private MaxSignal maxSignal;

    public StrayLightManager(String string) {
        try {
            File file = new File(string);
            List<String> list = Files.readAllLines(file.toPath());
            int n = 0;
            this.refItegrationTime = new IntegrationTime(RtDataFormat.toNumberInt(list.get(n++)));
            int n2 = RtDataFormat.toNumberInt(list.get(n++));
            int n3 = RtDataFormat.toNumberInt(list.get(n++));
            this.refStrayLight = new float[n3][n2];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.refStrayLight[i][j] = RtDataFormat.toNumberFloat(list.get(n++));
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public StrayLightManager(String string, PixelWidth pixelWidth, BandCount bandCount, IntegrationTime integrationTime, MaxSignal maxSignal, int n) {
        this(string);
        this.maxSignal = maxSignal;
        this.actualStrayLight = new RtFrame(bandCount, pixelWidth, bandCount.indexBands(), n);
        if (integrationTime.value == 0.0f) {
            integrationTime = new IntegrationTime(this.refItegrationTime.value);
        }
        this.actualIntegrationTime = integrationTime;
        float f = integrationTime.value / this.refItegrationTime.value;
        float f2 = (float)this.refStrayLight[0].length / (float)pixelWidth.value;
        for (int i = 0; i < this.refStrayLight.length; ++i) {
            for (int j = 0; j < pixelWidth.value; ++j) {
                float f3 = this.refStrayLight[i][(int)((float)j * f2)];
                this.actualStrayLight.setFrameValue(i, j, f3 * f);
            }
        }
    }

    public float[][] getMatrix() {
        return this.refStrayLight;
    }

    public IntegrationTime getRefIntegrationTime() {
        return this.refItegrationTime;
    }

    public IntegrationTime getActualIntegrationTime() {
        return this.actualIntegrationTime;
    }

    public RtFrame getStrayLight() {
        return this.actualStrayLight;
    }

    public void apply(FloatMatrix floatMatrix, int n) {
        float[] fArray = this.actualStrayLight.getMatrix((int)n).data;
        float f = this.maxSignal.value * 0.99f;
        float[] fArray2 = floatMatrix.data;
        for (int i = 0; i < fArray2.length; ++i) {
            float f2 = fArray2[i];
            if (!(f2 < f)) continue;
            fArray2[i] = Math.max(0.0f, f2 - fArray[i]);
        }
    }

    public void applyWhite(FloatMatrix floatMatrix) {
        for (int i = 0; i < this.actualStrayLight.rows.value; ++i) {
            for (int j = 0; j < this.actualStrayLight.columns.value; ++j) {
                float f = floatMatrix.get(i, j);
                floatMatrix.put(i, j, f - this.actualStrayLight.getFrameValue(i, j));
            }
        }
    }

    public static void addStraylightToElement(String string, Element element) {
        StrayLightManager strayLightManager = new StrayLightManager(string);
        Element element2 = XmlParserHelper.addElement((Node)element, "strayLightValues", XmlPropertiesHelper.createArrayString(strayLightManager.refStrayLight));
        XmlParserHelper.setAttribute((Node)element2, "refIntegrationTime", strayLightManager.getRefIntegrationTime().value);
    }
}

