/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.awt.FontMetrics;
import java.util.Set;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.map.common.swing.filechooser.StringTools;

public class StringHelper
extends StringTools {
    public static String getVariableName(String string) {
        return StringHelper.removeSpace(string).toUpperCase();
    }

    public static String removeSpace(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = stringBuilder.length() - 1; i >= 0; --i) {
            if (stringBuilder.charAt(i) != ' ') continue;
            stringBuilder.deleteCharAt(i);
        }
        return stringBuilder.toString();
    }

    public static String removeAllNonXmlTagCharacters(String string) {
        return string.replaceAll("[^a-zA-Z0-9.\\-_]", "");
    }

    public static String removeNonAlphanumericCharacters(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static String coalesce(String ... stringArray) {
        for (String string : stringArray) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static String formatObject(Object object) {
        if (object != null) {
            return StringHelper.formatLabel(object.toString());
        }
        return "";
    }

    public static String formatLabel(String string) {
        if (string == null) {
            return "";
        }
        Set<String> set = Set.of("HySpex");
        if (set.contains(string)) {
            return string;
        }
        boolean bl = false;
        int n = -1;
        char c = '\u0000';
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (i == 0) {
                stringBuilder.append(Character.toUpperCase(c2));
            } else {
                if (Character.isWhitespace(c2) || c2 == '_' || c2 == '-' || c2 == '.') {
                    stringBuilder.append(c2);
                    n = -1;
                    bl = false;
                    continue;
                }
                if (n != -1 && n != Character.getType(c2)) {
                    bl = true;
                }
                if (bl && (Character.isUpperCase(c2) || Character.isDigit(c2))) {
                    if (c != '(') {
                        stringBuilder.append(" ");
                    }
                    bl = false;
                }
                stringBuilder.append(c2);
            }
            c = c2;
            n = Character.getType(c2);
        }
        return stringBuilder.toString();
    }

    public static int hashCode(String string) {
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            return string.hashCode();
        }
        return 0;
    }

    public static int hashCode(String ... stringArray) {
        int n = 0;
        for (String string : stringArray) {
            n += StringHelper.hashCode(string);
        }
        return n;
    }

    public static int countCharInLine(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static String numberToOrdinal(int n) {
        return switch (n) {
            case 0 -> "first";
            case 1 -> "second";
            case 2 -> "third";
            case 3 -> "fourth";
            case 4 -> "fifth";
            case 5 -> "sixth";
            case 6 -> "seventh";
            case 7 -> "eighth";
            case 8 -> "ninth";
            case 9 -> "tenth";
            default -> "n/a";
        };
    }

    public static int ordinalToNumber(String string) {
        return switch (string.toLowerCase()) {
            case "first" -> 0;
            case "second" -> 1;
            case "third" -> 2;
            case "fourth" -> 3;
            case "fifth" -> 4;
            case "sixth" -> 5;
            case "seventh" -> 6;
            case "eighth" -> 7;
            case "ninth" -> 8;
            case "tenth" -> 9;
            default -> -1;
        };
    }

    public static String abbreviate(String string, JLabel jLabel, int n) {
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n2 = fontMetrics.stringWidth(string);
        if (n2 > n) {
            int n3 = (int)Math.floor((double)(string.length() * n) / (double)n2);
            return StringUtils.abbreviate((String)string, (int)n3);
        }
        return string;
    }

    public static String pluralize(int n, String string) {
        if (n > 1) {
            return n + " " + string + "s";
        }
        return n + " " + string;
    }
}

