/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

public abstract class Time {
    public static final Seconds Second = new Seconds(1.0);
    public static final Seconds FiveSeconds = new Seconds(5.0);
    public static final Seconds FifteenSeconds = new Seconds(15.0);
    public static final Seconds ThirtySeconds = new Seconds(30.0);
    public static Time None = new MilliSeconds(0L);
    public static Time Forever = new MilliSeconds(Integer.MAX_VALUE);
    public final long ms;

    private Time(long l) {
        this.ms = l;
    }

    public float toSeconds() {
        return (float)this.ms / 1000.0f;
    }

    public float toMinutes() {
        return this.toSeconds() / 60.0f;
    }

    public float toHours() {
        return this.toMinutes() / 60.0f;
    }

    public float toDays() {
        return this.toHours() / 24.0f;
    }

    public float toFps() {
        return 1000.0f / (float)Math.max(this.ms, 1L);
    }

    public boolean isZero() {
        return this.ms == 0L;
    }

    public String toCompactNiceString() {
        if (this.ms < 1000L) {
            return this.ms + "ms";
        }
        if (this.toSeconds() < 60.0f) {
            int n;
            if (this.toSeconds() < 5.0f && (n = (int)(this.ms % 1000L)) > 0) {
                return String.format("%ds:%03dms", (int)this.toSeconds(), n);
            }
            return String.format("%ds", (int)this.toSeconds());
        }
        if (this.toMinutes() < 60.0f) {
            int n = (int)(this.toSeconds() % 60.0f);
            if (n > 0) {
                return String.format("%dm:%02ds", (int)this.toMinutes(), n);
            }
            return String.format("%dm", (int)this.toMinutes());
        }
        if (this.toHours() < 24.0f) {
            int n = (int)(this.toMinutes() % 60.0f);
            if (n > 0) {
                return String.format("%dh:%02dm", (int)this.toHours(), n);
            }
            return String.format("%dh", (int)this.toHours());
        }
        int n = (int)this.toDays();
        int n2 = (int)(this.toHours() % 24.0f);
        if (n2 > 0) {
            return String.format("%dd:%02dh", n, n2);
        }
        return String.format("%dd", n);
    }

    public Time add(Time time) {
        return new MilliSeconds(time.ms + this.ms);
    }

    public Time multiplied(double d) {
        return new MilliSeconds((long)(d * (double)this.ms));
    }

    public boolean equals(Object object) {
        return this.ms == ((Time)object).ms;
    }

    public static Time max(Time time, Time time2) {
        return new MilliSeconds(Math.max(time.ms, time2.ms));
    }

    public static class MilliSeconds
    extends Time {
        public MilliSeconds(long l) {
            super(l);
        }

        public String toString() {
            return String.format("%d ms", this.ms);
        }
    }

    public static class Seconds
    extends Time {
        private static final double msInSecond = 1000.0;

        public Seconds(double d) {
            super((long)(d * 1000.0));
        }

        public String toString() {
            return String.format("%.2f s", (double)this.ms / 1000.0);
        }
    }

    public static class Days
    extends Time {
        private static final double msInDays = 8.64E7;

        public Days(double d) {
            super((int)(d * 8.64E7));
        }

        public String toString() {
            return String.format("%.2f days", (double)this.ms / 8.64E7);
        }
    }

    public static class Hours
    extends Time {
        private static final double msInHour = 3600000.0;

        public Hours(double d) {
            super((int)(d * 3600000.0));
        }

        public String toString() {
            return String.format("%.2f hours", (double)this.ms / 3600000.0);
        }
    }

    public static class Minutes
    extends Time {
        private static final double msInMinute = 60000.0;

        public Minutes(double d) {
            super((int)(d * 60000.0));
        }

        public String toString() {
            return String.format("%.2f min", (double)this.ms / 60000.0);
        }
    }
}

