/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class XmlDocumentRoot {
    private final Document document;

    public XmlDocumentRoot(String string) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException(exception);
        }
    }

    public XmlDocumentRoot() {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            XmlParserHelper.addRoot("root", this.document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public Element node() {
        return this.document.getDocumentElement();
    }

    public String xml() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(this.document), new StreamResult(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

