/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.average;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.average.AverageSpectralViewer;
import se.prediktera.breeze.common.util.average.SelectionAreaBuilder;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.evince.datasource.reference.EndMemberExportInfo;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;
import se.prediktera.map.plot.spectral.SpectralPlotHelper;

public class AveragePlotPanel
extends JPanel {
    public FunctionParameterCustomInput.EditTransformationPanel transformationPanel;
    private final AverageSpectralViewer viewer;
    private final AbstractPlot.PlotTypes type;
    public final AbstractPlot plot;
    public final TransformationParameter transformations = new TransformationParameter();

    public AveragePlotPanel(AverageSpectralViewer averageSpectralViewer, AbstractPlot.PlotTypes plotTypes, String string) {
        super(new BorderLayout());
        this.viewer = averageSpectralViewer;
        this.type = plotTypes;
        this.transformations.setValue(string);
        this.transformationPanel = new FunctionParameterCustomInput.EditTransformationPanel(this.transformations, averageSpectralViewer.getFrame(), BreezeType.Project.getColor(), (functionParameter, object, bl) -> {
            averageSpectralViewer.updateSamples();
            averageSpectralViewer.updateTitle();
        }, "Select spectral filters", false);
        this.transformationPanel.addButton(EntryMainHelper.createButton("Delete", "explore/delete", () -> averageSpectralViewer.removePlot(this)));
        if (plotTypes.equals((Object)AbstractPlot.PlotTypes.Spectrum)) {
            this.plot = new SpectrumPlot(averageSpectralViewer);
            this.plot.setRubberAction(AbstractRubberband.RubberAction.Zoom, AbstractRubberband.RubberType.Vertical, null);
        } else {
            this.plot = new ScatterPlot(averageSpectralViewer);
            this.plot.setRubberAction(AbstractRubberband.RubberAction.Selection, AbstractRubberband.RubberType.Rectangle, null);
        }
        this.add((Component)((Object)this.plot), "Center");
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
    }

    public AbstractPlot.PlotTypes getType() {
        return this.type;
    }

    public AbstractPlot getPlot() {
        return this.plot;
    }

    public void setMeasurement(Measurement measurement) {
        this.plot.setMeasurement(measurement);
    }

    public void setYMax(Double d) {
        this.plot.setYmax(d);
        this.updateMinMaxAndRepaint();
    }

    public void updateMinMaxAndRepaint() {
        this.plot.setMinMax();
        this.plot.contentPaint();
    }

    public void drawWrappers(List<SpectrumDataWrapper> list) {
        Object object = this.plot;
        if (object instanceof ScatterPlot) {
            ScatterPlot scatterPlot = (ScatterPlot)((Object)object);
            scatterPlot.select(this.viewer.getLiveWrapper());
            return;
        }
        ArrayList<SpectrumDataWrapper> arrayList = new ArrayList<SpectrumDataWrapper>();
        object = null;
        for (SpectrumDataWrapper spectrumDataWrapper : list) {
            Object object2;
            SpectrumDataWrapper spectrumDataWrapper2 = spectrumDataWrapper.copy();
            DataWrapper dataWrapper = this.plot.wrapper;
            if (dataWrapper instanceof SpectrumDataWrapper) {
                object2 = (SpectrumDataWrapper)dataWrapper;
                if (object2.id.equals(spectrumDataWrapper2.id)) {
                    object = spectrumDataWrapper2;
                }
            }
            object2 = this.transformations.getTransformationModules(1);
            spectrumDataWrapper2.setDataY(TransformationParameter.getData((List<RtModule>)object2, spectrumDataWrapper2.getDataY()));
            arrayList.add(spectrumDataWrapper2);
        }
        this.plot.wrapper = object;
        this.plot.setData(arrayList);
        this.updateMinMaxAndRepaint();
    }

    public SampleDataWrapper getSampleWrapper(Sample sample) {
        for (DataWrapper dataWrapper : this.plot.getPointWrapperList()) {
            SampleDataWrapper sampleDataWrapper;
            if (!(dataWrapper instanceof SampleDataWrapper) || !(sampleDataWrapper = (SampleDataWrapper)dataWrapper).getSample().equals(sample)) continue;
            return sampleDataWrapper;
        }
        return null;
    }

    public static abstract class AbstractPlot
    extends SpectralPlot {
        protected final AverageSpectralViewer viewer;
        protected int index;
        protected DataWrapper wrapper;
        protected Measurement measurement;
        protected RawHeader header;
        protected BandNames bandNames;

        public AbstractPlot(AverageSpectralViewer averageSpectralViewer) {
            this.viewer = averageSpectralViewer;
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setForeground(breezeTheme.getLabelForeground());
            this.setGridColor(breezeTheme.getPlotGridColor());
            this.setZeroColor(breezeTheme.getLabelForeground());
            this.sx = 50;
            this.sy = 15;
        }

        public void selectWrapper(DataWrapper dataWrapper) {
        }

        public void syncIndex(int n, int n2) {
        }

        public abstract void setMeasurement(Measurement var1);

        protected boolean setRawFile(RawFile rawFile) {
            if (RawFile.exists(rawFile)) {
                this.header = rawFile.header();
                this.bandNames = this.header.bandNames();
                this.setValues(this.bandNames.isNumber() ? null : this.bandNames.toArray());
                return true;
            }
            this.header = null;
            this.bandNames = null;
            this.setValues(null);
            return false;
        }

        public static enum PlotTypes {
            Spectrum,
            Scatter;

        }
    }

    public static class SpectrumPlot
    extends AbstractPlot {
        public SpectrumPlot(AverageSpectralViewer averageSpectralViewer) {
            super(averageSpectralViewer);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setForeground(breezeTheme.getLabelForeground());
            this.setGridColor(breezeTheme.getPlotGridColor());
            this.setZeroColor(breezeTheme.getLabelForeground());
            this.setXdesc("Wavelength");
            this.sx = 50;
            this.sy = 15;
        }

        protected void createPopupMenu(MouseEvent mouseEvent) {
            BreezeFrame breezeFrame = this.viewer.getFrame();
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
            breezeContextMenu.addButtonCloseClick("Save spectral data", this::exportSpectra);
            breezeContextMenu.addButtonCloseClick("Copy as image to clipboard", () -> ((SpectrumPlot)this).copyToClipboard());
            breezeContextMenu.addSeparator();
            breezeContextMenu.addButtonCloseClick("Reset zoom", () -> ((SpectrumPlot)this).zoomAll());
            if (breezeContextMenu.resize()) {
                breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(mouseEvent);
            }
        }

        public void exportSpectra() {
            AbstractExportInfo.ExportDataNow((SimpleTableModel)this.getSpectralMatrix(this.getSampleDataWrappers()).createTableModel(true), (boolean)false, (AbstractExportInfo)new EndMemberExportInfo());
        }

        public List<DataWrapper> getSampleDataWrappers() {
            ArrayList<DataWrapper> arrayList = new ArrayList<DataWrapper>();
            for (DataWrapper dataWrapper : this.getPointWrapperList()) {
                if (!(dataWrapper instanceof SampleDataWrapper)) continue;
                arrayList.add(dataWrapper);
            }
            return arrayList;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            List list = this.getPointWrapperList();
            if (!list.isEmpty()) {
                double[] dArray = new double[2];
                this.Screen2Real(dArray, mouseEvent.getX(), mouseEvent.getY());
                if (dArray[0] > 0.0) {
                    int n = this.getIndex(dArray[0]);
                    DataWrapper dataWrapper = this.getWrapperClosestTo(dArray[0], dArray[1]);
                    this.viewer.syncIndex(n, list.indexOf(dataWrapper));
                }
            }
        }

        @Override
        public void syncIndex(int n, int n2) {
            this.index = n;
            List list = this.getPointWrapperList();
            if (n2 >= 0 && n2 < list.size()) {
                this.wrapper = (DataWrapper)list.get(n2);
            }
            this.selectWrapper(this.wrapper);
        }

        @Override
        public void selectWrapper(DataWrapper dataWrapper) {
            this.wrapper = dataWrapper;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            double[] dArray = new double[2];
            if (this.hasData() && this.header != null && this.viewer.showRgbBands()) {
                float[] fArray = this.header.rgbBands().getValueArray(this.bandNames, 3);
                graphics2D.setStroke(new BasicStroke(2.0f, 1, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f));
                for (int i = 0; i < fArray.length; ++i) {
                    graphics2D.setColor(RtPerfectSpread.withAlpha(RgbBands.RgbColors[i], 128));
                    this.Real2Screen(dArray, fArray[i], 0.0);
                    graphics2D.drawLine((int)dArray[0], this.sy, (int)dArray[0], this.sy + this.height);
                }
            }
            if (this.wrapper != null && this.wrapper.hasDataY()) {
                float f = this.wrapper.getXvalueAt(this.index);
                float f2 = this.wrapper.getYvalueAt(this.index);
                this.Real2Screen(dArray, f, f2);
                int n = Math.min(15, this.height / 25);
                int n2 = n / 2;
                graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
                graphics2D.setStroke(new BasicStroke(2.0f, 1, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f));
                graphics2D.drawLine((int)dArray[0], this.sy, (int)dArray[0], this.sy + this.height);
                graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
                String string = RtDataFormat.toString(f);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n3 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, (int)dArray[0] - n3 - 5, this.sy - 2);
                graphics2D.drawString(RtDataFormat.toString(f2), (int)dArray[0] + 5, this.sy - 2);
                graphics2D.drawString(this.wrapper.getName(), (int)dArray[0] + 5, this.sy + 2 + fontMetrics.getHeight());
                graphics2D.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f));
                graphics2D.setColor(this.wrapper.getColor());
                graphics2D.fillOval((int)dArray[0] - n2, (int)dArray[1] - n2, n, n);
                graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
                graphics2D.drawOval((int)dArray[0] - n2, (int)dArray[1] - n2, n, n);
            }
        }

        @Override
        public void setMeasurement(Measurement measurement) {
            this.setRawFile(measurement.rawFile());
        }

        protected String getNoSpectraDesc() {
            return "Load an image and add Areas to see average spectra";
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            DataWrapper dataWrapper;
            double[] dArray = new double[2];
            this.Screen2Real(dArray, mouseEvent.getX(), mouseEvent.getY());
            if (dArray[0] > 0.0 && (dataWrapper = this.getWrapperClosestTo(dArray[0], dArray[1])) != null) {
                return "<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" ><tr><td>Wavelength:</td><td>" + this.getValue(this.index) + "</td></tr></table></html>";
            }
            return super.getToolTipText(mouseEvent);
        }
    }

    public static class ScatterPlot
    extends AbstractPlot {
        private int interactionIndex;
        private FunctionTreeNode node;

        public ScatterPlot(AverageSpectralViewer averageSpectralViewer) {
            super(averageSpectralViewer);
        }

        public void select(LiveWrapper liveWrapper) {
            if (this.header != null) {
                this.interactionIndex = liveWrapper.y * this.header.pixelWidth().value + liveWrapper.x;
                this.repaint();
            }
        }

        @Override
        public void setMeasurement(Measurement measurement) {
            RawFile rawFile = measurement.getPrediction();
            if (this.setRawFile(rawFile)) {
                this.setXdesc("t1");
                this.setYdesc("t2");
                List list = this.getPointWrapperList();
                list.clear();
                int n = this.header.pixelWidth().value;
                DataWrapper dataWrapper = new DataWrapper("Data");
                dataWrapper.setShowDotBorder(false);
                dataWrapper.setShowLine(false);
                dataWrapper.setShowDots(true);
                dataWrapper.setDotSize(3);
                float[] fArray = new float[n * this.header.frameCount().value];
                dataWrapper.setDataX(fArray);
                float[] fArray2 = new float[n * this.header.frameCount().value];
                dataWrapper.setDataY(fArray2);
                int[] nArray = this.getBands();
                int n2 = 0;
                try (FrameReader.FrameIterator frameIterator = new FrameReader(rawFile.file(), rawFile.header(), nArray, false, FrameListFromRaw.Reduce.Original).iterator();){
                    while (frameIterator.hasNext()) {
                        FloatFrame floatFrame = (FloatFrame)frameIterator.next();
                        float[][] fArray3 = floatFrame.origframe;
                        for (int i = 0; i < n; ++i) {
                            fArray[n2] = fArray3[0][i];
                            fArray2[n2] = fArray3[1][i];
                            ++n2;
                        }
                    }
                }
                list.add(dataWrapper);
                this.setMinMax();
                SpectralPlotHelper.computeDensityBuckets((DataWrapper)dataWrapper);
                this.contentPaint();
            } else {
                this.setData(new ArrayList());
            }
        }

        private int[] getBands() {
            if (this.node != null) {
                BasicAnalyse basicAnalyse = this.node.getAnalyse();
                PropertyList propertyList = basicAnalyse.getPropertyFactors();
                int n = ThumbnailHelper.getBandLayer(this.header.bandNames(), basicAnalyse, propertyList.get(0));
                int n2 = ThumbnailHelper.getBandLayer(this.header.bandNames(), basicAnalyse, propertyList.get(1));
                return new int[]{n, n2};
            }
            return new int[]{0, 1};
        }

        public void setNode(FunctionTreeNode functionTreeNode) {
            this.node = functionTreeNode;
        }

        protected String getNoSpectraDesc() {
            return "No data available";
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            double[] dArray = new double[2];
            DataWrapper dataWrapper = this.getWrapper(0);
            if (dataWrapper != null && this.interactionIndex >= 0 && this.interactionIndex < dataWrapper.getSize()) {
                this.Real2Screen(dArray, dataWrapper.getXvalueAt(this.interactionIndex), dataWrapper.getYvalueAt(this.interactionIndex));
                graphics2D.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f));
                graphics2D.setColor(this.selectionColor);
                graphics2D.fillOval((int)(dArray[0] - 5.0), (int)(dArray[1] - 5.0), 10, 10);
                graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
                graphics2D.drawOval((int)(dArray[0] - 5.0), (int)(dArray[1] - 5.0), 10, 10);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (!this.getPointWrapperList().isEmpty()) {
                double[] dArray = new double[2];
                this.Screen2Real(dArray, mouseEvent.getX(), mouseEvent.getY());
                this.interactionIndex = this.getIndexClosestTo((float)dArray[0], (float)dArray[1]);
                if (this.interactionIndex >= 0) {
                    int n = this.interactionIndex % this.header.pixelWidth().value;
                    int n2 = this.interactionIndex / this.header.pixelWidth().value;
                    Rectangle rectangle = new Rectangle(n, n2, 1, 1);
                    this.viewer.panel.interact(rectangle);
                    this.viewer.getting(this.measurement, rectangle, fArray -> this.viewer.liveSpectrum(this, n, n2, fArray));
                }
                this.repaint();
            }
        }

        protected boolean selectArea(double[] dArray, double[] dArray2, Shape shape) {
            boolean bl = super.selectArea(dArray, dArray2, shape);
            DataWrapper dataWrapper = this.getWrapper(0);
            if (dataWrapper != null) {
                Shape shape2 = SelectionAreaBuilder.buildShape(dataWrapper.getSelected(), this.header.pixelWidth().value, this.header.frameCount().value);
                this.viewer.panel.selectionArea(shape2);
            }
            return bl;
        }

        protected void createPopupMenu(MouseEvent mouseEvent) {
            BreezeFrame breezeFrame = this.viewer.getFrame();
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
            breezeContextMenu.addButtonCloseClick("Copy as image to clipboard", () -> ((ScatterPlot)this).copyToClipboard());
            breezeContextMenu.addSeparator();
            breezeContextMenu.addButtonCloseClick("Reset zoom", () -> ((ScatterPlot)this).zoomAll());
            if (breezeContextMenu.resize()) {
                breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(mouseEvent);
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n;
            double[] dArray = new double[2];
            this.Screen2Real(dArray, mouseEvent.getX(), mouseEvent.getY());
            DataWrapper dataWrapper = this.getWrapper(0);
            if (dataWrapper != null && (n = this.getIndexClosestTo((float)dArray[0], (float)dArray[1])) >= 0) {
                return "<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" ><tr><td>X:</td><td>" + dataWrapper.getXvalueAt(n) + "</td></tr></table></html>";
            }
            return super.getToolTipText(mouseEvent);
        }
    }

    public static class LiveWrapper
    extends SpectrumDataWrapper {
        public int x;
        public int y;

        public LiveWrapper() {
            super("Pixel under cursor position");
        }

        public void update(int n, int n2, float[] fArray) {
            this.x = n;
            this.y = n2;
            this.setDataY(fArray);
        }
    }

    public static class SpectrumDataWrapper
    extends DataWrapper {
        public String id = UniqueUID.getUniqueId();

        public SpectrumDataWrapper(String string) {
            super(string);
        }

        private SpectrumDataWrapper(float[] fArray, float[] fArray2) {
            this(fArray, fArray2, "");
        }

        public SpectrumDataWrapper(float[] fArray, float[] fArray2, String string) {
            super(fArray, fArray2, string);
        }

        public SpectrumDataWrapper copy() {
            return (SpectrumDataWrapper)super.copy();
        }
    }

    public static class SampleDataWrapper
    extends SpectrumDataWrapper {
        private final SampleArea sample;

        protected SampleDataWrapper(float[] fArray, float[] fArray2, SampleArea sampleArea) {
            super(fArray, fArray2);
            this.sample = sampleArea;
            this.id = sampleArea.id;
            this.setColor(sampleArea.getColor());
        }

        public Sample getSample() {
            return this.sample;
        }

        public void setColor(Color color) {
            super.setColor(color);
            this.sample.setColor(color);
        }

        public void setName(String string) {
            super.setName(string);
            this.sample.setName(string);
        }

        public String getName() {
            return this.sample.getName();
        }
    }

    public static class SampleArea
    extends Sample {
        public String id = UniqueUID.getUniqueId();
        private String name;
        private Color color;

        public SampleArea(RootSample rootSample, String string, Color color) {
            super(rootSample);
            this.name = string;
            this.color = color;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

