/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.average;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.unmixing.GaussianResampler;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.common.util.average.AverageSpectralViewerLegend;
import se.prediktera.breeze.common.util.average.AverageSpectrumSettingsPanel;
import se.prediktera.breeze.common.util.average.AverageSpectrumViewPanel;
import se.prediktera.breeze.common.util.average.FileAverageSpectrum;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeColorChooser;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.preview.PreviewHelper;
import se.prediktera.breeze.frontend.main.record.measurement.panel.AddSamplesPanel;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.plot.spectral.DataWrapper;

public class AverageSpectralViewer
extends JPanel {
    private final List<TitlePlot> panels = new ArrayList<TitlePlot>();
    public final BasicPreviewPanel panel;
    private final JPanel centerPanel = new JPanel(new GridBagLayout());
    public JPanel holderPanel = new JPanel(new BorderLayout());
    public final AverageSpectralViewerLegend legendPanel = new AverageSpectralViewerLegend(this);
    public List<Sample> samples = new ArrayList<Sample>();
    private Measurement measurement;
    public final AverageSpectrumSettingsPanel leftSettingsPanel;
    private final BreezeFrame frame;
    private static File lastFolder;
    private final AveragePlotPanel.LiveWrapper liveWrapper = new AveragePlotPanel.LiveWrapper();
    private final List<AveragePlotPanel.SampleDataWrapper> sampleWrappers = new ArrayList<AveragePlotPanel.SampleDataWrapper>();
    private final List<AveragePlotPanel.SpectrumDataWrapper> pinnedWrappers = new ArrayList<AveragePlotPanel.SpectrumDataWrapper>();
    private final AverageSpectrumViewPanel spectrumPreviewPanel;
    private boolean viewHorizontal = true;
    private boolean showLiveSpectrum = true;
    private boolean showRgbBands = true;
    private float[] wavelength;

    public AverageSpectralViewer(EntryMainPanel entryMainPanel, AverageSpectrumViewPanel averageSpectrumViewPanel, BasicPreviewPanel basicPreviewPanel, boolean bl) {
        super(new BorderLayout());
        this.frame = entryMainPanel.getFrame();
        this.spectrumPreviewPanel = averageSpectrumViewPanel;
        this.panel = basicPreviewPanel;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.centerPanel.setBackground(breezeTheme.getSettingPanelBackground());
        this.add((Component)this.centerPanel, "Center");
        this.holderPanel.setBorder(BorderFactory.createLineBorder(breezeTheme.getLabelForegroundDifuse()));
        this.holderPanel.setBackground(this.centerPanel.getBackground());
        this.holderPanel.setPreferredSize(new Dimension(0, 10));
        this.add((Component)this.holderPanel, "South");
        this.liveWrapper.setColor(breezeTheme.getLabelForeground());
        this.liveWrapper.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f));
        this.legendPanel.updateList();
        this.leftSettingsPanel = new AverageSpectrumSettingsPanel(entryMainPanel, this, bl);
    }

    public void updateTitle() {
        for (TitlePlot titlePlot : this.panels) {
            Object object;
            String string = titlePlot.plot.transformations.getShortDescriptions();
            Object object2 = object = titlePlot.plot.getType().equals((Object)AveragePlotPanel.AbstractPlot.PlotTypes.Spectrum) ? this.leftSettingsPanel.convertTo.getPlotTitle(this.measurement) : "Scatter";
            if (!string.isEmpty()) {
                object = (String)object + " (" + string + ")";
            }
            titlePlot.label.setText((String)object);
        }
    }

    public void syncIndex(int n, int n2) {
        this.forEach(averagePlotPanel -> averagePlotPanel.plot.syncIndex(n, n2));
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
        RawHeader rawHeader = measurement.rawFile().header();
        this.wavelength = rawHeader.bandNames().toFloatArray();
        this.liveWrapper.setDataX(this.wavelength);
        this.liveWrapper.setDataY(null);
        this.samples = measurement.sampleAreas;
        this.forEach(averagePlotPanel -> averagePlotPanel.setMeasurement(measurement));
        this.leftSettingsPanel.setMeasurement(measurement);
        this.updateTitle();
        this.drawSamples();
    }

    public AveragePlotPanel addPlot(AveragePlotPanel.AbstractPlot.PlotTypes plotTypes, String string) {
        AveragePlotPanel averagePlotPanel = new AveragePlotPanel(this, plotTypes, string);
        if (this.measurement != null) {
            averagePlotPanel.setMeasurement(this.measurement);
        }
        this.panels.add(new TitlePlot(new BreezeLabel("", false, 14), averagePlotPanel));
        this.updateTitle();
        this.layoutPanels();
        this.leftSettingsPanel.updateFilters();
        this.drawSamples();
        return averagePlotPanel;
    }

    public AveragePlotPanel getPlot(int n) {
        return this.panels.get((int)n).plot;
    }

    public void removePlot(AveragePlotPanel averagePlotPanel) {
        int n = this.getIndex(averagePlotPanel);
        if (this.panels.size() > 1 && n < this.panels.size()) {
            this.panels.remove(n);
            this.layoutPanels();
            this.leftSettingsPanel.updateFilters();
        }
    }

    private int getIndex(AveragePlotPanel averagePlotPanel) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if (this.panels.get((int)i).plot != averagePlotPanel) continue;
            return i;
        }
        return -1;
    }

    public void layoutPanels() {
        this.centerPanel.removeAll();
        for (int i = 0; i < this.panels.size(); ++i) {
            TitlePlot titlePlot = this.panels.get(i);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
            GridBagConstraints gridBagConstraints = GridBagHelper.create(jPanel.getComponentCount(), new Insets(2, 0, 0, 0));
            gridBagConstraints.fill = 0;
            jPanel.add((Component)titlePlot.label, gridBagConstraints);
            jPanel.add((Component)titlePlot.plot, GridBagHelper.createLast(jPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            if (this.viewHorizontal) {
                this.centerPanel.add((Component)jPanel, GridBagHelper.createLast(this.centerPanel.getComponentCount(), new Insets(i > 0 ? 5 : 0, 0, 0, 0)));
                continue;
            }
            GridBagConstraints gridBagConstraints2 = GridBagHelper.create(i, 1, new Insets(0, i > 0 ? 5 : 0, 0, 0));
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            this.centerPanel.add((Component)jPanel, gridBagConstraints2);
        }
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    public void switchView() {
        this.viewHorizontal = !this.viewHorizontal;
        this.spectrumPreviewPanel.changeView(this.viewHorizontal);
        this.layoutPanels();
    }

    public void clear() {
        this.clear(this.samples);
    }

    public void clear(List<Sample> list) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>(list);
        this.samples.removeAll(arrayList);
        this.panel.getSelectedSamples().removeAll(arrayList);
        this.panel.repaint();
        this.drawSamples();
    }

    public void load() {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Import spectra", (Component)this.frame);
        jopensaveDialog2.setPreview(null, true);
        if (jopensaveDialog2.getSelectedFile() == null) {
            jopensaveDialog2.setCurrentDirectory(lastFolder);
        }
        MembersSetting.EndMemberFileParameter.addAllSupported(jopensaveDialog2);
        if (jopensaveDialog2.openshow()) {
            File file = jopensaveDialog2.getSelectedFile();
            if (file.exists()) {
                lastFolder = file.getParentFile();
            }
            Workflow workflow = this.measurement.getWorkflow();
            float[] fArray = this.measurement.rawFile().header().bandNames().toFloatArray();
            List<Reference> list = Reference.read(file, workflow);
            BreezeOptionDialog.showDialog(this.frame, workflow.getType().getPageType().getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select spectra", "", (AbstractBreezeCustomPanel)new SelectMembersPanel(this.frame, list, null, file), null, breezeActionEvent -> {
                List<Reference> list = ((SelectMembersPanel)breezeActionEvent.getBreezeCustomPanel()).getIncluded();
                for (Reference reference : list) {
                    float[] fArray2 = reference.interpolateToArray(fArray, new GaussianResampler());
                    AveragePlotPanel.SpectrumDataWrapper spectrumDataWrapper = new AveragePlotPanel.SpectrumDataWrapper(this.wavelength, fArray2, reference.getName());
                    spectrumDataWrapper.setColor(reference.getColor());
                    spectrumDataWrapper.setStroke(new BasicStroke(2.0f, 1, 0, 10.0f));
                    this.pinnedWrappers.add(spectrumDataWrapper);
                }
                this.drawWrappers();
                this.legendPanel.updateList();
            });
        }
    }

    public void help() {
        BrowserLauncher.open((String)"https://help.prediktera.com/breeze/spectral-viewer");
    }

    public void forEach(Consumer<AveragePlotPanel> consumer) {
        for (TitlePlot titlePlot : this.panels) {
            consumer.accept(titlePlot.plot);
        }
    }

    public void liveSpectrum(AveragePlotPanel.AbstractPlot abstractPlot, int n, int n2, float[] fArray) {
        this.liveWrapper.update(n, n2, fArray);
        this.drawWrappers(abstractPlot);
    }

    public void drawSamples() {
        this.drawSamples(this.samples);
    }

    public void drawSamples(List<Sample> list) {
        this.sampleWrappers.clear();
        for (Sample sample : list) {
            if (!(sample instanceof AveragePlotPanel.SampleArea)) continue;
            AveragePlotPanel.SampleArea sampleArea = (AveragePlotPanel.SampleArea)sample;
            float[] fArray = sample.getSamplePath().getAverageProfile();
            AveragePlotPanel.SampleDataWrapper sampleDataWrapper = new AveragePlotPanel.SampleDataWrapper(this.wavelength, fArray, sampleArea);
            sampleDataWrapper.setStroke(new BasicStroke(2.0f, 1, 0, 10.0f));
            this.sampleWrappers.add(sampleDataWrapper);
        }
        this.drawWrappers();
        this.legendPanel.updateList();
    }

    public void drawWrappersAndRepaint() {
        this.drawWrappers();
        this.panel.repaint();
    }

    public void drawWrappers() {
        this.drawWrappers(null);
    }

    public void drawWrappers(AveragePlotPanel.AbstractPlot abstractPlot) {
        ArrayList<AveragePlotPanel.SpectrumDataWrapper> arrayList = new ArrayList<AveragePlotPanel.SpectrumDataWrapper>();
        arrayList.add(this.liveWrapper);
        arrayList.addAll(this.pinnedWrappers);
        arrayList.addAll(this.sampleWrappers);
        this.forEach(averagePlotPanel -> {
            if (abstractPlot == null || !((Object)((Object)abstractPlot)).equals((Object)averagePlotPanel.plot)) {
                averagePlotPanel.drawWrappers(arrayList);
            }
        });
        this.leftSettingsPanel.EnableModeButtons();
    }

    public void getting(Measurement measurement, Shape shape, FileAverageSpectrum.OnSpectrum onSpectrum) {
        FileAverageSpectrum.getting(measurement, this.getRefSettings(), shape, this.holderPanel, onSpectrum);
    }

    public void resetLiveSpectrum() {
        this.liveWrapper.setDataY(null);
        this.drawWrappers();
    }

    public void updateSamples() {
        this.update(this.measurement, this.samples);
    }

    public void update(Measurement measurement, List<Sample> list) {
        this.update(measurement, list, fArray -> this.drawSamples());
    }

    public void update(Measurement measurement, List<Sample> list, FileAverageSpectrum.OnSpectrum onSpectrum) {
        FileAverageSpectrum.update(measurement, this.getRefSettings(), list, this.holderPanel, onSpectrum);
    }

    public void selectSamples(List<Sample> list) {
        if (!list.isEmpty()) {
            Sample sample = list.getFirst();
            this.forEach(averagePlotPanel -> averagePlotPanel.plot.selectWrapper(averagePlotPanel.getSampleWrapper(sample)));
        }
    }

    public void delete(DataWrapper dataWrapper) {
        if (dataWrapper instanceof AveragePlotPanel.SampleDataWrapper) {
            AveragePlotPanel.SampleDataWrapper sampleDataWrapper = (AveragePlotPanel.SampleDataWrapper)dataWrapper;
            this.panel.getSelectedSamples().remove(sampleDataWrapper.getSample());
            this.samples.remove(sampleDataWrapper.getSample());
            this.panel.repaint();
        }
        this.drawWrappers();
    }

    public void pinAverages() {
        this.pinnedWrappers.addAll(this.sampleWrappers);
        this.drawWrappers();
    }

    public void addMeasurementSamples() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (Sample sample : this.panel.getSampleForCurrentLevel()) {
            List<int[][]> list = PreviewHelper.getShapeBorderPointsArray(sample.getSamplePath().getOrCreateGeneralPath());
            AveragePlotPanel.SampleArea sampleArea = new AveragePlotPanel.SampleArea(this.measurement.getRootSample(), sample.getRecursiveName(Sample.DefaultSampleLabel.IDX), RtPerfectSpread.generateColor(arrayList.size()));
            sampleArea.getSamplePath().addSelectionPath(list);
            arrayList.add(sampleArea);
        }
        this.update(this.measurement, arrayList);
        this.samples.addAll(arrayList);
    }

    public void addAllSamples(BreezeMainPanel breezeMainPanel) {
        this.addSamples(this.measurement.sampleAreas, breezeMainPanel);
    }

    public void addSamples(final List<Sample> list, final BreezeMainPanel breezeMainPanel) {
        if (!list.isEmpty()) {
            Workflow workflow = this.measurement.getWorkflow();
            BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Add sample(s)", "", (AbstractBreezeCustomPanel)new AddSamplesPanel(workflow), null, breezeActionEvent -> {
                String string;
                final AddSamplesPanel addSamplesPanel = (AddSamplesPanel)breezeActionEvent.getBreezeCustomPanel();
                SegmentationNode segmentationNode = addSamplesPanel.getOrCreateSegmentationNode();
                FunctionTreeNode functionTreeNode = SegmentationNode.getParentNode(segmentationNode);
                if (functionTreeNode instanceof FunctionTreeNodeWithId) {
                    FunctionTreeNodeWithId functionTreeNodeWithId = (FunctionTreeNodeWithId)functionTreeNode;
                    string = functionTreeNodeWithId.getUid();
                } else {
                    string = null;
                }
                final Sample sample = this.measurement.getFirstSample(string);
                BreezeProgressDialog.startProgressWithCancel(this.frame, new ProgressAction(this){
                    final /* synthetic */ AverageSpectralViewer this$0;
                    {
                        this.this$0 = averageSpectralViewer;
                    }

                    @Override
                    public void runAction() {
                        CatClass catClass = addSamplesPanel.getCatClass();
                        for (Sample sample2 : list) {
                            SampleHelper.addSample(this.this$0.measurement, sample, catClass, sample2);
                        }
                        this.this$0.measurement.save();
                        ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), this.this$0.measurement);
                        if (breezeMainPanel != null) {
                            SwingUtilities.invokeLater(() -> {
                                breezeMainPanel.selectTab("Table");
                                breezeMainPanel.setDirty(true);
                            });
                        }
                    }
                }, "Create sample(s)");
            });
        } else {
            BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Manual segmentation", "Cannot add sample(s). No area has been created.\n\nPlease create new areas and try again.");
        }
    }

    public RtFramePredictor.RefSettings getRefSettings() {
        return this.measurement.getRefSettings(this.leftSettingsPanel.convertTo);
    }

    public AveragePlotPanel.LiveWrapper getLiveWrapper() {
        return this.liveWrapper;
    }

    public List<AveragePlotPanel.SampleDataWrapper> getSampleWrappers() {
        return this.sampleWrappers;
    }

    public List<AveragePlotPanel.SpectrumDataWrapper> getPinnedWrappers() {
        return this.pinnedWrappers;
    }

    public int getMaxSize() {
        return this.samples.size();
    }

    public BreezeFrame getFrame() {
        return this.frame;
    }

    public boolean showLiveSpectrum() {
        return this.showLiveSpectrum;
    }

    public void setShowLiveSpectrum(boolean bl) {
        this.showLiveSpectrum = bl;
        if (!bl) {
            this.resetLiveSpectrum();
        }
    }

    public void setShowRgbBands(boolean bl) {
        this.showRgbBands = bl;
    }

    public boolean showRgbBands() {
        return this.showRgbBands;
    }

    private record TitlePlot(BreezeLabel label, AveragePlotPanel plot) {
    }

    public static class SampleAreaInputPanel
    extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
        private final BreezeInputField nameInputField = new BreezeInputField("Name and color for the new area:", "", "");
        private final BreezeColorChooser colorInputField = new BreezeColorChooser(true);
        private final double area;

        public SampleAreaInputPanel(AverageSpectralViewer averageSpectralViewer, double d) {
            this(String.valueOf((char)(65 + averageSpectralViewer.getMaxSize())), RtPerfectSpread.generateColor(averageSpectralViewer.getMaxSize()), d);
        }

        private SampleAreaInputPanel(String string, Color color, double d) {
            this.area = d;
            this.nameInputField.setValue(string);
            this.add((Component)this.nameInputField, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
            this.colorInputField.setSelectedItem(color);
            this.colorInputField.setMinimumSize(new Dimension(120, 30));
            this.colorInputField.setPreferredSize(new Dimension(120, 30));
            this.add((Component)this.colorInputField, GridBagHelper.createLeft(this.getComponentCount(), new Insets(12, 24, 0, 24)));
            this.addEndBlock();
            if (this.hasLargeArea()) {
                this.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, "Large areas require more processing time", false), GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
            } else {
                this.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Tip, "Hold Ctrl to create areas without displaying this dialog", false), GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
            }
            this.setPreferredSize(new Dimension(600, 300));
        }

        private boolean hasLargeArea() {
            return this.area > 100000.0;
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public void onShow() {
            SwingUtilities.invokeLater(this.nameInputField::requestFocusAndSelectAll);
        }

        @Override
        public String getResult() {
            return this.nameInputField.getValue();
        }

        public Color getColor() {
            return this.colorInputField.getSelectedColor();
        }

        public AveragePlotPanel.SampleArea createSample(Measurement measurement, List<int[][]> list) {
            AveragePlotPanel.SampleArea sampleArea = new AveragePlotPanel.SampleArea(measurement.getRootSample(), this.getResult(), this.getColor());
            sampleArea.getSamplePath().addSelectionPath(list);
            return sampleArea;
        }

        public void addAreas(ArrayList<Sample> arrayList, Measurement measurement, List<int[][]> list, Runnable runnable, boolean bl) {
            if (list.isEmpty()) {
                return;
            }
            if (bl || this.hasLargeArea()) {
                BreezeOptionDialog.showDialog(BreezeFrame.getInstance(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Add sample area", "", (AbstractBreezeCustomPanel)this, null, breezeActionEvent -> {
                    arrayList.add(this.createSample(measurement, list));
                    runnable.run();
                });
            } else {
                arrayList.add(this.createSample(measurement, list));
                runnable.run();
            }
        }
    }
}

