/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.average;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.common.util.average.AverageSpectralViewer;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.DeleteCatClassInputField;
import se.prediktera.map.plot.spectral.DataWrapper;

public class AverageSpectralViewerLegend
extends DefaultSettingsPanel {
    private final JPanel mainPanel = new JPanel(new GridBagLayout());
    private Object selected;
    private List<? extends DataWrapper> pinnedList;
    private List<? extends DataWrapper> averageList;
    private final AverageSpectralViewer viewer;

    public AverageSpectralViewerLegend(AverageSpectralViewer averageSpectralViewer) {
        super(250, true);
        this.viewer = averageSpectralViewer;
        DefaultSettingsPanel.SectionPanel sectionPanel = this.addSection("Toolbar");
        sectionPanel.addComponent(EntryMainHelper.createButton("Pin", "explore/push_pin", () -> {
            averageSpectralViewer.pinAverages();
            this.updateList();
        }));
        sectionPanel.addComponent(EntryMainHelper.createButton("Up", "material/arrow_upward", () -> {
            int n;
            List list = this.getListForSelected();
            int n2 = n = this.selected != null ? list.indexOf(this.selected) : 0;
            if (n > 0) {
                this.swap(list, n, n - 1);
                averageSpectralViewer.drawWrappers();
                this.updateList();
            }
        }));
        sectionPanel.addComponent(EntryMainHelper.createButton("Down", "material/arrow_downward", () -> {
            int n;
            List list = this.getListForSelected();
            int n2 = n = this.selected != null ? list.indexOf(this.selected) : list.size();
            if (n < list.size() - 1) {
                this.swap(list, n, n + 1);
                averageSpectralViewer.drawWrappers();
                this.updateList();
            }
        }));
        sectionPanel.addSeparator();
        BreezeButton breezeButton = EntryMainHelper.createButton("Load", "material/file_open", averageSpectralViewer::load);
        breezeButton.setToolTipText("Load spectra and add as pinned");
        sectionPanel.addComponent(breezeButton);
        sectionPanel.addSeparator();
        sectionPanel.addComponent(EntryMainHelper.createButton("Help", "material/help", averageSpectralViewer::help));
        this.mainPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(this.mainPanel);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.addSectionFill("Spectra");
        sectionPanel2.getPanel().setLayout(new BorderLayout());
        sectionPanel2.getPanel().add((Component)breezeScrollPane, "Center");
    }

    private List getListForSelected() {
        if (this.pinnedList.contains(this.selected)) {
            return this.pinnedList;
        }
        return this.averageList;
    }

    private void swap(List list, int n, int n2) {
        Object e = list.get(n2);
        Object e2 = list.get(n);
        list.set(n2, e2);
        list.set(n, e);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void updateList() {
        if (this.isVisible()) {
            GridBagConstraints gridBagConstraints;
            this.mainPanel.removeAll();
            AveragePlotPanel.LiveWrapper liveWrapper = this.viewer.getLiveWrapper();
            if (liveWrapper != null) {
                this.addList(List.of(liveWrapper), false);
            }
            this.pinnedList = this.viewer.getPinnedWrappers();
            if (!this.pinnedList.isEmpty()) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                gridBagConstraints.insets = new Insets(0, 0, 4, 0);
                gridBagConstraints.anchor = 17;
                this.mainPanel.add((Component)new BreezeLabel("Pinned", false, 12), gridBagConstraints);
                this.addList(this.pinnedList, true);
            }
            this.averageList = this.viewer.getSampleWrappers();
            if (!this.averageList.isEmpty()) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                gridBagConstraints.insets = new Insets(10, 0, 4, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                this.mainPanel.add((Component)new BreezeLabel("Areas (average spectra)", false, 12), gridBagConstraints);
                this.addList(this.averageList, true);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                gridBagConstraints.insets = new Insets(10, 0, 4, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
                this.mainPanel.add((Component)EntryMainHelper.createButton("Delete all", "explore/delete", () -> {
                    this.viewer.clear();
                    this.updateList();
                }), gridBagConstraints);
            }
            if (this.mainPanel.getComponentCount() == 0) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                this.mainPanel.add((Component)new BreezeLabel("No spectrum selected", false, 12), gridBagConstraints);
            } else {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = Short.MAX_VALUE;
                gridBagConstraints.weighty = 1.0;
                this.mainPanel.add((Component)new JPanel(new BorderLayout()), gridBagConstraints);
            }
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    private void addList(final List<? extends DataWrapper> list, final boolean bl) {
        for (final DataWrapper dataWrapper : list) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.mainPanel.getComponentCount();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            final CatClass catClass = new CatClass(dataWrapper.getName(), null);
            catClass.setColor(dataWrapper.getColor());
            final JComponent jComponent = bl ? new BreezeButton() : new BreezeCheckBox("", this.viewer.showLiveSpectrum());
            DeleteCatClassInputField deleteCatClassInputField = new DeleteCatClassInputField(catClass, jComponent, new DeleteCatClassInputField.OnChangeCallback(){
                final /* synthetic */ AverageSpectralViewerLegend this$0;
                {
                    this.this$0 = averageSpectralViewerLegend;
                }

                @Override
                public void onChange(DeleteCatClassInputField deleteCatClassInputField) {
                    dataWrapper.setName(catClass.getName());
                    dataWrapper.setColor(catClass.getColor());
                    this.this$0.viewer.drawWrappersAndRepaint();
                }

                @Override
                public void action() {
                    if (bl) {
                        list.remove(dataWrapper);
                        this.this$0.viewer.delete(dataWrapper);
                        this.this$0.updateList();
                    } else {
                        this.this$0.viewer.setShowLiveSpectrum(((BreezeCheckBox)jComponent).isSelected());
                    }
                }
            });
            BreezeInputField breezeInputField = deleteCatClassInputField.getLabelField();
            BreezeTextField breezeTextField = breezeInputField.getTextField();
            breezeTextField.getTextField().setFont(new Font("Tahoma", 0, 10));
            breezeInputField.getLabel().setVisible(false);
            if (this.selected == dataWrapper) {
                SwingUtilities.invokeLater(breezeInputField::requestFocusAndSelectAll);
            }
            deleteCatClassInputField.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ AverageSpectralViewerLegend this$0;
                {
                    this.this$0 = averageSpectralViewerLegend;
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    this.this$0.selected = dataWrapper;
                }
            });
            this.mainPanel.add((Component)deleteCatClassInputField, gridBagConstraints);
        }
    }

    @Override
    public String getDescription() {
        return "Sample areas";
    }
}

