/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.util.average;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.common.util.average.AverageSpectralViewer;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.table.SegmentationPanel;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.register.RegInfo;

public class AverageSpectrumSettingsPanel
extends DefaultSettingsPanel {
    private BreezeSpinnerInputPanel maxInputField;
    private final BreezeComboBoxInputField<RtFramePredictor.ReferenceConvertTo> convertToComboBox;
    public RtFramePredictor.ReferenceConvertTo convertTo = RtFramePredictor.ReferenceConvertTo.None;
    private AbstractRubberband.RubberType previousShapeType = AbstractRubberband.RubberType.Rectangle;
    private final ButtonGroup modeButtonGroup = new ButtonGroup();
    private final ButtonGroup selectionButtonGroup = new ButtonGroup();
    private Measurement measurement;
    private final BreezeCheckBox autoAdjustCheckBox;
    private final AverageSpectralViewer viewer;
    private final SegmentationPanel segmentationPanel;
    private final JPanel plotsPanel = new JPanel(new GridBagLayout());
    private boolean updating;
    public static boolean shownedDuringSession = true;

    public AverageSpectrumSettingsPanel(EntryMainPanel entryMainPanel, AverageSpectralViewer averageSpectralViewer, boolean bl2) {
        super(300, false);
        DefaultSettingsPanel.SectionPanel sectionPanel;
        this.viewer = averageSpectralViewer;
        BasicPreviewPanel basicPreviewPanel = averageSpectralViewer.panel;
        this.segmentationPanel = new SegmentationPanel(BreezeInputFieldHelper.Format.TwoRows, bl -> averageSpectralViewer.panel.repaint());
        this.convertToComboBox = new BreezeComboBoxInputField("Spectral data", "", BreezeInputFieldHelper.Format.TwoRows);
        this.convertToComboBox.getComboBox().setMinimumSize(new Dimension(120, 26));
        this.convertToComboBox.getComboBox().setPreferredSize(new Dimension(120, 26));
        this.convertToComboBox.setChangedListener(referenceConvertTo -> {
            if (!this.updating) {
                this.convertTo = referenceConvertTo;
                this.setMaxValue(this.measurement);
                averageSpectralViewer.updateTitle();
                averageSpectralViewer.resetLiveSpectrum();
                averageSpectralViewer.updateSamples();
            }
        });
        if (bl2) {
            sectionPanel = this.addSection("Analysis data");
            sectionPanel.addComponentHorizontal(this.segmentationPanel);
        }
        sectionPanel = this.addSection("Mouse mode");
        sectionPanel.addComponent(new BreezeToggleButton("Add area", "material/add", this.modeButtonGroup, true, () -> {
            basicPreviewPanel.getRenderer().setSelectionMode(BasicPreviewPanel.SelectionMode.Add);
            basicPreviewPanel.getRenderer().setSelectionTool(this.previousShapeType);
            this.EnableAndUpdateShapeButtons(true);
        }));
        sectionPanel.addComponent(new BreezeToggleButton("Select areas", "explore/select_rect", this.modeButtonGroup, false, () -> {
            basicPreviewPanel.getRenderer().setSelectionMode(BasicPreviewPanel.SelectionMode.Selection);
            basicPreviewPanel.getRenderer().setSelectionTool(this.previousShapeType);
            this.EnableAndUpdateShapeButtons(true);
        }));
        sectionPanel.addComponent(new BreezeToggleButton("Move area", "explore/pan", this.modeButtonGroup, false, () -> {
            basicPreviewPanel.getRenderer().setSelectionMode(BasicPreviewPanel.SelectionMode.Move);
            this.EnableAndUpdateShapeButtons(false);
        }));
        sectionPanel.addComponentLast(new BreezeToggleButton("Zoom", "explore/zoom_area", this.modeButtonGroup, false, () -> {
            basicPreviewPanel.getRenderer().setSelectionMode(BasicPreviewPanel.SelectionMode.Zoom);
            basicPreviewPanel.getRenderer().setSelectionTool(AbstractRubberband.RubberType.Rectangle);
            this.EnableAndUpdateShapeButtons(false);
        }));
        this.EnableAndUpdateShapeButtons(false);
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.addSection("Selection shape");
        for (AbstractRubberband.RubberType rubberType : new AbstractRubberband.RubberType[]{AbstractRubberband.RubberType.Freehand, AbstractRubberband.RubberType.Ellipse, AbstractRubberband.RubberType.Rectangle, AbstractRubberband.RubberType.Normal}) {
            BreezeToggleButton breezeToggleButton = new BreezeToggleButton(rubberType.iconName(), "selection" + rubberType.name(), this.selectionButtonGroup, rubberType.equals((Object)AbstractRubberband.RubberType.Rectangle), () -> {
                this.previousShapeType = rubberType;
                basicPreviewPanel.getRenderer().setSelectionTool(rubberType);
            });
            if (rubberType.equals((Object)AbstractRubberband.RubberType.Normal)) {
                sectionPanel2.addComponentLast(breezeToggleButton);
                continue;
            }
            sectionPanel2.addComponent(breezeToggleButton);
        }
        DefaultSettingsPanel.SectionPanel sectionPanel3 = this.addSection("Spectral plots");
        sectionPanel3.addComponent(EntryMainHelper.createButton("Add", "explore/library_add", () -> averageSpectralViewer.addPlot(AveragePlotPanel.AbstractPlot.PlotTypes.Spectrum, "")));
        sectionPanel3.addSeparator();
        sectionPanel3.addComponentLast(EntryMainHelper.createButton("Switch layout", "material/rotate_90_degrees_ccw", averageSpectralViewer::switchView));
        if (bl2) {
            sectionPanel3.addComponentHorizontal(this.convertToComboBox);
        }
        this.plotsPanel.setOpaque(false);
        sectionPanel3.addComponentVertical(this.plotsPanel, 10);
        DefaultSettingsPanel.SectionPanel sectionPanel4 = this.addSection("Y axis");
        this.autoAdjustCheckBox = new BreezeCheckBox("Auto adjust", true, bl -> averageSpectralViewer.forEach(averagePlotPanel -> {
            averagePlotPanel.setYMax(bl ? null : Double.valueOf(this.maxInputField.getValueDouble()));
            this.maxInputField.setEnabled(!bl);
        }));
        sectionPanel4.addComponentHorizontal(this.autoAdjustCheckBox);
        this.maxInputField = new BreezeSpinnerInputPanel("Max", "", 0.0f, 0.0f, 1.0f, 0.0f, BreezeInputFieldHelper.Format.OneRow, BreezeSpinner.NumberInputLocation.LEFT, "", d -> {
            if (this.autoAdjustCheckBox.isSelected()) {
                averageSpectralViewer.forEach(averagePlotPanel -> averagePlotPanel.setYMax(null));
            } else {
                averageSpectralViewer.forEach(averagePlotPanel -> averagePlotPanel.setYMax((Double)d));
            }
        });
        sectionPanel4.addComponentHorizontal(this.maxInputField);
        sectionPanel4.setVisible(false);
    }

    private void EnableAndUpdateShapeButtons(Boolean bl) {
        Enumeration<AbstractButton> enumeration = this.selectionButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            BreezeToggleButton breezeToggleButton = (BreezeToggleButton)enumeration.nextElement();
            breezeToggleButton.setEnabled(bl);
            if (!breezeToggleButton.getText().equals(this.previousShapeType.iconName())) continue;
            breezeToggleButton.setSelected(true);
        }
        this.EnableModeButtons();
    }

    public void EnableModeButtons() {
        Enumeration<AbstractButton> enumeration = this.modeButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            BreezeToggleButton breezeToggleButton = (BreezeToggleButton)enumeration.nextElement();
            if (!breezeToggleButton.getText().equals("Select areas") && !breezeToggleButton.getText().equals("Move area")) continue;
            breezeToggleButton.setEnabled(!this.viewer.samples.isEmpty());
        }
    }

    public void addRightButtons(BreezeMainPanel breezeMainPanel) {
        BreezeButton breezeButton;
        breezeMainPanel.addRightButton(this.segmentationPanel);
        breezeMainPanel.addRightButton(this.convertToComboBox);
        if (RegInfo.isApplicationFeature()) {
            breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
            breezeButton = EntryMainHelper.createButton("Add Sample(s)", "explore/docs_add_on", () -> this.viewer.addAllSamples(breezeMainPanel));
            breezeButton.setToolTipText("Add Sample(s) in Table from selected pixels");
            breezeMainPanel.addRightButton(breezeButton);
        }
        if (EvinceHelper.exists()) {
            breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
            breezeButton = EntryMainHelper.createButton("Open in Evince", "Evince_24", () -> EvinceHelper.startEvince(breezeMainPanel.getSelectedEntries()));
            breezeMainPanel.addRightButton(breezeButton);
        }
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
        this.updating = true;
        this.segmentationPanel.updateSegmentations(measurement.getWorkflow());
        this.convertToComboBox.setItems(RtFramePredictor.ReferenceConvertTo.supported(measurement));
        this.convertTo = measurement.getWorkflow().getPixelExploreReferenceConvertTo();
        this.convertToComboBox.setSelectedItem(this.convertTo);
        this.setMaxValue(measurement);
        this.updateFilters();
        this.updating = false;
    }

    public void updateFilters() {
        this.plotsPanel.removeAll();
        IntHolder intHolder = new IntHolder(1);
        this.viewer.forEach(averagePlotPanel -> {
            FunctionParameterCustomInput.EditTransformationPanel editTransformationPanel = averagePlotPanel.transformationPanel;
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()), "Plot " + intHolder.getValue());
            titledBorder.setTitleColor(BreezeTheme.getInstance().getLabelForeground());
            editTransformationPanel.setBorder(titledBorder);
            EntryMainHelper.addComponentVertical(this.plotsPanel, editTransformationPanel, false, intHolder.getValue(), 0, 1, 0);
            intHolder.increase();
        });
        this.plotsPanel.revalidate();
        this.plotsPanel.repaint();
    }

    private void setMaxValue(Measurement measurement) {
        float f = measurement.getMaxSignal().value;
        if (measurement.hasReferences() && !this.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.None)) {
            f = 10.0f;
        }
        this.maxInputField.setMax(f);
        this.maxInputField.setStep(f / 100.0f);
        this.maxInputField.setValue(f);
    }

    public RtFramePredictor.ReferenceConvertTo getConvertTo() {
        return this.convertTo;
    }

    @Override
    public String getDescription() {
        return "Toolbar";
    }

    @Override
    public void toggled(boolean bl) {
        shownedDuringSession = bl;
        super.toggled(shownedDuringSession);
    }
}

